/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.unitdefs.file;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.type.Handle;
import com.dassault.cecilia.lib.ban.unitdefs.file.HandleReaderFile;
import com.dassault.cecilia.lib.ban.unitdefs.file.HandleWriterFile;
import java.io.File;
import java.io.IOException;

public class FOpen
extends Unit {
    private String _id;
    private AccessFile _access = AccessFile.read;
    String _file;
    String _fileRefId;

    public void setId(String value) {
        if (this._id != null) {
            this.log("File 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    public void setAccess(String value) {
        if (value.equalsIgnoreCase("read")) {
            this._access = AccessFile.read;
        } else if (value.equalsIgnoreCase("write")) {
            this._access = AccessFile.write;
        } else if (value.equalsIgnoreCase("append")) {
            this._access = AccessFile.append;
        } else {
            throw new BanProcessException("Attribute access='" + value + "' unknow");
        }
    }

    private void verifySetFile() {
        if (this._file != null) {
            throw new BanProcessException("file already define : " + this._file);
        }
        if (this._fileRefId != null) {
            throw new BanProcessException("fileref already define : " + this._fileRefId);
        }
    }

    public void setFile(String value) {
        this.verifySetFile();
        this._file = value;
    }

    public void setFileref(String value) {
        this.verifySetFile();
        this._fileRefId = value;
    }

    public void startValid() {
        if (this._id == null) {
            throw new BanProcessException("No attribute 'id' define");
        }
        if (this._file == null && this._fileRefId == null) {
            throw new BanProcessException("No attribut 'file' or 'fileref' define");
        }
    }

    protected File getFile() {
        File file = null;
        if (this._file != null) {
            file = new File(this.expanse(this._file));
        } else if (this._fileRefId != null) {
            String fileRef = this.expanse(this._fileRefId);
            if (!this.isSimpleID(fileRef)) {
                throw this.errorComplexId("fileref", fileRef, this._fileRefId);
            }
            Object obj = this.getProcess().getIdObject(fileRef);
            if (obj == null) {
                throw new BanProcessException("File '" + fileRef + "' unknow");
            }
            if (!(obj instanceof File)) {
                throw new BanProcessException("Object with id '" + fileRef + "' is not file");
            }
            file = (File)obj;
        } else {
            throw new BanProcessException("Internal error");
        }
        return file;
    }

    @Override
    public void execute() {
        String id = this.expanse(this._id);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("id", id, this._id);
        }
        File file = this.getFile();
        Handle hdl = null;
        try {
            switch (this._access) {
                case read: {
                    hdl = new HandleReaderFile(file);
                    break;
                }
                case write: {
                    hdl = new HandleWriterFile(file);
                    break;
                }
                case append: {
                    hdl = new HandleWriterFile(file, true);
                }
            }
        }
        catch (IOException e) {
            throw new BanProcessException("fopen ioexception", e);
        }
        this.getProcess().setIdObject(id, hdl);
    }

    public static enum AccessFile {
        read,
        write,
        append;

    }
}

