/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FileUtility {
    protected static boolean __WIN = System.getProperty("os.name").contains("Win");

    protected static String getPrimaryPath(File ref, File access) {
        String name;
        Object path = "";
        ArrayList<String> refp = new ArrayList<String>();
        for (File cur = ref; cur != null; cur = cur.getParentFile()) {
            String name2 = cur.getName();
            if (name2.length() == 0) {
                name2 = cur.getAbsolutePath();
            }
            refp.add(name2);
        }
        ArrayList<String> accp = new ArrayList<String>();
        for (File cur = access; cur != null; cur = cur.getParentFile()) {
            name = cur.getName();
            if (name.length() == 0) {
                name = cur.getAbsolutePath();
            }
            accp.add(name);
        }
        if (refp.size() == 0 || accp.size() == 0) {
            return path;
        }
        if (refp.get(refp.size() - 1).equals(accp.get(accp.size() - 1))) {
            boolean equal = true;
            while (equal && refp.size() > 1 && accp.size() > 1) {
                refp.remove(refp.size() - 1);
                accp.remove(accp.size() - 1);
                equal = refp.get(refp.size() - 1).equals(accp.get(accp.size() - 1));
            }
            if (refp.size() == 1) {
                if (!equal) {
                    refp.remove(refp.size() - 1);
                    path = (String)path + "..";
                } else {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                    path = (String)path + ".";
                }
            } else {
                if (equal && accp.size() == 1) {
                    refp.remove(refp.size() - 1);
                    accp.remove(accp.size() - 1);
                }
                while (refp.size() > 0) {
                    refp.remove(refp.size() - 1);
                    path = (String)path + "..";
                    if (refp.size() <= 0) continue;
                    path = (String)path + File.separator;
                }
            }
            while (accp.size() > 0) {
                name = (String)accp.remove(accp.size() - 1);
                path = (String)path + File.separator;
                path = (String)path + name;
            }
        } else {
            try {
                path = access.getCanonicalPath();
            }
            catch (IOException e) {
                path = access.getAbsolutePath();
                e.printStackTrace();
            }
        }
        return path;
    }

    public static String getDiffPath(File ref, File acc) {
        try {
            File cref = ref.getCanonicalFile();
            File cacc = acc.getCanonicalFile();
            return FileUtility.getPrimaryPath(cref, cacc);
        }
        catch (IOException e) {
            e.printStackTrace();
            return FileUtility.getPrimaryPath(ref, acc);
        }
    }

    public static String getDiffPath(String ref, String acc) {
        File fref = new File(ref);
        File facc = new File(acc);
        return FileUtility.getDiffPath(fref, facc);
    }

    public static void recursifDelete(File path) throws IOException {
        if (!path.exists()) {
            throw new IOException("File not found '" + path.getAbsolutePath() + "'");
        }
        if (path.isDirectory()) {
            File[] children = path.listFiles();
            for (int i = 0; children != null && i < children.length; ++i) {
                FileUtility.recursifDelete(children[i]);
            }
            if (!path.delete()) {
                throw new IOException("No delete path '" + path.getAbsolutePath() + "'");
            }
        } else if (!path.delete()) {
            throw new IOException("No delete file '" + path.getAbsolutePath() + "'");
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        FileInputStream fis = new FileInputStream(src);
        FileOutputStream fos = new FileOutputStream(dest);
        FileChannel channelSrc = fis.getChannel();
        FileChannel channelDest = fos.getChannel();
        channelSrc.transferTo(0L, channelSrc.size(), channelDest);
        fis.close();
        fos.close();
    }

    public static File createSpecifiedFile(String path, String pattern, int base) {
        File file = new File(path);
        if (!file.isDirectory()) {
            return null;
        }
        int cur = base;
        Object[] args;
        String result;
        while ((file = new File(path, result = MessageFormat.format(pattern, args = new Object[]{cur}))).exists()) {
            ++cur;
        }
        return file;
    }

    public static String getBasePath(Class define) {
        String nameRes = define.getName().replace('.', '/') + ".class";
        URL url = define.getClassLoader().getResource(nameRes);
        if (url == null) {
            return null;
        }
        try {
            int pos;
            String urlStr = URLDecoder.decode(url.toString(), "UTF-8");
            if (urlStr.startsWith("jar:file:/")) {
                int pos2 = urlStr.indexOf("!");
                if (pos2 != -1 && (pos2 = (urlStr = urlStr.substring(__WIN ? 10 : 9, pos2)).lastIndexOf("/")) != -1) {
                    return urlStr.substring(0, pos2);
                }
            } else if (urlStr.startsWith("file:/") && (pos = urlStr.lastIndexOf(nameRes)) != -1) {
                return urlStr.substring(__WIN ? 6 : 5, pos);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String findExecutable(String name, String path) {
        if (__WIN) {
            if (name.lastIndexOf(46) == -1) {
                File test = new File(path, name + ".exe");
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
                test = new File(path, name + ".bat");
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
            } else {
                File test = new File(path, name);
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
            }
        } else {
            File test = new File(path, name);
            if (test.exists()) {
                return test.getAbsolutePath();
            }
        }
        return null;
    }

    public static String findExePath(String name, Class define) {
        String find;
        String classPath = FileUtility.getBasePath(define);
        if (classPath != null && (find = FileUtility.findExecutable(name, classPath)) != null) {
            return find;
        }
        String propertyPath = System.getProperty("cecilia.ban.path");
        if (propertyPath != null) {
            for (String path : propertyPath.split(";")) {
                String find2 = FileUtility.findExecutable(name, path);
                if (find2 == null) continue;
                return find2;
            }
        }
        return name;
    }

    private static String findLibrary(String name, String path) {
        if (name.lastIndexOf(46) == -1) {
            if (__WIN) {
                File test = new File(path, name + ".dll");
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
            } else {
                File test = new File(path, "lib" + name + ".so");
                if (test.exists()) {
                    return test.getAbsolutePath();
                }
            }
        } else {
            File test = new File(path, name);
            if (test.exists()) {
                return test.getAbsolutePath();
            }
        }
        return null;
    }

    public static String findLibPath(String name, Class define) {
        String find;
        String find2;
        String classPath = FileUtility.getBasePath(define);
        if (classPath != null && (find2 = FileUtility.findLibrary(name, classPath)) != null) {
            return find2;
        }
        String propertyPath = System.getProperty("cecilia.ban.path");
        if (propertyPath != null && (find = FileUtility.findLibrary(name, propertyPath)) != null) {
            return find;
        }
        return null;
    }

    public static boolean fileConstainRegex(File file, String regex) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            StringWriter out = new StringWriter((int)file.length());
            char[] read = new char[1024];
            int len = 128;
            while ((len = in.read(read)) > 0) {
                out.write(read, 0, len);
            }
            out.flush();
            out.close();
            in.close();
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(out.getBuffer()).find();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

