/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.ban.util;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.type.Var;
import com.dassault.cecilia.lib.ban.util.UtilLaunch;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class UtilExec
extends UtilLaunch {
    String _outFile;
    String _outRefId;
    String _outAppend;
    String _outVar;
    String _outVarName;
    ByteArrayOutputStream _outBuffer;
    String _errFile;
    String _errRefId;
    String _errAppend;
    String _errVar;
    String _errVarName;
    ByteArrayOutputStream _errBuffer;
    String _inFile;
    String _inRefId;
    String _inString;

    private void verifySetOut() {
        if (this._outFile != null) {
            throw new BanProcessException("outfile already define : " + this._outFile);
        }
        if (this._outRefId != null) {
            throw new BanProcessException("outref already define : " + this._outRefId);
        }
        if (this._outVar != null) {
            throw new BanProcessException("outvar already define : " + this._outVar);
        }
    }

    public void setOutfile(String value) {
        this.verifySetOut();
        this._outFile = value;
    }

    public void setOutref(String value) {
        this.verifySetOut();
        this._outRefId = value;
    }

    public void setOutvar(String value) {
        this.verifySetOut();
        this._outVar = value;
    }

    public void setOutappend(String value) {
        this._outAppend = value;
    }

    public OutputStream getOutStream() {
        if (this._outFile != null || this._outRefId != null) {
            File out = null;
            if (this._outFile != null) {
                out = new File(this.expanse(this._outFile));
            } else if (this._outRefId != null) {
                String outRef = this.expanse(this._outRefId);
                if (!this.isSimpleID(outRef)) {
                    throw this.errorComplexId("outref", outRef, this._outRefId);
                }
                Object obj = this.getProcess().getIdObject(outRef);
                if (obj == null) {
                    throw new BanProcessException("File '" + outRef + "' unknow");
                }
                if (!(obj instanceof File)) {
                    throw new BanProcessException("Object with id '" + outRef + "' is not file");
                }
                out = (File)obj;
            }
            if (!out.canWrite()) {
                this.log("Can not read destination file [" + out.getAbsolutePath() + "]", 1);
            }
            boolean append = false;
            if (this._outAppend != null) {
                append = this.castBool(this.expanse(this._outAppend), "outAppend");
            }
            try {
                return new FileOutputStream(out, append);
            }
            catch (FileNotFoundException e) {
                throw new BanProcessException(e);
            }
        }
        if (this._outVar != null) {
            this._outVarName = this.expanse(this._outVar);
            if (!this.isSimpleID(this._outVarName)) {
                throw this.errorComplexId("outVar", this._outVarName, this._outVar);
            }
            this._outBuffer = new ByteArrayOutputStream(256);
            return this._outBuffer;
        }
        return null;
    }

    private void verifySetErr() {
        if (this._errFile != null) {
            throw new BanProcessException("errfile already define : " + this._errFile);
        }
        if (this._errRefId != null) {
            throw new BanProcessException("errref already define : " + this._errRefId);
        }
        if (this._errVar != null) {
            throw new BanProcessException("errvar already define : " + this._errVar);
        }
    }

    public void setErrfile(String value) {
        this.verifySetErr();
        this._errFile = value;
    }

    public void setErrref(String value) {
        this.verifySetErr();
        this._errRefId = value;
    }

    public void setErrvar(String value) {
        this.verifySetErr();
        this._errVar = value;
    }

    public void setErrappend(String value) {
        this._errAppend = value;
    }

    public OutputStream getErrStream() {
        if (this._errFile != null || this._errRefId != null) {
            File err = null;
            if (this._errFile != null) {
                err = new File(this.expanse(this._errFile));
            } else if (this._errRefId != null) {
                String errRef = this.expanse(this._errRefId);
                if (!this.isSimpleID(errRef)) {
                    throw this.errorComplexId("errref", errRef, this._errRefId);
                }
                Object obj = this.getProcess().getIdObject(errRef);
                if (obj == null) {
                    throw new BanProcessException("File '" + errRef + "' unknow");
                }
                if (!(obj instanceof File)) {
                    throw new BanProcessException("Object with id '" + errRef + "' is not file");
                }
                err = (File)obj;
            }
            if (!err.canWrite()) {
                this.log("Can not read destination file [" + err.getAbsolutePath() + "]", 1);
            }
            boolean append = false;
            if (this._errAppend != null) {
                append = this.castBool(this.expanse(this._errAppend), "errAppend");
            }
            try {
                return new FileOutputStream(err, append);
            }
            catch (FileNotFoundException e) {
                throw new BanProcessException(e);
            }
        }
        if (this._errVar != null) {
            this._errVarName = this.expanse(this._errVar);
            if (!this.isSimpleID(this._errVarName)) {
                throw this.errorComplexId("errVar", this._errVarName, this._errVar);
            }
            this._errBuffer = new ByteArrayOutputStream(256);
            return this._errBuffer;
        }
        return null;
    }

    private void verifySetIn() {
        if (this._inFile != null) {
            throw new BanProcessException("infile already define : " + this._inFile);
        }
        if (this._inRefId != null) {
            throw new BanProcessException("inref already define : " + this._inRefId);
        }
        if (this._inString != null) {
            throw new BanProcessException("instring already define : " + this._inString);
        }
    }

    public void setInfile(String value) {
        this.verifySetIn();
        this._inFile = value;
    }

    public void setInref(String value) {
        this.verifySetIn();
        this._inRefId = value;
    }

    public void setInstring(String text) {
        this.verifySetIn();
        this._inString = text;
    }

    public InputStream getInStream() {
        if (this._inFile != null || this._inRefId != null) {
            File in = null;
            if (this._inFile != null) {
                in = new File(this.expanse(this._inFile));
            } else if (this._inRefId != null) {
                String inRef = this.expanse(this._inRefId);
                if (!this.isSimpleID(inRef)) {
                    throw this.errorComplexId("inref", inRef, this._inRefId);
                }
                Object obj = this.getProcess().getIdObject(inRef);
                if (obj == null) {
                    throw new BanProcessException("File '" + inRef + "' unknow");
                }
                if (!(obj instanceof File)) {
                    throw new BanProcessException("Object with id '" + inRef + "' is not file");
                }
                in = (File)obj;
            }
            if (!in.canRead()) {
                this.log("Can not read source file [" + in.getAbsolutePath() + "]", 1);
            }
            try {
                return new FileInputStream(in);
            }
            catch (FileNotFoundException e) {
                throw new BanProcessException(e);
            }
        }
        if (this._inString != null) {
            String str = this.expanse(this._inString);
            return new ByteArrayInputStream(str.getBytes());
        }
        return null;
    }

    protected Var assignValue(String name, Object value) {
        Var var = this.findVariable(name);
        if (var == null) {
            var = new Var(name, "");
            this.getProcess().getRootUnit().addVariable(var);
        }
        if (value != null) {
            var.setValue(value);
        }
        return var;
    }

    public void assignStream() {
        if (this._outBuffer != null) {
            this.assignValue(this._outVarName, this._outBuffer.toString());
        }
        if (this._errBuffer != null) {
            this.assignValue(this._errVarName, this._errBuffer.toString());
        }
    }
}

