/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference;

import com.dassault.cecilia.lib.ban.util.FileUtility;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperInstantaneousLoopException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.inference.InferenceStepperException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

public class StepperInference
implements Stepper {
    private static Logger _LOG = Logger.getLogger(StepperInference.class.getPackage().getName());
    private static boolean _libLoaded = false;
    static Object _locker;
    static boolean _useInstance;
    private int _Id;
    private int[] _Sheduler;
    private static final String PROP_CSTEPPER_LOG_INSTANTLOOP = "cecilia.mbsa.cstepper.InstantLoopLog";
    private static final String PROP_CSTEPPER_LOG_INSTANTLOOP_NBR = "cecilia.mbsa.cstepper.InstantLoopLogTrans";

    public static void loadLibraries() {
        if (_libLoaded) {
            return;
        }
        String filename = FileUtility.findLibPath("CStepper", StepperInference.class);
        if (filename != null) {
            System.load(filename);
        } else {
            System.loadLibrary("CStepper");
        }
        _libLoaded = true;
    }

    private static void useInstance() throws InferenceStepperException {
        if (_useInstance) {
            _LOG.info("Call garbage collector");
            System.gc();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (_useInstance) {
            throw new InferenceStepperException(true);
        }
    }

    StepperInference(int id, int nbr) {
        this._Id = id;
        this._Sheduler = new int[nbr];
    }

    @Override
    public long getUID() {
        return -1L;
    }

    private static native StepperInference synccreateFromFile(String var0, String var1, String var2) throws StepperException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StepperInference createFromFile(String filename, String model, String language) throws StepperException {
        StepperInference.useInstance();
        Object object = _locker;
        synchronized (object) {
            StepperInference stepper = StepperInference.synccreateFromFile(filename, model, language);
            _useInstance = true;
            return stepper;
        }
    }

    private static native StepperInference synccreateFromCompile(String var0, String var1) throws StepperException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized StepperInference createFromCompile(String filename, String language) throws StepperException {
        StepperInference.useInstance();
        Object object = _locker;
        synchronized (object) {
            StepperInference stepper = StepperInference.synccreateFromCompile(filename, language);
            _useInstance = true;
            return stepper;
        }
    }

    private synchronized native void syncfinalize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        Object object = _locker;
        synchronized (object) {
            _LOG.info("StepperInference finalize => ID = " + this._Id);
            this.syncfinalize();
            _useInstance = false;
        }
    }

    private native int syncgetNbrTransition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNbrTransition() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNbrTransition();
        }
    }

    private native String syncgetNameOfTransition(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameOfTransition(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNameOfTransition(idx);
        }
    }

    private native String syncgetDescOfTransition(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDescOfTransition(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetDescOfTransition(idx);
        }
    }

    private native int syncgetNbrState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNbrState() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNbrState();
        }
    }

    private native String syncgetNameOfState(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameOfState(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNameOfState(idx);
        }
    }

    private native double syncgetValueOfState(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValueOfState(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetValueOfState(idx);
        }
    }

    private native String syncgetValueStringOfState(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueStringOfState(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetValueStringOfState(idx);
        }
    }

    private native int syncgetNbrFlow();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNbrFlow() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNbrFlow();
        }
    }

    private native String syncgetNameOfFlow(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameOfFlow(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetNameOfFlow(idx);
        }
    }

    private native double syncgetValueOfFlow(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getValueOfFlow(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetValueOfFlow(idx);
        }
    }

    private native String syncgetValueStringOfFlow(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueStringOfFlow(int idx) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetValueStringOfFlow(idx);
        }
    }

    @Override
    public boolean withDomain() {
        return true;
    }

    private native int syncgetDomainOfFlow(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDomainOfFlow(int i) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetDomainOfFlow(i);
        }
    }

    private native int syncgetDomainOfState(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDomainOfState(int i) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetDomainOfState(i);
        }
    }

    private native String[] syncgetValuesOfDomain(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getValuesOfDomain(int i) {
        Object object = _locker;
        synchronized (object) {
            String[] values = this.syncgetValuesOfDomain(i);
            if (values == null) {
                return null;
            }
            return Arrays.asList(values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        Object object = _locker;
        synchronized (object) {
            return null;
        }
    }

    @Override
    public boolean withSimul() {
        return true;
    }

    private native double syncgetCurrentTime();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getCurrentTime() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetCurrentTime();
        }
    }

    private native int syncgetCurrentCycle();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentCycle() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetCurrentCycle();
        }
    }

    private native int[] syncgetSheduler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSheduler() {
        Object object = _locker;
        synchronized (object) {
            return this.syncgetSheduler();
        }
    }

    private native boolean syncsetSimulOptions(String var1);

    @Override
    public boolean setSimulOptions(List<String> params) {
        StringBuffer sb = new StringBuffer();
        sb.append("< ");
        for (String param : params) {
            sb.append(param);
            sb.append(" ");
        }
        sb.append("instantaneous.loop.log=\"");
        sb.append(Boolean.getBoolean(PROP_CSTEPPER_LOG_INSTANTLOOP));
        sb.append("\" ");
        sb.append("instantaneous.loop.log.trans=\"");
        sb.append(Integer.getInteger(PROP_CSTEPPER_LOG_INSTANTLOOP_NBR, 0));
        sb.append("\" ");
        sb.append(">");
        return this.syncsetSimulOptions(sb.toString());
    }

    private native boolean syncgoInitialState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goInitialState() throws StepperViolatedAssertionException, StepperInstantaneousLoopException {
        Object object = _locker;
        synchronized (object) {
            return this.syncgoInitialState();
        }
    }

    private native double syncisValidTransition(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double isValidTransition(int idx) throws StepperException {
        Object object = _locker;
        synchronized (object) {
            double result = this.syncisValidTransition(idx);
            if (result > 1.7E308) {
                result = Double.POSITIVE_INFINITY;
            }
            return result;
        }
    }

    private native boolean syncgoForward(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goForward(int idTrans) throws StepperViolatedAssertionException, StepperInstantaneousLoopException {
        Object object = _locker;
        synchronized (object) {
            return this.syncgoForward(idTrans);
        }
    }

    private native boolean syncsetValueOfState(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValueOfState(int idx, String value) throws StepperViolatedAssertionException, StepperInstantaneousLoopException {
        Object object = _locker;
        synchronized (object) {
            return this.syncsetValueOfState(idx, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setValueOfState(int idx, double value) throws StepperViolatedAssertionException, StepperInstantaneousLoopException {
        Object object = _locker;
        synchronized (object) {
            return false;
        }
    }

    private native boolean syncsetInitOfState(int var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInitOfState(int i, String value) {
        Object object = _locker;
        synchronized (object) {
            return this.syncsetInitOfState(i, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setInitOfState(int i, double value) {
        Object object = _locker;
        synchronized (object) {
            return false;
        }
    }

    private native boolean syncgoBackward(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goBackward(int nbrTrans) throws StepperException {
        Object object = _locker;
        synchronized (object) {
            return this.syncgoBackward(nbrTrans);
        }
    }

    private native boolean syncgenerateTree(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateTree(String command) {
        Object object = _locker;
        synchronized (object) {
            return this.syncgenerateTree(command);
        }
    }

    private native boolean syncsearchSequences(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean searchSequences(String command) {
        Object object = _locker;
        synchronized (object) {
            return this.syncsearchSequences(command);
        }
    }

    private static native boolean synccoherence(String var0) throws StepperException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean coherence(String command) throws StepperException {
        StepperInference.useInstance();
        Object object = _locker;
        synchronized (object) {
            return StepperInference.synccoherence(command);
        }
    }

    private static native boolean syncflatness(String var0, String var1, String var2) throws StepperException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean flatness(String in, String model, String out) throws StepperException {
        StepperInference.useInstance();
        Object object = _locker;
        synchronized (object) {
            return StepperInference.syncflatness(in, model, out);
        }
    }

    private static native boolean synccompile(String var0, String var1, String var2) throws StepperException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean compile(String in, String model, String out) throws StepperException {
        StepperInference.useInstance();
        Object object = _locker;
        synchronized (object) {
            return StepperInference.synccompile(in, model, out);
        }
    }

    @Override
    public void dispose() {
    }

    static {
        StepperInference.loadLibraries();
        _locker = new Object();
        _useInstance = false;
    }
}

