/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.launcher.DestinationOutputStream;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutSimple;
import com.dassault.cecilia.lib.ban.launcher.LogExecLayoutXML;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecord;
import com.dassault.cecilia.lib.ban.launcher.LogExecRecorder;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.util.FileUtility;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.ban.util.UtilFileSrc;
import com.dassault.cecilia.lib.ban.util.UtilLaunch;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.io.ProcessLauncher;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class IEngine
extends Unit {
    UtilFileSrc _src = new UtilFileSrc();
    UtilFileDst _dst = new UtilFileDst();
    String _append;
    String _model;
    String _failOnError;
    protected List<Param> _options = new ArrayList<Param>();
    protected IExecute _iexecute = null;

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._src.setProcess(process);
        this._dst.setProcess(process);
    }

    public void setSrcfile(String value) {
        this._src.setFile("srcfile", value);
    }

    public void setSrcref(String value) {
        this._src.setRef("srcref", value);
    }

    public void setText(String value) {
        this._src.setText(value);
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    public void setAppend(String value) {
        this._append = value;
    }

    protected boolean appendToDest() {
        boolean result = false;
        if (this._append != null) {
            result = this.castBool(this.expanse(this._append), "append");
        }
        return result;
    }

    public void setModel(String value) {
        this._model = value;
    }

    protected String getModel() {
        if (this._model == null) {
            return "main";
        }
        String result = this.expanse(this._model);
        if (!this.isSimpleID(result)) {
            throw this.errorComplexId("model", result, this._model);
        }
        return result;
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    protected boolean failOnError() {
        boolean result = true;
        if (this._failOnError != null) {
            result = this.castBool(this.expanse(this._failOnError), "failonerror");
        }
        return result;
    }

    public void endValid() {
        this._dst.endValid();
    }

    public Param createParam() {
        Param param = new Param();
        this._options.add(param);
        return param;
    }

    protected Map<String, String> getOptions() {
        return Param.mapParams(this._options);
    }

    protected boolean isExtern() {
        return this._iexecute != null;
    }

    public IExecute createExecute() {
        if (this._iexecute != null) {
            this.log("Element 'execute' already define", 1);
        }
        this._iexecute = new IExecute();
        return this._iexecute;
    }

    public void iExecuteBefore() throws IOException {
    }

    public void iExecuteAfter() throws IOException {
    }

    public void iExecuteFinally() {
    }

    public int launchProcess(File arg) {
        return this._iexecute.launchProcess(arg);
    }

    public class IExecute
    extends BanProcessComponent
    implements LogExecRecorder,
    LayoutDefiner {
        UtilLaunch _launch = new UtilLaunch();
        protected List<destination> _destinations = new ArrayList<destination>();
        List<Destination> _Dests;
        protected Object _lockerLauncher = new Object();
        protected ProcessLauncher _launcher = null;

        @Override
        public void setProcess(BanProcess process) {
            super.setProcess(process);
            this._launch.setProcess(process);
        }

        public File getDir() {
            return this._launch.getDir();
        }

        public long getPriority() {
            return this._launch.getPriority();
        }

        public long getTimeout() {
            return this._launch.getTimeout();
        }

        public void setDir(String value) {
            this._launch.setDir(value);
        }

        public void setExecutable(String value) {
            this._launch.setExecutable(value);
        }

        public void setMemoryout(String value) {
            this._launch.setMemoryout(value);
        }

        public void setPriority(String value) {
            this._launch.setPriority(value);
        }

        public void setTimeout(String value) {
            this._launch.setTimeout(value);
        }

        public void endValid() {
            this._launch.endValid();
            if (this._destinations.size() == 0) {
                destination dest = this.createDestination();
                dest.setName("stdout");
            }
        }

        public destination createDestination() {
            destination app = new destination();
            this._destinations.add(app);
            return app;
        }

        @Override
        public Class<? extends Layout> configureLayout(String key, Map<String, String> params) {
            if (key.equals("default") || key.equals("txt")) {
                return LogExecLayoutSimple.class;
            }
            if (key.equals("xml")) {
                return LogExecLayoutXML.class;
            }
            throw new BanProcessException("layout unknow for diff unit : " + key);
        }

        protected void openDestination() {
            this._Dests = new ArrayList<Destination>();
            for (destination dest : this._destinations) {
                this._Dests.add(dest.constructDestination(this));
            }
        }

        @Override
        public void addRecord(LogExecRecord record) {
            if (this._Dests == null) {
                return;
            }
            for (Destination dest : this._Dests) {
                dest.publish(record);
            }
        }

        protected void closeDestination() {
            if (this._Dests == null) {
                return;
            }
            for (Destination dest : this._Dests) {
                dest.close();
            }
            this._Dests = null;
        }

        protected void findExecutable(ArrayList<String> cmds) {
            String execute = "CStepper";
            execute = this._launch.getExecutable() != null ? this.expanse(this._launch.getExecutable()) : FileUtility.findExePath(execute, this.getClass());
            cmds.add(execute);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int launchProcess(File arg) {
            int result = -1;
            long timeOut = this._launch.getTimeout();
            File dir = this._launch.getDir();
            ArrayList<String> cmds = new ArrayList<String>();
            this.findExecutable(cmds);
            cmds.add(arg.getAbsolutePath());
            this.openDestination();
            try {
                IEngine.this.iExecuteBefore();
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "Launch [CStepper] at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n"));
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n//Trace CStepper : \n"));
                Object cmdsArray = new String[1];
                Object object = this._lockerLauncher;
                synchronized (object) {
                    this._launcher = new ProcessLauncher((OutputStream)new DestinationOutputStream(this, true), (OutputStream)new DestinationOutputStream(this, false), timeOut);
                }
                result = this._launcher.exec(cmds.toArray((T[])cmdsArray), null, dir);
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n"));
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "ExitValue : " + result + " at " + DateFormat.getDateTimeInstance().format(new Date()) + "\n"));
                IEngine.this.iExecuteAfter();
            }
            catch (IOException e) {
                this.addRecord(new LogExecRecord(LogExecRecord.LogType.INFO, "//------------------------------------------\n"));
                this.addRecord(new LogExecRecord(e));
                if (IEngine.this.failOnError()) {
                    throw new BanProcessException(this.getClass().getSimpleName() + " : IOException", e);
                }
            }
            finally {
                IEngine.this.iExecuteFinally();
                Object object = this._lockerLauncher;
                synchronized (object) {
                    this._launcher = null;
                }
                this.closeDestination();
            }
            return result;
        }
    }
}

