/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.inference.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.inference.StepperInference;
import com.dassault.cecilia.lib.mbsa.inference.ban.IEngine;
import com.dassault.cecilia.lib.mbsa.stepper.BanStepper;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class IEngineWithStepper
extends IEngine
implements UnitValued {
    int _result;
    String _stepperId;
    protected List<BanTarget> _targets = new ArrayList<BanTarget>();

    @Override
    public void freeResult() {
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected StepperInference getStepper() throws StepperException {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof Stepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper");
        }
        if (obj instanceof BanStepper) {
            obj = ((BanStepper)obj).getOwnerStepper();
        }
        if (obj instanceof StepperInference) {
            return (StepperInference)obj;
        }
        throw new BanProcessException("Don't find StepperInference");
    }

    public BanTarget createTarget() {
        BanTarget tgt = new BanTarget();
        this._targets.add(tgt);
        return tgt;
    }

    @Override
    public void endValid() {
        super.endValid();
        if (this._targets.size() == 0) {
            throw new BanProcessException("There are no 'target' elements");
        }
        if (!this.isExtern() && this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
    }

    protected abstract void writeCmdExtern(Writer var1, File var2, File var3, String var4, BanTarget var5, boolean var6) throws IOException;

    protected abstract boolean launchEngine(StepperInference var1, File var2, BanTarget var3, boolean var4) throws StepperException;

    @Override
    public void execute() {
        if (this.isExtern()) {
            this.executeExtern();
        } else {
            this.executeStepper();
        }
    }

    protected void executeStepper() {
        this._result = 0;
        File dst = this._dst.getDstFile();
        try {
            StepperInference stepper = this.getStepper();
            boolean append = this.appendToDest();
            for (BanTarget tgt : this._targets) {
                if (!this.launchEngine(stepper, dst, tgt, append)) {
                    ++this._result;
                }
                append = true;
            }
        }
        catch (StepperException e) {
            if (this.failOnError()) {
                throw new BanProcessException(e);
            }
            this.log(e.getMessage(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeExtern() {
        this._result = 0;
        File src = this._src.getSrcFile();
        File dst = this._dst.getDstFile();
        String model = this.getModel();
        boolean append = this.appendToDest();
        for (BanTarget tgt : this._targets) {
            File fileCmd = null;
            try {
                OutputStreamWriter writerCmd = null;
                try {
                    fileCmd = this.createTempFile("InfCmd", ".xmi");
                    writerCmd = new FileWriter(fileCmd);
                    this.writeCmdExtern(writerCmd, src, dst, model, tgt, append);
                    writerCmd.close();
                }
                catch (IOException e) {
                    if (this.failOnError()) {
                        throw new BanProcessException(e);
                    }
                    this.log(e.getMessage(), 0);
                }
                finally {
                    if (writerCmd != null) {
                        try {
                            writerCmd.close();
                        }
                        catch (IOException e) {
                            this.log(e.getMessage(), 0);
                        }
                    }
                }
                if (this.launchProcess(fileCmd) != 0) {
                    ++this._result;
                }
            }
            finally {
                if (fileCmd != null && !fileCmd.delete()) {
                    this.log("Not delete file : " + fileCmd.getAbsolutePath(), 1);
                    fileCmd.deleteOnExit();
                }
            }
            append = true;
        }
    }
}

