/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefEquipment;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSimulator;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JState;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public abstract class JDefComponent
extends JDefNode {
    private HashMap _states;

    public JDefComponent(String name) throws JCreateException {
        super(name);
    }

    public JDefComponent(String name, JDefEquipment parent) throws JCreateException {
        super(name, parent);
    }

    @Override
    protected void create() {
        super.create();
        this._states = new HashMap();
    }

    public void addState(JState var) {
        if (this._states == null) {
            this._states = new HashMap();
        }
        this._states.put(var.getName(), var);
    }

    @Override
    public JVariable getState(String name) {
        return (JState)this._states.get(name);
    }

    @Override
    public JVariable getVariable(String name) {
        JVariable state = (JVariable)this._states.get(name);
        if (state != null) {
            return state;
        }
        return super.getVariable(name);
    }

    @Override
    public void compile(JSimulator simulator) {
        super.compile(simulator);
        Iterator i = this._states.values().iterator();
        while (i.hasNext()) {
            simulator.addState((JVariable)i.next());
        }
    }

    @Override
    public void init(boolean withIn) throws StepperViolatedAssertionException {
        super.init(withIn);
        Iterator i = this._states.values().iterator();
        while (i.hasNext()) {
            ((JVariable)i.next()).init();
        }
    }

    @Override
    public void print(IndentWriter out) throws IOException {
        out.write("Node : ");
        StringBuffer sb = new StringBuffer(128);
        if (this.getNode() != null) {
            this.getNode().getPathName(sb);
        }
        sb.append(this.getName());
        out.write(sb.toString());
        out.write("\n");
        out.addIndent(1);
        this.printFlows(out);
        if (this._states.size() > 0) {
            out.write("State\n");
            out.addIndent(1);
            Iterator i = this._states.values().iterator();
            while (i.hasNext()) {
                ((JVariable)i.next()).print(out);
            }
            out.addIndent(-1);
        }
        this.printEvents(out);
        this.printTranss(out);
        out.addIndent(-1);
        out.write("\n");
    }
}

