/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JEvent;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSimulator;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTransSync;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JVariable;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public abstract class JDefEquipment
extends JDefNode {
    private ArrayList _syncs;
    private HashMap _subs;
    protected static final long LIMIT_NBR_TRANS_FLATNESS = 8192L;

    public JDefEquipment(String name) throws JCreateException {
        super(name);
    }

    public JDefEquipment(String name, JDefEquipment parent) throws JCreateException {
        super(name, parent);
    }

    @Override
    protected void create() {
        super.create();
        this._syncs = new ArrayList();
        this._subs = new HashMap();
    }

    @Override
    public JVariable getFlow(String name) {
        int pos = name.indexOf(".");
        if (pos != -1) {
            JDefNode sub = this.getSub(name.substring(0, pos));
            return sub.getFlow(name.substring(pos + 1));
        }
        return super.getFlow(name);
    }

    @Override
    public JVariable getState(String name) {
        int pos = name.indexOf(".");
        if (pos != -1) {
            JDefNode sub = this.getSub(name.substring(0, pos));
            return sub.getState(name.substring(pos + 1));
        }
        return super.getFlow(name);
    }

    @Override
    public JEvent getEvent(String name) {
        int pos = name.indexOf(".");
        if (pos != -1) {
            JDefNode sub = this.getSub(name.substring(0, pos));
            return sub.getEvent(name.substring(pos + 1));
        }
        return super.getEvent(name);
    }

    @Override
    public JVariable getVariable(String name) {
        JVariable var = super.getVariable(name);
        if (var != null) {
            return var;
        }
        var = this.getState(name);
        if (var != null) {
            return var;
        }
        throw new NullPointerException("No variable named '" + name + "'");
    }

    public void addSub(JDefNode sub) {
        this._subs.put(sub.getName(), sub);
    }

    public JDefNode getSub(String name) {
        return (JDefNode)this._subs.get(name);
    }

    public void addSync(String vector) throws JCreateException {
        JSync sync = new JSync(vector);
        this._syncs.add(sync);
    }

    private void createSync(JSync sync, int idx, List transs) {
        if (idx < sync._events.size()) {
            JEvent evt = (JEvent)sync._events.get(idx);
            for (JTrans trans : evt.getTranss()) {
                transs.add(trans);
                this.createSync(sync, idx + 1, transs);
                transs.remove(trans);
            }
        } else {
            JTransSync tr = new JTransSync(sync.getFirstEvent(), this, sync._type == 1, transs);
            this.addTrans(tr);
        }
    }

    private long nbrTransFlatness(JSync sync) {
        long result = 1L;
        for (int idx = 0; idx < sync._events.size(); ++idx) {
            JEvent evt = (JEvent)sync._events.get(idx);
            int size = evt.getTranss().size();
            if (size == 0) continue;
            if (Long.MAX_VALUE / (long)size < result) {
                return Long.MAX_VALUE;
            }
            result *= (long)size;
        }
        return result;
    }

    public void createAllSync() throws JCreateException {
        for (JSync sync : this._syncs) {
            long nbrTrans = this.nbrTransFlatness(sync);
            if (nbrTrans <= 8192L) continue;
            throw new JCreateException(MessageFormat.format(MsgJStep.getString("EXC_SYNC_FLATNESS_ERROR"), sync.getFirstEvent().getName(), this.getName(), nbrTrans, this.getNodeName()));
        }
        LinkedList<JEvent> removeEvent = new LinkedList<JEvent>();
        ArrayList<JEvent> retainEvent = new ArrayList<JEvent>();
        for (JSync sync : this._syncs) {
            double delay = -1.0;
            for (int i = 0; i < sync._events.size(); ++i) {
                double eDelay;
                JEvent evt = (JEvent)sync._events.get(i);
                if (i > 0 && (eDelay = evt.getDelay()) > delay) {
                    delay = eDelay;
                }
                if (i == 0) {
                    retainEvent.add(evt);
                    continue;
                }
                removeEvent.add(evt);
            }
            if (sync._events.size() <= 1) continue;
            JEvent evt = (JEvent)sync._events.get(0);
            if (!(delay >= 0.0) || !evt.isStochastic()) continue;
            evt.setDelay(delay);
        }
        removeEvent.removeAll(retainEvent);
        for (JSync sync : this._syncs) {
            if (sync._type == 2 || sync._events.size() <= 1) continue;
            ArrayList transs = new ArrayList();
            this.createSync(sync, 1, transs);
        }
        for (JEvent evt : removeEvent) {
            evt.detach();
        }
        this._syncs.clear();
    }

    @Override
    public void compile(JSimulator simulator) {
        super.compile(simulator);
        Iterator i = this._subs.values().iterator();
        while (i.hasNext()) {
            ((JDefNode)i.next()).compile(simulator);
        }
    }

    @Override
    public void init(boolean withIn) throws StepperViolatedAssertionException {
        Iterator i = this._subs.values().iterator();
        while (i.hasNext()) {
            ((JDefNode)i.next()).init(withIn);
        }
        super.init(true);
    }

    @Override
    public void propageFlag(int value) {
        super.propageFlag(value);
        Iterator i = this._subs.values().iterator();
        while (i.hasNext()) {
            ((JDefNode)i.next()).propageFlag(value);
        }
    }

    @Override
    public void print(IndentWriter out) throws IOException {
        out.write("Node : ");
        out.write(this.getPathName());
        out.write("\n");
        out.addIndent(1);
        this.printFlows(out);
        this.printEvents(out);
        if (this._subs.size() > 0) {
            out.write("Sub\n");
            out.addIndent(1);
            Iterator i = this._subs.values().iterator();
            while (i.hasNext()) {
                ((JDefNode)i.next()).print(out);
            }
            out.addIndent(-1);
        }
        this.printTranss(out);
        out.addIndent(-1);
        out.write("\n");
    }

    class JSync {
        ArrayList _events = new ArrayList();
        int _type = -1;

        JSync(String vector) throws JCreateException {
            switch (vector.charAt(0)) {
                case '&': {
                    this._type = 0;
                    break;
                }
                case '|': {
                    this._type = 1;
                    break;
                }
                case '?': {
                    this._type = 2;
                    break;
                }
                default: {
                    throw new JCreateException(MsgJStep.getString("EXC_INTERNAL_ERROR"));
                }
            }
            StringTokenizer st = new StringTokenizer(vector.substring(1), ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                JEvent evt = JDefEquipment.this.getEvent(tok);
                if (evt == null) {
                    throw new JCreateException(MessageFormat.format(MsgJStep.getString("EXC_EVENT_UNKNOW"), tok));
                }
                this._events.add(evt);
            }
        }

        JEvent getFirstEvent() {
            return (JEvent)this._events.get(0);
        }
    }
}

