/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JEvent {
    private String _name;
    private JDefNode _parent;
    private double _delay = Double.POSITIVE_INFINITY;
    private ArrayList<JTrans> _transs = new ArrayList();
    private int _priority = 0;

    public JEvent(String name, JDefNode parent) {
        this._name = name;
        this._parent = parent;
    }

    public void setDelay(double val) {
        this._delay = val;
    }

    public void setPriority(int val) {
        this._priority = val;
    }

    public String getName() {
        return this._name;
    }

    public JDefNode getNode() {
        return this._parent;
    }

    public boolean isInstantaneous() {
        return this._delay == 0.0;
    }

    public boolean isStochastic() {
        return this._delay == Double.POSITIVE_INFINITY;
    }

    public double getDelay() {
        return this._delay;
    }

    public int getPriority() {
        return this._priority;
    }

    public String getPathName() {
        StringBuffer sb = new StringBuffer(256);
        this._parent.getPathName(sb);
        sb.append(this._name);
        return sb.toString();
    }

    public void addTrans(JTrans tr) {
        if (!this._transs.contains(tr)) {
            this._transs.add(tr);
        }
    }

    public List<JTrans> getTranss() {
        return this._transs;
    }

    public void detach() {
        for (JTrans tr : this._transs) {
            this._parent.removeTrans(tr);
        }
        this._parent.removeEvent(this);
    }

    public void print(IndentWriter out) throws IOException {
        out.write(this.getPathName());
        if (this._delay != Double.POSITIVE_INFINITY) {
            out.write("[");
            out.write(Double.toString(this._delay));
            out.write("]");
        }
        out.write("\n");
    }
}

