/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import java.util.ArrayList;
import java.util.List;

class JRangeDomain
extends JDomain {
    long _min;
    long _max;
    List<String> _values = null;
    List<Double> _doubleValues = null;

    JRangeDomain(long min, long max) {
        this._min = min;
        this._max = max;
    }

    boolean equivalent(long min, long max) {
        if (min != this._min) {
            return false;
        }
        return max == this._max;
    }

    @Override
    public double verify(double value) {
        int i = (int)value;
        return (long)i >= this._min && (long)i <= this._max ? (double)i : Double.NaN;
    }

    @Override
    public String toString(double value) {
        long i = (int)value;
        return Long.toString(i);
    }

    @Override
    public double parse(String strValue) {
        try {
            long res = Long.parseLong(strValue);
            if (res >= this._min && res <= this._max) {
                return res;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Double.NaN;
    }

    @Override
    public String displayScale() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("[");
        sb.append(this._min);
        sb.append(",");
        sb.append(this._max);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public List<String> getValues() {
        if (this._values == null) {
            this._values = new ArrayList<String>((int)(this._max - this._min + 2L));
            for (long i = this._min; i <= this._max; ++i) {
                this._values.add(Long.toString(i));
            }
        }
        return this._values;
    }

    @Override
    public List<Double> getDoubleValues() {
        if (this._doubleValues == null) {
            this._doubleValues = new ArrayList<Double>((int)(this._max - this._min + 2L));
            for (long i = this._min; i <= this._max; ++i) {
                this._doubleValues.add(Double.valueOf(i));
            }
        }
        return this._doubleValues;
    }
}

