/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperConflictDeterministeException;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperInstantaneousLoopException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JSimulator;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JTrans;
import com.dassault.cecilia.lib.util.collection.LinkedStack;
import com.dassault.cecilia.lib.util.collection.Stack;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class JSheduler {
    private JSimulator _simul;
    private ArrayList<JTrans> _shTranss;
    private TreeSet<JTrans> _shedulList = new TreeSet<JTrans>(new Comparator<JTrans>(){

        @Override
        public int compare(JTrans tr1, JTrans tr2) {
            if (tr1.getFiringTime() < tr2.getFiringTime()) {
                return -1;
            }
            if (tr1.getFiringTime() > tr2.getFiringTime()) {
                return 1;
            }
            int diff = tr1.getEvent().getPriority() - tr2.getEvent().getPriority();
            if (diff != 0) {
                return -diff;
            }
            diff = tr1.getIdx() - tr2.getIdx();
            return diff;
        }
    });
    private double _currentTime = 0.0;
    private int _currentLoop = 0;
    private int _loopInstantaneous = 1000;
    private boolean _autoInstantaneous = true;
    private boolean _throwConflictException = false;
    private Stack _stackStep = new LinkedStack();
    private int[] _shedulExtern;

    JSheduler(JSimulator simul) {
        this._simul = simul;
        this._shTranss = new ArrayList((this._simul.getNbrTransition() + 20) / 10);
        for (int i = 0; i < this._simul.getNbrTransition(); ++i) {
            JTrans tr = this._simul.getTransition(i);
            if (tr.getEvent().isStochastic()) continue;
            this._shTranss.add(tr);
        }
        this._shedulExtern = new int[this._shTranss.size() + 1];
    }

    double getCurrentTime() {
        return this._currentTime;
    }

    int getCurrentLoop() {
        return this._currentLoop;
    }

    int[] getSheduler() {
        int idx = 0;
        this._shedulExtern[idx++] = this._shedulList.size();
        for (JTrans tr : this._shedulList) {
            this._shedulExtern[idx++] = tr.getIdx() + 1;
        }
        return this._shedulExtern;
    }

    boolean isInstantaneousFire() {
        return this._autoInstantaneous;
    }

    boolean setSimulOptions(List<String> args) {
        for (String option : args) {
            String key = JSimulator.getKey(option);
            if (key.equals("instantaneous.auto")) {
                this._autoInstantaneous = JSimulator.getValue(option).equals("true");
                continue;
            }
            if (key.equals("instantaneous.loop")) {
                this._loopInstantaneous = Integer.parseInt(JSimulator.getValue(option));
                continue;
            }
            if (!key.equals("exception.conflict.sheduler")) continue;
            this._throwConflictException = JSimulator.getValue(option).equals("true");
        }
        return true;
    }

    void init() {
        this._stackStep.clear();
        this._shedulList.clear();
        for (int i = 0; i < this._shTranss.size(); ++i) {
            JTrans tr = this._shTranss.get(i);
            tr.setFiringTime(Double.POSITIVE_INFINITY);
        }
        this._currentTime = 0.0;
        this._currentLoop = 0;
    }

    boolean canFire(JTrans tr) throws StepperException {
        Iterator<JTrans> itr;
        if (tr.getFiringTime() == this._currentTime && this._currentLoop >= this._loopInstantaneous) {
            if (this._simul.withMonitoring(2)) {
                this._simul.monitor("Exception : Maximum Instantaneous Loop\n");
            }
            StringBuffer sb = new StringBuffer(this._loopInstantaneous * 30);
            sb.append(MessageFormat.format(MsgJStep.getString("EXC_INSTANTANEOUS_LOOP_MAX"), this._loopInstantaneous));
            sb.append("\n\n");
            sb.append("Num\tTr\tEvent\n");
            Iterator i = this._stackStep.iterator();
            while (i.hasNext()) {
                JShedulStep step = (JShedulStep)i.next();
                sb.append(step._loop);
                sb.append("\t");
                sb.append(step._trans.getIdx());
                sb.append("\t");
                sb.append(step._trans.getEvent().getPathName());
                sb.append("\n");
                if (step._loop != 0) continue;
                break;
            }
            throw new StepperInstantaneousLoopException(sb.toString());
        }
        if (this._throwConflictException && !tr.getEvent().isStochastic() && (itr = this._shedulList.iterator()).hasNext()) {
            JTrans prev = itr.next();
            while (itr.hasNext()) {
                JTrans next = itr.next();
                if (prev.getFiringTime() == next.getFiringTime() && prev.getEvent().getPriority() == next.getEvent().getPriority()) {
                    throw new StepperConflictDeterministeException(MsgJStep.msgFormat("EXC_DETERMINIST_CONFLICT", this.getCurrentTime(), this.getCurrentLoop(), prev.getEvent().getPathName(), prev.getIdx(), next.getEvent().getPathName(), next.getIdx()));
                }
                prev = next;
            }
        }
        return true;
    }

    JTrans firing(JTrans tr, boolean fire) throws StepperException {
        this._stackStep.push(new JShedulStep(this._currentTime, this._currentLoop, fire, tr));
        if (tr != null) {
            this._currentLoop = tr.getFiringTime() == this._currentTime ? ++this._currentLoop : 0;
            if (!this._shedulList.isEmpty() && tr.getFiringTime() == this._shedulList.first().getFiringTime()) {
                this._currentTime = tr.getFiringTime();
            }
            if (tr.getFiringTime() < Double.POSITIVE_INFINITY) {
                this._shedulList.remove(tr);
                tr.setFiringTime(Double.POSITIVE_INFINITY);
            }
        }
        return this.update();
    }

    boolean includeInFirst(JTrans tr) {
        if (this._shedulList.isEmpty()) {
            return true;
        }
        JTrans first = this._shedulList.first();
        if (tr.getFiringTime() > first.getFiringTime()) {
            return false;
        }
        return tr.getEvent().getPriority() >= first.getEvent().getPriority();
    }

    JTrans update() throws StepperException {
        JTrans first;
        this.updateSheduler();
        if (this._autoInstantaneous && !this._shedulList.isEmpty() && (first = this._shedulList.first()).getFiringTime() == this._currentTime) {
            if (this._simul.withMonitoring(6)) {
                this._simul.monitor("Instantaneous >> ");
            }
            return first;
        }
        return null;
    }

    private void updateSheduler() throws StepperException {
        for (int i = 0; i < this._shTranss.size(); ++i) {
            JTrans tr = this._shTranss.get(i);
            if (tr.getFiringTime() == Double.POSITIVE_INFINITY) {
                if (!tr.isValid()) continue;
                tr.setFiringTime(this._currentTime + tr.getEvent().getDelay());
                this._shedulList.add(tr);
                continue;
            }
            if (tr.isValid()) continue;
            this._shedulList.remove(tr);
            tr.setFiringTime(Double.POSITIVE_INFINITY);
        }
    }

    boolean back() throws StepperException {
        JShedulStep step = (JShedulStep)this._stackStep.pop();
        this._currentTime = step._time;
        this._currentLoop = step._loop;
        this.updateSheduler();
        if (this._simul.withMonitoring(6)) {
            this._simul.monitor("goBackward(" + (step._trans != null ? step._trans.getEvent().getPathName() : "<modif State>") + ")\n");
        }
        if (step._trans == null || step._trans.getEvent().isStochastic()) {
            return false;
        }
        this._shedulList.remove(step._trans);
        step._trans.setFiringTime(step._firingTr);
        this._shedulList.add(step._trans);
        if (this._autoInstantaneous && !step._fire) {
            if (this._simul.withMonitoring(6)) {
                this._simul.monitor("Instantaneous >> ");
            }
            return true;
        }
        return false;
    }

    class JShedulStep {
        double _time;
        int _loop;
        boolean _fire;
        JTrans _trans;
        double _firingTr;

        JShedulStep(double time, int loop, boolean fire, JTrans tr) {
            this._time = time;
            this._loop = loop;
            this._fire = fire;
            this._trans = tr;
            if (tr != null) {
                this._firingTr = tr.getFiringTime();
            }
        }
    }
}

