/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.jstepper.v1;

import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JCreateException;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDefNode;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JDomain;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JFlowIn;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JFlowOut;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JValue;
import com.dassault.cecilia.lib.mbsa.jstepper.v1.JValueMonitoring;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JVariable {
    private String _name;
    private JValue _value;
    private JVariable _src;
    private ArrayList<JVariable> _alias;
    private JDefNode _parent;
    private JDomain _domain;
    private double _init = Double.NaN;

    public JVariable(String name, JDomain domain, JDefNode parent) {
        this._name = name;
        this._domain = domain;
        this._parent = parent;
        this._src = this;
        this._alias = new ArrayList();
        this._value = Boolean.getBoolean("cecilia.mbsa.jstepper.MonitoringVariables") ? new JValueMonitoring(this) : new JValue(this);
    }

    public JVariable getSource() {
        return this._src == this ? this._src : this._src.getSource();
    }

    public List<JVariable> getAlias() {
        return this.getSource()._alias;
    }

    public String getName() {
        return this._name;
    }

    public JDomain getDomain() {
        return this._domain;
    }

    public double getValue() {
        return this.getSource()._value.getValue();
    }

    public JDefNode getNode() {
        return this._parent;
    }

    public int getMaxChange() {
        return this._parent.getSimulator().getMaxChange();
    }

    public String getPathName() {
        StringBuffer sb = new StringBuffer(256);
        this._parent.getPathName(sb);
        sb.append(this._name);
        return sb.toString();
    }

    public void getPathName(StringBuffer sb) {
        this._parent.getPathName(sb);
        sb.append(this._name);
    }

    public String getAllNames() {
        StringBuffer sb = new StringBuffer(256);
        this.getPathName(sb);
        if (this._alias != null && this._alias.size() > 0) {
            sb.append("={");
            this.getOtherNames(sb);
            sb.append("}");
        }
        return sb.toString();
    }

    public void getOtherNames(StringBuffer sb) {
        if (this._alias != null && this._alias.size() > 0) {
            Iterator<JVariable> i = this._alias.iterator();
            while (i.hasNext()) {
                JVariable var = i.next();
                sb.append(var.getPathName());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
        }
    }

    public void isAliasOf(JVariable src) throws JCreateException {
        if (this != this.getSource() || src != src.getSource()) {
            this.getSource().isAliasOf(src.getSource());
        } else if (src != this) {
            if (this._domain == src._domain) {
                this._src = src;
                this._src._alias.addAll(this._alias);
                this._alias.clear();
                this._src._alias.add(this);
                this._value = null;
            } else {
                throw new JCreateException(MessageFormat.format(MsgJStep.getString("EXC_EXPR_NOT_EQUAL"), this.getName(), src.getName()));
            }
        }
    }

    void setPackageValue(double value) throws StepperViolatedAssertionException {
        if (this._src != this) {
            throw new StepperViolatedAssertionException("Internal error : affect a link variable : " + this.getPathName() + "\n");
        }
        this._value.setValue(value);
    }

    public void setValue(double value) throws StepperViolatedAssertionException {
        if (this._src != this) {
            throw new StepperViolatedAssertionException("Internal error : affect a link variable : " + this.getPathName() + "\n");
        }
        if (this._value.setValue(value)) {
            if (this instanceof JFlowIn) {
                this.getNode().addSimul();
            } else if (this instanceof JFlowOut && this.getNode().getNode() != null) {
                this.getNode().getNode().addSimul();
            }
            for (JVariable var : this._alias) {
                if (var instanceof JFlowIn) {
                    var.getNode().addSimul();
                    continue;
                }
                if (!(var instanceof JFlowOut) || var.getNode().getNode() == null) continue;
                var.getNode().getNode().addSimul();
            }
        }
    }

    public void setInit(double init) {
        this._init = init;
    }

    public void init() throws StepperViolatedAssertionException {
        if (Double.isNaN(this._init)) {
            if (this._src == this) {
                if (this._value == null) {
                    throw new StepperViolatedAssertionException("Internal error : value is null for " + this.getPathName() + "\n");
                }
                this._value.setDirectValue(Double.NaN);
            }
        } else {
            this.setPackageValue(this._init);
        }
    }

    public void print(IndentWriter out) throws IOException {
        out.write("<=> ");
        this.printInfo(out);
    }

    protected void printInfo(IndentWriter out) throws IOException {
        out.write(this.getPathName());
        if (this._src != null && this._src != this) {
            out.write(" <= ");
            out.write(this._src.getPathName());
        }
        if (this._alias.size() > 0) {
            out.write(" => {");
            for (int i = 0; i < this._alias.size(); ++i) {
                if (i > 0) {
                    out.write(", ");
                }
                out.write(this._alias.get(i).getPathName());
            }
            out.write("}");
        }
        out.write("\n");
    }
}

