/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.stepuser.ban.GenManagerUnit;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.Propagate;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.TriggerManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import java.io.File;

public class PropagateGen
extends GenManagerUnit {
    @Override
    protected TriggerManager createTrigger(Stepper stepper, String title, File dst) {
        return new Propagate(stepper, title, dst);
    }

    @Override
    protected void configureTrigger(TriggerManager seqManager) {
        double limitDelay = 1.0;
        String optLimitDelay = this.getParams().get("limit.delay");
        if (optLimitDelay != null) {
            try {
                limitDelay = Double.parseDouble(optLimitDelay);
            }
            catch (NumberFormatException e) {
                throw new BanProcessException("Param [limit.delay, " + optLimitDelay + "] can't cast to real", e);
            }
            if (limitDelay <= 0.0) {
                throw new BanProcessException("Param [limit.delay, " + optLimitDelay + "] must be greater than 0");
            }
        }
        ((Propagate)seqManager).setMaxDelay(limitDelay);
        int limitRank = 100;
        String optLimitRank = this.getParams().get("limit.rank");
        if (optLimitRank != null) {
            try {
                limitRank = Integer.parseInt(optLimitRank);
            }
            catch (NumberFormatException e) {
                throw new BanProcessException("Param [limit.rank, " + optLimitRank + "] can't cast to real", e);
            }
            if (limitRank <= 0) {
                throw new BanProcessException("Param [limit.rank, " + optLimitRank + "] must be greater than 0");
            }
        }
        ((Propagate)seqManager).setMaxRank(limitRank);
        Model model = this._modelId == null ? null : this.getModel();
        seqManager.defineModel(model);
    }
}

