/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.ban;

import com.dassault.cecilia.lib.ban.BanProcessComponent;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.stepper.ban.BanTarget;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutSimple;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqParameters;
import com.dassault.cecilia.lib.util.destination.DestinationConsole;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SeqGenStepper
extends Unit
implements UnitValued,
LayoutDefiner {
    protected int _result;
    String _stepperId;
    String _playList;
    String _initList;
    protected List<destination> _destinations = new ArrayList<destination>();
    protected List<BanTarget> _targets = new ArrayList<BanTarget>();
    protected List<Param> _options = new ArrayList<Param>();
    String _failOnError;

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    public void setStepper(String value) {
        this._stepperId = value;
    }

    protected Stepper getStepper() {
        String id = this.expanse(this._stepperId);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("stepper", id, this._stepperId);
        }
        Object obj = this.getProcess().getIdObject(id);
        if (obj == null) {
            throw new BanProcessException("Stepper '" + this._stepperId + "' unknow");
        }
        if (!(obj instanceof Stepper)) {
            throw new BanProcessException("Object with id '" + this._stepperId + "' is not stepper");
        }
        return (Stepper)obj;
    }

    public void setPlaylist(String value) {
        this._playList = value;
    }

    protected List<Integer> getPlayList() {
        if (this._playList != null) {
            return this.convertList(this.expanse(this._playList));
        }
        return null;
    }

    public void setInitlist(String value) {
        this._initList = value;
    }

    protected List<Integer> getInitList() {
        if (this._initList != null) {
            return this.convertList(this.expanse(this._initList));
        }
        return null;
    }

    protected List<Integer> convertList(String formatList) {
        ArrayList<Integer> result = new ArrayList<Integer>(100);
        StringTokenizer st = new StringTokenizer(formatList);
        try {
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                result.add(Integer.parseInt(tok));
            }
        }
        catch (NumberFormatException e) {
            throw new BanProcessException(e);
        }
        return result;
    }

    public void endValid() {
        if (this._destinations.size() == 0) {
            destination dest = this.createDestination();
            dest.setProcess(this.getProcess());
            dest.setClass(DestinationConsole.class.getName());
        }
        if (this._stepperId == null) {
            throw new BanProcessException("No attribut 'stepper' define");
        }
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    public BanTarget createTarget() {
        BanTarget tgt = new BanTarget();
        this._targets.add(tgt);
        return tgt;
    }

    public CollectionTargets createTargets() {
        return new CollectionTargets();
    }

    public Param createParam() {
        Param param = new Param();
        this._options.add(param);
        return param;
    }

    @Override
    public Class configureLayout(String key, Map<String, String> params) {
        if (key.equals("txt")) {
            return LogGenLayoutSimple.class;
        }
        if (key.equals("default") || key.equals("xml")) {
            return LogGenLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for stepgen unit : " + key);
    }

    public void setFailonerror(String value) {
        this._failOnError = value;
    }

    @Override
    public void execute() {
        this._result = -1;
        Stepper stepper = this.getStepper();
        List<Integer> playlist = this.getPlayList();
        List<Integer> initlist = this.getInitList();
        SeqGenerator seqgen = new SeqGenerator(stepper);
        for (destination dest : this._destinations) {
            seqgen.addDestination(dest.constructDestination(this));
        }
        seqgen.setParams(new SeqParameters(Param.mapParams(this._options)));
        try {
            for (BanTarget tgt : this._targets) {
                seqgen.addTarget(tgt.getName(), tgt.getValue(), tgt.getDstFile(), tgt.getParams());
            }
            seqgen.setPlayTrans(playlist);
            seqgen.setInitTrans(initlist);
            seqgen.InitFinder();
            this._result = seqgen.SeqFinder();
            seqgen.saveResultSet();
        }
        catch (BanProcessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BanProcessException(e);
        }
        finally {
            seqgen.close();
        }
    }

    public class CollectionTargets
    extends BanProcessComponent {
        public BanTarget createTarget() {
            BanTarget tgt = new BanTarget();
            SeqGenStepper.this._targets.add(tgt);
            return tgt;
        }
    }
}

