/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.error;

import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenComputeRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayout;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenSAXParser;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Record;
import java.io.File;
import java.util.List;
import org.xml.sax.SAXParseException;

public class LogGenLayoutXML
extends LogGenLayout {
    private boolean formatRecord(StringBuffer sb, boolean compute, LogGenRecord rec, String begin) {
        if (!compute) {
            LogGenRecord.LogType type = rec.getType();
            switch (type) {
                case INFO: {
                    if (!this._displayInfo) {
                        return false;
                    }
                    sb.append("<record type=\"info");
                    break;
                }
                case WARN: {
                    if (!this._displayWarning) {
                        return false;
                    }
                    sb.append("<record type=\"warning");
                    break;
                }
                case ERR: {
                    if (!this._displayError) {
                        return false;
                    }
                    sb.append("<record type=\"error");
                    break;
                }
                case EXC: {
                    if (!this._displayException) {
                        return false;
                    }
                    sb.append("<record type=\"exception");
                }
            }
            sb.append("\">\n");
        }
        sb.append(begin).append("  <code>").append(rec.getCodeMsg()).append("</code>\n");
        Object[] args = rec.getArgsMsg();
        if (args != null && args.length > 0) {
            switch (args.length) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(begin).append("  <args><arg>");
                    this.escapeXML(sb, args[0].toString());
                    sb.append("</arg></args>\n");
                    break;
                }
                default: {
                    sb.append(begin).append("  <args>\n");
                    for (int i = 0; i < args.length; ++i) {
                        sb.append(begin).append("    <arg>");
                        if (args[i] != null) {
                            this.escapeXML(sb, args[i].toString());
                        } else {
                            this.escapeXML(sb, "<null>");
                        }
                        sb.append("</arg>\n");
                    }
                    sb.append(begin).append("  </args>\n");
                }
            }
        }
        sb.append(begin).append("  <msg>");
        this.escapeXML(sb, rec.getMessage());
        sb.append(begin).append("</msg>\n");
        if (!compute) {
            sb.append("</record>\n");
        }
        return true;
    }

    @Override
    public String format(Record rec) {
        if (rec instanceof LogGenComputeRecord) {
            LogGenComputeRecord record = (LogGenComputeRecord)rec;
            StringBuffer sb = new StringBuffer(128);
            if (this._displayCompute) {
                sb.append("<compute>\n");
                this.formatRecord(sb, true, record, "");
            }
            for (LogGenRecord child : record._records) {
                this.formatRecord(sb, false, child, "  ");
            }
            if (this._displayCompute) {
                sb.append("</compute>\n");
            }
            return sb.toString();
        }
        if (rec instanceof LogGenRecord) {
            StringBuffer sb = new StringBuffer(128);
            LogGenRecord record = (LogGenRecord)rec;
            if (this.formatRecord(sb, false, record, "")) {
                return sb.toString();
            }
            return "";
        }
        throw new RuntimeException("Record unknow");
    }

    @Override
    public String getHead(Destination destination2) {
        StringBuffer sb = new StringBuffer(128);
        this.prepareHeadXML(sb, destination2);
        sb.append("<loggen>\n");
        return sb.toString();
    }

    @Override
    public String getTail(Destination destination2) {
        return "</loggen>\n";
    }

    public static List<LogGenRecord> parseLogFile(File input) {
        LogGenSAXParser parser = new LogGenSAXParser(input);
        try {
            parser.action();
        }
        catch (SAXParseException sAXParseException) {
            // empty catch block
        }
        return parser.getRecords();
    }
}

