/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.fmea;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.fmea.TriggerManager;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class GenFMEA
extends TriggerManager {
    static final int PROP_DEF_ALTALIB_GENFMEA_MAXERROR = 5;
    static final String PROP_ALTALIB_GENFMEA_MAXERROR = "cecilia.mbsa.genfmea.MaxError";
    boolean _oldFormat = false;

    public GenFMEA(Stepper stepper, String title, File result) {
        super(stepper, title, result);
    }

    public void defineFormat(boolean oldFormat, Model model) {
        this._oldFormat = oldFormat;
        this.defineModel(model);
    }

    @Override
    protected void verifyModel() throws StepperException {
        if (!this._oldFormat && this._fmodel != null) {
            super.verifyModel();
        }
    }

    private void printFMEABegin() throws IOException {
        this._writeResult.write(this.getXMLHeader());
        if (!this._oldFormat) {
            this._writeResult.write("<fmeagen>\n");
            this._writeResult.addIndent(1);
            this._writeResult.write("<define>\n");
            this._writeResult.addIndent(1);
            this.printDefine();
            this._writeResult.addIndent(-1);
            this._writeResult.write("</define>\n");
            this._writeResult.write("<result>\n");
            this._writeResult.addIndent(1);
        } else {
            this._writeResult.write("<generate-FMEA");
            this._writeResult.write(" Stepper=\"");
            this._writeResult.write(this._stepper.getClass().getName());
            this._writeResult.write("\"");
            if (this._title != null && this._title.length() > 0) {
                this._writeResult.write("\n    Model=\"");
                this._writeResult.write(this._title);
                this._writeResult.write("\"");
            }
            if (this._selectEvent.length() > 0) {
                this._writeResult.write("\n    FilterEvent=\"");
                this._writeResult.write(this.toXML(this._selectEvent));
                this._writeResult.write("\"");
            }
            if (this._selectState.length() > 0) {
                this._writeResult.write("\n    FilterState=\"");
                this._writeResult.write(this.toXML(this._selectState));
                this._writeResult.write("\"");
            }
            if (this._selectFlow.length() > 0) {
                this._writeResult.write("\n    FilterFlow=\"");
                this._writeResult.write(this.toXML(this._selectFlow));
                this._writeResult.write("\"");
            }
            if (this._chgVal) {
                this._writeResult.write("\n    OnlyChange=\"true\"");
            }
            this._writeResult.write(">\n");
            this._writeResult.addIndent(1);
        }
    }

    @Override
    protected void printTransBegin(ModelTrans tr) throws IOException {
        if (this._oldFormat) {
            this._writeResult.write("<trans event=\"");
            this._writeResult.write(this.toXML(tr.getName()));
            this._writeResult.write("\" desc=\"");
            this._writeResult.write(this.toXML(tr.getDesc()));
            this._writeResult.write("\">\n");
            this._writeResult.addIndent(1);
        } else {
            super.printTransBegin(tr);
        }
    }

    @Override
    protected void printTransEnd(ModelTrans tr) throws IOException {
        if (this._oldFormat) {
            this._writeResult.addIndent(-1);
            this._writeResult.write("</trans>\n");
        } else {
            super.printTransEnd(tr);
        }
    }

    private void printFMEAEnd() throws IOException {
        if (!this._oldFormat) {
            this._writeResult.addIndent(-1);
            this._writeResult.write("</result>\n");
            this.printErrorList();
            this.printDataNode();
            this._writeResult.addIndent(-1);
            this._writeResult.write("</fmeagen>\n");
        } else {
            this._writeResult.addIndent(-1);
            this._writeResult.write("</generate-FMEA>\n");
        }
    }

    @Override
    protected void work() throws InterruptedException, IOException, StepperException {
        this.printFMEABegin();
        Iterator iTr = this._transs.iterator();
        ModelTrans tr = null;
        int nbrError = 0;
        int maxError = Integer.getInteger(PROP_ALTALIB_GENFMEA_MAXERROR, 5);
        if (maxError < 1) {
            maxError = 1;
        }
        while (nbrError < maxError && iTr.hasNext()) {
            try {
                while (!this.checkStopped() && iTr.hasNext()) {
                    this.checkSuspended();
                    this._curSeq += 1.0;
                    tr = (ModelTrans)iTr.next();
                    this.printTransBegin(tr);
                    this._stepper.goForward(tr.getIdx());
                    Iterator<ModelTargetVar> iVar = this._states.iterator();
                    this.printValidTarget(iVar);
                    iVar = this._flows.iterator();
                    this.printValidTarget(iVar);
                    this._stepper.goBackward(1);
                    this.printTransEnd(tr);
                }
            }
            catch (StepperException e) {
                this._writeResult.write("<error nbr=\"");
                this._writeResult.write(Integer.toString(nbrError + 1));
                this._writeResult.write("\" msg=\"");
                this._writeResult.write(this.toXML(e.getMessage()));
                this._writeResult.write("\"/>\n");
                this.printTransEnd(tr);
                this.addRecord(new LogGenRecord(e, "PRV_CMD_FMEA_EXC_GEN", nbrError + 1, tr.getName(), tr.getDesc(), e.getMessage()));
                this._stepper.goInitialState();
                ++nbrError;
            }
        }
        this.printFMEAEnd();
        this._writeResult.close(true);
        this._writeResult = null;
        if (nbrError >= maxError) {
            this.addRecord(new LogGenRecord(true, "PRV_CMD_FMEA_EXC_GEN", nbrError));
            throw new StepperInterruptException();
        }
    }
}

