/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.fmea;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.SeqManager;
import com.dassault.cecilia.lib.mbsa.stepuser.StepperInterruptException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenLayoutXML;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.DataNodeExtract;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetFlow;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetState;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTargetVar;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTransStepper;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.util.DefaultControllableProcess;
import com.dassault.cecilia.lib.util.io.IndentWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

public abstract class TriggerManager
extends SeqManager {
    protected Stepper _stepper;
    protected String _title;
    protected String _selectEvent;
    protected String _selectState;
    protected String _selectFlow;
    protected File _fileResult;
    protected Model _fmodel;
    protected boolean _chgVal;
    protected int _nbrError;
    protected List<LogGenRecord> _errorList;
    protected Pattern _patternEvent;
    protected Pattern _patternState;
    protected Pattern _patternFlow;
    protected Set<ModelTrans> _transs;
    protected Set<ModelTargetVar> _states;
    protected Set<ModelTargetVar> _flows;
    protected Node _node;
    protected IndentWriter _writeResult;
    protected double _maxSeq;
    protected double _curSeq;
    String _XMLHeader = null;

    protected TriggerManager(Stepper stepper, String title, File result) {
        this._stepper = stepper;
        this._title = title;
        this._fileResult = result;
        this._selectFlow = "";
        this._selectState = "";
        this._selectEvent = "";
        this._fmodel = null;
        this._nbrError = 5;
        this._errorList = new ArrayList<LogGenRecord>(6);
        this._chgVal = true;
        this._state = DefaultControllableProcess.CtrlState.WAIT;
        this._curSeq = -1.0;
        this._maxSeq = 2.147483647E9;
    }

    public void setXMLHeader(String value) {
        this._XMLHeader = value;
    }

    protected String getXMLHeader() {
        if (this._XMLHeader != null) {
            return this._XMLHeader;
        }
        return "<?xml version=\"1.0\"?>\n";
    }

    public void setSelectors(String evt, String stt, String flw, boolean chg) {
        this._selectEvent = evt;
        this._selectState = stt;
        this._selectFlow = flw;
        this._chgVal = chg;
    }

    public void defineModel(Model model) {
        this._fmodel = model;
    }

    protected abstract void work() throws InterruptedException, IOException, StepperException;

    public boolean run() throws StepperException, IOException {
        boolean error = true;
        Exception exc = null;
        try {
            this._state = DefaultControllableProcess.CtrlState.INIT;
            this.init();
            this._state = DefaultControllableProcess.CtrlState.WORK;
            this.work();
            error = false;
        }
        catch (InterruptedException interruptedException) {
        }
        catch (StepperInterruptException stepperInterruptException) {
        }
        catch (StepperException e) {
            exc = e;
            throw e;
        }
        catch (IOException e) {
            exc = e;
            throw e;
        }
        finally {
            if (error && this._writeResult != null) {
                try {
                    this._writeResult.close(true);
                }
                catch (IOException iOException) {}
                this._writeResult = null;
            }
            if (exc != null) {
                this.addRecord(new LogGenRecord(exc));
            }
            this.close();
            this._stepper = null;
            System.gc();
            this._state = DefaultControllableProcess.CtrlState.FINISH;
            this._curSeq = 1.0;
            this._maxSeq = 1.0;
        }
        return error;
    }

    protected void verifyModel() throws StepperException {
        if (this._fmodel == null) {
            throw new StepperException("No model");
        }
        if (this._fmodel.getNodeCount() != 1) {
            throw new StepperException("Model no flatness");
        }
        this._node = this._fmodel.getNode(0);
    }

    protected void init() throws IOException, StepperException {
        String name;
        int i;
        if (this._fileResult == null) {
            throw new IOException("GenFMEA : File Result not define");
        }
        this.verifyModel();
        this._patternEvent = this._selectEvent.length() == 0 ? null : Pattern.compile(this._selectEvent);
        this._patternState = this._selectState.length() == 0 ? null : Pattern.compile(this._selectState);
        this._patternFlow = this._selectFlow.length() == 0 ? null : Pattern.compile(this._selectFlow);
        this._transs = new TreeSet<ModelTrans>(new Comparator<ModelTrans>(){

            @Override
            public int compare(ModelTrans v1, ModelTrans v2) {
                int result = v1.getName().compareTo(v2.getName());
                if (result != 0) {
                    return result;
                }
                return v1.getIdx() - v2.getIdx();
            }
        });
        this._states = new TreeSet<ModelTargetVar>(new Comparator<ModelTargetVar>(){

            @Override
            public int compare(ModelTargetVar v1, ModelTargetVar v2) {
                int result = v1.getVarType() - v2.getVarType();
                if (result != 0) {
                    return result;
                }
                result = v1.getName().compareTo(v2.getName());
                if (result != 0) {
                    return result;
                }
                return v1.getIdx() - v2.getIdx();
            }
        });
        this._flows = new TreeSet<ModelTargetVar>(new Comparator<ModelTargetVar>(){

            @Override
            public int compare(ModelTargetVar v1, ModelTargetVar v2) {
                int result = v1.getVarType() - v2.getVarType();
                if (result != 0) {
                    return result;
                }
                result = v1.getName().compareTo(v2.getName());
                if (result != 0) {
                    return result;
                }
                return v1.getIdx() - v2.getIdx();
            }
        });
        this._writeResult = new IndentWriter(new FileWriter(this._fileResult), "\t");
        this._stepper.goInitialState();
        StringBuffer buffer = new StringBuffer(128);
        for (i = 1; i <= this._stepper.getNbrTransition(); ++i) {
            if (this._stepper.isValidTransition(i) < 0.0) continue;
            String name2 = this._stepper.getNameOfTransition(i);
            String desc = this._stepper.getDescOfTransition(i);
            if (this._patternEvent == null) {
                this._transs.add(new ModelTransStepper(i, name2, desc));
                continue;
            }
            if (!this._patternEvent.matcher(name2).find()) continue;
            this._transs.add(new ModelTransStepper(i, name2, desc));
            buffer.append("\t").append(name2).append("\n");
        }
        if (this._patternEvent != null) {
            this.addRecord(new LogGenRecord(false, "PRV_CMD_FMEA_PATTERN_EVENT", this._selectEvent, buffer.toString()));
        }
        if (this._transs.size() == 0) {
            this.addRecord(new LogGenRecord(true, "PRV_CMD_FMEA_NOTRANS", new Object[0]));
            throw new StepperInterruptException();
        }
        buffer = new StringBuffer(128);
        for (i = 1; i <= this._stepper.getNbrState(); ++i) {
            double val = this._stepper.getValueOfState(i);
            name = this._stepper.getNameOfState(i);
            if (this._patternState == null) {
                this._states.add(new ModelTargetState(name, i, val));
                continue;
            }
            if (!this._patternState.matcher(name).find()) continue;
            this._states.add(new ModelTargetState(name, i, val));
            buffer.append("\t").append(name).append("\n");
        }
        if (this._patternState != null) {
            this.addRecord(new LogGenRecord(false, "PRV_CMD_FMEA_PATTERN_STATE", this._selectState, buffer.toString()));
        }
        buffer = new StringBuffer(128);
        for (i = 1; i <= this._stepper.getNbrFlow(); ++i) {
            double val = this._stepper.getValueOfFlow(i);
            name = this._stepper.getNameOfFlow(i);
            ModelTargetFlow flow = new ModelTargetFlow(name, i, val);
            flow.setStrValue(this._stepper.getValueStringOfFlow(i));
            if (this._patternFlow == null) {
                this._flows.add(flow);
                continue;
            }
            if (!this._patternFlow.matcher(name).find()) continue;
            this._flows.add(flow);
            buffer.append("\t").append(name).append("\n");
        }
        if (this._patternFlow != null) {
            this.addRecord(new LogGenRecord(false, "PRV_CMD_FMEA_PATTERN_FLOW", this._selectFlow, buffer.toString()));
        }
        if (this._states.size() == 0 && this._flows.size() == 0) {
            this.addRecord(new LogGenRecord(true, "PRV_CMD_FMEA_NOTARGET", new Object[0]));
            throw new StepperInterruptException();
        }
        this._maxSeq = this._transs.size();
        this._curSeq = 0.0;
    }

    protected String toXML(String st) {
        StringBuffer xmlString = new StringBuffer("");
        char curCar = ' ';
        block10: for (int i = 0; i < st.length(); ++i) {
            curCar = st.charAt(i);
            switch (curCar) {
                case '&': {
                    xmlString.append("&amp;");
                    continue block10;
                }
                case '<': {
                    xmlString.append("&lt;");
                    continue block10;
                }
                case '>': {
                    xmlString.append("&gt;");
                    continue block10;
                }
                case '\'': {
                    xmlString.append("&apos;");
                    continue block10;
                }
                case '\"': {
                    xmlString.append("&quot;");
                    continue block10;
                }
                case ':': {
                    xmlString.append("&#x003A;");
                    continue block10;
                }
                case '[': {
                    xmlString.append("&#x005B;");
                    continue block10;
                }
                case ']': {
                    xmlString.append("&#x005D;");
                    continue block10;
                }
                default: {
                    xmlString.append(curCar);
                }
            }
        }
        return xmlString.toString();
    }

    protected void printDefine() throws IOException {
        if (this._title != null && this._title.length() > 0) {
            this._writeResult.write("<param name=\"title\" value=\"");
            this._writeResult.write(this.toXML(this._title));
            this._writeResult.write("\" />\n");
        }
        if (this._selectEvent.length() > 0) {
            this._writeResult.write("<param name=\"select.event\" value=\"");
            this._writeResult.write(this.toXML(this._selectEvent));
            this._writeResult.write("\" />\n");
        }
        if (this._selectState.length() > 0) {
            this._writeResult.write("<param name=\"select.state\" value=\"");
            this._writeResult.write(this.toXML(this._selectState));
            this._writeResult.write("\" />\n");
        }
        if (this._selectFlow.length() > 0) {
            this._writeResult.write("<param name=\"select.flow\" value=\"");
            this._writeResult.write(this.toXML(this._selectFlow));
            this._writeResult.write("\" />\n");
        }
        this._writeResult.write("<param name=\"onlychange\" value=\"");
        this._writeResult.write(Boolean.toString(this._chgVal));
        this._writeResult.write("\" />\n");
    }

    protected void printTransBegin(ModelTrans tr) throws IOException {
        this._writeResult.write("<tr id=\"");
        this._writeResult.write(Integer.toString(tr.getIdx()));
        this._writeResult.write("\" evt=\"");
        this._writeResult.write(this.toXML(tr.getName()));
        this._writeResult.write("\">\n");
        this._writeResult.addIndent(1);
    }

    protected void printTransEnd(ModelTrans tr) throws IOException {
        this._writeResult.addIndent(-1);
        this._writeResult.write("</tr>\n");
    }

    protected void printDataNode() throws IOException {
        if (this._node != null) {
            DataNodeExtract data = new DataNodeExtract(this._node){
                Map<String, String> _initValues;
                {
                    this._initValues = new HashMap<String, String>();
                }

                @Override
                protected Event convertToEvent(Object obj) {
                    ModelTrans tr = (ModelTrans)obj;
                    return TriggerManager.this._node.getEvent(tr.getName());
                }

                @Override
                protected State convertToState(Object obj) {
                    ModelTargetVar var = (ModelTargetVar)obj;
                    return TriggerManager.this._node.getState(var.getName());
                }

                @Override
                protected Flow convertToFlow(Object obj) {
                    ModelTargetVar var = (ModelTargetVar)obj;
                    this._initValues.put(var.getName(), var.getStrValue());
                    return TriggerManager.this._node.getFlow(var.getName());
                }

                @Override
                protected String getInitForFlow(Flow flow) {
                    return this._initValues.get(flow.getName());
                }
            };
            data.extract(this._transs, this._states, this._flows);
            data.write(this._writeResult);
        }
    }

    protected void printValidTarget(Iterator<ModelTargetVar> iVar) throws IOException {
        while (iVar.hasNext()) {
            ModelTargetVar var = iVar.next();
            if (this._chgVal && var.isActive(this._stepper)) continue;
            if (var.getVarType() == 1) {
                this._writeResult.write("<state name=\"");
            } else {
                this._writeResult.write("<flow  name=\"");
            }
            this._writeResult.write(this.toXML(var.getName()));
            this._writeResult.write("\" \tvalue=\"");
            this._writeResult.write(this.toXML(var.getCurStrValue(this._stepper)));
            this._writeResult.write("\"/>\n");
        }
    }

    protected void printErrorList() throws IOException {
        if (this._errorList != null && this._errorList.size() > 0) {
            this._writeResult.write("<errors>\n");
            this._writeResult.addIndent(1);
            LogGenLayoutXML layout2 = new LogGenLayoutXML();
            for (LogGenRecord record : this._errorList) {
                this._writeResult.write(layout2.format(record));
            }
            this._writeResult.addIndent(-1);
            this._writeResult.write("</errors>\n");
        }
    }

    @Override
    public String getInfo(String key) {
        if (key.equals("process.msg.high")) {
            StringBuffer msg = new StringBuffer(10);
            msg.append(this._curSeq >= this._maxSeq ? this._maxSeq : this._curSeq + 1.0);
            msg.append("/");
            msg.append(this._maxSeq);
            return msg.toString();
        }
        if (key.equals("process.p1000")) {
            return Integer.toString(this._curSeq < 0.0 ? 0 : (int)(this._curSeq / this._maxSeq * 1000.0));
        }
        return super.getInfo(key);
    }

    @Override
    public void addRecord(LogGenRecord record) {
        super.addRecord(record);
        switch (record.getType()) {
            case ERR: 
            case EXC: {
                this._errorList.add(record);
            }
        }
    }
}

