/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.ResultSetAbstract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class ResultSetBasic
extends ResultSetAbstract {
    Collection<ModelTrans[]> _cutTable;
    Map<Integer, CptInt> _cutOrders;

    public ResultSetBasic() {
        this(false);
    }

    public ResultSetBasic(boolean sort) {
        this._cutTable = sort ? new TreeSet<ModelTrans[]>(new Comparator(){

            public int compare(Object O1, Object O2) {
                ModelTrans[] o1 = (ModelTrans[])O1;
                ModelTrans[] o2 = (ModelTrans[])O2;
                int res = o1.length - o2.length;
                if (res != 0) {
                    return res;
                }
                for (int i = 0; i < o1.length; ++i) {
                    res = o1[i].getIdx() - o2[i].getIdx();
                    if (res == 0) continue;
                    return res;
                }
                return 0;
            }
        }) : new ArrayList<ModelTrans[]>();
        this._cutOrders = new TreeMap<Integer, CptInt>();
    }

    @Override
    public void addSeq(ModelTrans[] seq) {
        this._cutTable.add(seq);
        CptInt cpt = this._cutOrders.get(seq.length);
        if (cpt == null) {
            cpt = new CptInt();
            this._cutOrders.put(seq.length, cpt);
        }
        ++cpt._cpt;
    }

    @Override
    public void addSeq(ModelTrans[] trs, int order) {
        this.addSeq(this.clone(trs, order));
    }

    @Override
    public synchronized void addSeq(List<ModelTrans> trs, boolean error) {
        this.addSeq(this.convert(trs));
    }

    @Override
    public synchronized Iterator getSeqIterator() {
        return this._cutTable.iterator();
    }

    @Override
    public synchronized String getSeqAbstract() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("/* Order of products :\n");
        for (Map.Entry<Integer, CptInt> order : this._cutOrders.entrySet()) {
            sb.append("\t");
            sb.append(Integer.toString(order.getKey()));
            sb.append("\t");
            sb.append(Integer.toString(order.getValue()._cpt));
            sb.append("\n");
        }
        sb.append(" */\n");
        return sb.toString();
    }

    @Override
    public synchronized Map<Integer, Integer> getOrders() {
        LinkedHashMap<Integer, Integer> orders = new LinkedHashMap<Integer, Integer>();
        for (Map.Entry<Integer, CptInt> order : this._cutOrders.entrySet()) {
            orders.put(order.getKey(), order.getValue()._cpt);
        }
        return orders;
    }

    @Override
    public String getShortName() {
        return "Basic";
    }

    private class CptInt {
        int _cpt = 0;

        private CptInt() {
        }
    }
}

