/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepuser.error.LogGenRecord;
import com.dassault.cecilia.lib.mbsa.stepuser.model.ModelTrans;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGenerator;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqTargetAbstract;
import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.StepperInterruptInternalException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class SeqFinder {
    SeqGenerator _simul;
    SeqTargetAbstract _tgt;
    boolean _looker;
    ArrayList<ModelTrans> _trList;
    protected static final NumberFormat __frmInteger2 = new DecimalFormat("00");
    protected static final NumberFormat __frmInteger3 = new DecimalFormat("000");

    protected SeqFinder() {
    }

    public void setLocker(boolean value) {
        this._looker = value;
    }

    public double init(SeqGenerator simul) {
        this._simul = simul;
        this._tgt = simul.getTarget();
        this._trList = this._simul.getTranss();
        return -1.0;
    }

    public abstract void printHeader();

    public abstract int playSimul() throws StepperException;

    public abstract void printFooter();

    public abstract int getNbGame(int var1);

    public abstract Iterator<SeqGame> getGames(int var1);

    protected String toString(double value) {
        if (value > 9.223372036854776E18) {
            return "~" + Double.toString(value);
        }
        return Long.toString((long)value);
    }

    protected static String convertTimeToTime(long timer) {
        long sec = timer / 1000L;
        timer -= sec * 1000L;
        StringBuffer sb = new StringBuffer(128);
        long min = sec / 60L;
        sec -= min * 60L;
        long hours = min / 60L;
        min -= hours * 60L;
        sb = new StringBuffer(128);
        sb.append(Long.toString(hours));
        sb.append(":");
        sb.append(__frmInteger2.format(min));
        sb.append(":");
        sb.append(__frmInteger2.format(sec));
        sb.append(".");
        sb.append(__frmInteger3.format(timer));
        return sb.toString();
    }

    protected static void displayTime(long timer, String keyTitle, SeqGenerator simul) {
        long sec = timer / 1000L;
        long msec = timer - sec * 1000L;
        StringBuffer sb = new StringBuffer(128);
        sb.append("(sec) : ");
        sb.append(Long.toString(sec));
        sb.append(".");
        sb.append(__frmInteger3.format(msec));
        simul.addRecord(new LogGenRecord(keyTitle, sb.toString()));
        simul.addRecord(new LogGenRecord(keyTitle, "      : " + SeqFinder.convertTimeToTime(timer)));
    }

    protected void displayException(Exception se, List<ModelTrans> currentSeq) throws StepperInterruptInternalException {
        StringBuffer sb = new StringBuffer(currentSeq.size() * 30);
        this._simul.appendInitList(sb, -1);
        for (ModelTrans trans : currentSeq) {
            sb.append("\t\t");
            sb.append(trans.getName());
            sb.append("\t");
            sb.append(trans.getIdx());
            sb.append("\t:\t");
            sb.append(trans.getDesc());
            sb.append("\n");
        }
        this._simul.addError(se, sb.toString());
    }
}

