/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SeqGameCombIterator
implements Iterator<SeqGame> {
    private SeqGame _game;
    private LinkedList<Integer> _playList;
    private ArrayList<Integer> _initList;
    private boolean _first = true;
    private boolean _last = false;
    static final String PROP_FFT1448_HOTFIX = "cecilia.mbsa.seqgen.FFT1448";
    private static boolean _FFT1448_HOTFIX = false;

    public SeqGameCombIterator(List<Integer> idxTranss, int initListSize) {
        _FFT1448_HOTFIX = Boolean.getBoolean(PROP_FFT1448_HOTFIX);
        if (initListSize != 1) {
            throw new IllegalArgumentException("initListSize must be 1");
        }
        int nbTrans = idxTranss.size();
        this._initList = new ArrayList(initListSize);
        this._playList = new LinkedList();
        if (nbTrans > 0) {
            this._initList.add(idxTranss.get(0));
        }
        if (nbTrans == 1 && _FFT1448_HOTFIX) {
            this._playList.add(idxTranss.get(0));
            this._last = true;
        } else {
            for (int i = 1; i < nbTrans; ++i) {
                this._playList.add(idxTranss.get(i));
            }
        }
        this._game = new SeqGame(this._initList, this._playList);
    }

    @Override
    public boolean hasNext() {
        if (this._first) {
            return true;
        }
        if (this._last && _FFT1448_HOTFIX) {
            return false;
        }
        return this._playList.size() > 0;
    }

    @Override
    public SeqGame next() {
        if (this._first) {
            this._first = false;
        } else if (this._playList.size() == 1 && _FFT1448_HOTFIX) {
            this._last = true;
            this._initList.set(0, this._playList.getFirst());
        } else {
            this._initList.set(0, this._playList.removeFirst());
        }
        return this._game;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    static void printGames(List<Integer> transIdx, int initSize) {
        SeqGameCombIterator it = new SeqGameCombIterator(transIdx, initSize);
        System.out.println("----------------------------------------------------");
        System.out.println("Combinaison (" + initSize + ") : " + transIdx);
        while (it.hasNext()) {
            SeqGame game = it.next();
            System.out.println("init= " + game.getInitList().toString() + " play = " + game.getPlaySet().toString());
        }
    }

    public static void main(String[] args) {
        SeqGameCombIterator.printGames(new ArrayList<Integer>(), 1);
        SeqGameCombIterator.printGames(Arrays.asList(51), 1);
        SeqGameCombIterator.printGames(Arrays.asList(31, 41, 51), 1);
    }
}

