/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SeqGamePermIterator
implements Iterator<SeqGame> {
    private static Comparator<Integer> __intComparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            return o1 - o2;
        }
    };
    private SeqGame _game;
    private TreeSet<Integer> _playList;
    private ArrayList<Integer> _initList;
    private ArrayList<Integer> _idxTranss;
    private int _nbTrans;
    private int _curIdx;

    public SeqGamePermIterator(List<Integer> idxTranss, int initListSize) {
        if (initListSize != 1) {
            throw new IllegalArgumentException("initListSize must be 1");
        }
        this._idxTranss = new ArrayList<Integer>(idxTranss);
        this._initList = new ArrayList(1);
        this._playList = new TreeSet<Integer>(__intComparator);
        this._nbTrans = idxTranss.size();
        this._curIdx = -1;
        if (this._nbTrans > 0) {
            this._initList.add(this._idxTranss.get(0));
        }
        for (int i = 1; i < this._nbTrans; ++i) {
            this._playList.add(this._idxTranss.get(i));
        }
        this._game = new SeqGame(this._initList, this._playList);
    }

    @Override
    public boolean hasNext() {
        return this._curIdx == -1 || this._curIdx + 1 < this._nbTrans;
    }

    @Override
    public SeqGame next() {
        if (this._curIdx != -1) {
            int idxTrCur = this._idxTranss.get(this._curIdx);
            int idxTrNext = this._idxTranss.get(this._curIdx + 1);
            this._playList.remove(idxTrNext);
            this._playList.add(idxTrCur);
            this._initList.set(0, idxTrNext);
            ++this._curIdx;
        } else {
            this._curIdx = 0;
        }
        return this._game;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void printGames(List<Integer> transIdx, int initSize) {
        SeqGamePermIterator it = new SeqGamePermIterator(transIdx, initSize);
        System.out.println("----------------------------------------------------");
        System.out.println("Permutation (" + initSize + ") : " + transIdx);
        while (it.hasNext()) {
            SeqGame game = it.next();
            System.out.println("init= " + game.getInitList().toString() + " play = " + game.getPlaySet().toString());
        }
    }

    public static void main(String[] args) {
        SeqGamePermIterator.printGames(new ArrayList<Integer>(), 1);
        SeqGamePermIterator.printGames(Arrays.asList(51), 1);
        SeqGamePermIterator.printGames(Arrays.asList(31, 41, 51), 1);
    }
}

