/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.stepuser.seqgen;

import com.dassault.cecilia.lib.mbsa.stepuser.seqgen.SeqGame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class SeqGameRepeatIterator
implements Iterator<SeqGame> {
    private SeqGame _game;
    private ArrayList<Integer> _initList;
    private ArrayList<Integer> _idxTranss;
    int _nbTrans;
    int[] _cursor;

    public SeqGameRepeatIterator(List<Integer> idxTranss, int initListSize) {
        this._idxTranss = new ArrayList<Integer>(idxTranss);
        this._nbTrans = this._idxTranss.size();
        int realSize = Math.min(initListSize, this._nbTrans);
        this._initList = new ArrayList(realSize);
        if (realSize == 0) {
            this._cursor = new int[1];
            this._cursor[0] = 0;
        } else {
            this._cursor = new int[realSize];
            for (int i = 0; i < realSize; ++i) {
                this._initList.add(this._idxTranss.get(0));
                this._cursor[i] = 0;
            }
        }
        this._game = new SeqGame(this._initList, new TreeSet<Integer>(this._idxTranss));
    }

    @Override
    public boolean hasNext() {
        return this._cursor[0] >= 0;
    }

    @Override
    public SeqGame next() {
        int realSize = Math.min(this._cursor.length, this._nbTrans);
        for (int i = 0; i < realSize; ++i) {
            this._initList.set(i, this._idxTranss.get(this._cursor[i]));
        }
        this.nextCursor(realSize - 1);
        return this._game;
    }

    private void nextCursor(int idx) {
        if (idx < 0) {
            this._cursor[0] = -1;
        } else if (this._cursor[idx] + 1 < this._nbTrans) {
            int n = idx;
            this._cursor[n] = this._cursor[n] + 1;
        } else {
            this._cursor[idx] = 0;
            this.nextCursor(idx - 1);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static void printGames(List<Integer> transIdx, int initSize) {
        SeqGameRepeatIterator it = new SeqGameRepeatIterator(transIdx, initSize);
        System.out.println("----------------------------------------------------");
        System.out.println("Repeat (" + initSize + ") : " + transIdx);
        while (it.hasNext()) {
            SeqGame game = it.next();
            System.out.println("init= " + game.getInitList().toString() + " play = " + game.getPlaySet().toString());
        }
    }

    public static void main(String[] args) {
        SeqGameRepeatIterator.printGames(new ArrayList<Integer>(), 1);
        SeqGameRepeatIterator.printGames(Arrays.asList(51), 1);
        SeqGameRepeatIterator.printGames(Arrays.asList(31, 41, 51), 1);
        SeqGameRepeatIterator.printGames(Arrays.asList(31, 41, 51), 2);
    }
}

