/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.Unit;
import com.dassault.cecilia.lib.ban.UnitValued;
import com.dassault.cecilia.lib.ban.type.LayoutDefiner;
import com.dassault.cecilia.lib.ban.type.destination;
import com.dassault.cecilia.lib.ban.unitdefs.struct.Destinations;
import com.dassault.cecilia.lib.mbsa.translator.ban.AltaProcessException;
import com.dassault.cecilia.lib.mbsa.translator.ban.TransLayoutSimple;
import com.dassault.cecilia.lib.mbsa.translator.ban.TransLayoutXML;
import com.dassault.cecilia.lib.mbsa.translator.error.ErrorManager;
import com.dassault.cecilia.lib.mbsa.translator.error.MessageManager;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Layout;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AlTrans
extends Unit
implements UnitValued,
LayoutDefiner {
    private boolean _result;
    String _logFile;
    String _logRefId;
    boolean _failOnError = false;
    String _orginFailOnError;
    protected List<destination> _destinations = new ArrayList<destination>();

    protected void setResult(boolean value) {
        this._result = value;
    }

    @Override
    public Object getResult() {
        return this._result;
    }

    @Override
    public void freeResult() {
    }

    private void verifySetLog() {
        if (this._logFile != null) {
            throw new BanProcessException("logfile already define : " + this._logFile);
        }
        if (this._logRefId != null) {
            throw new BanProcessException("logref already define : " + this._logRefId);
        }
    }

    public void setLogfile(String value) {
        this.verifySetLog();
        this.log("Attribute 'logfile' is deprecated (use 'destination' element)", 2);
        this._logFile = value;
    }

    public void setLogref(String value) {
        this.verifySetLog();
        this._logRefId = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File getLogFile() {
        File log = null;
        if (this._logFile != null) {
            log = new File(this.expanse(this._logFile));
        } else {
            if (this._logRefId == null) return null;
            String logRef = this.expanse(this._logRefId);
            if (!this.isSimpleID(logRef)) {
                throw this.errorComplexId("logref", logRef, this._logRefId);
            }
            Object obj = this.getProcess().getIdObject(logRef);
            if (obj instanceof File) {
                this.log("Attribute 'logref' must be reference to 'destinations' element", 3);
                log = (File)obj;
            } else {
                if (obj == null) {
                    throw new BanProcessException("Destinations '" + logRef + "' unknow");
                }
                if (obj instanceof Destinations) {
                    this._destinations.addAll(((Destinations)obj).getDestinations());
                    return null;
                }
                if (!(obj instanceof destination)) throw new BanProcessException("Object with id '" + logRef + "' is not destinations");
                this._destinations.add((destination)obj);
                return null;
            }
        }
        if (log.canWrite()) return log;
        this.log("Can not read log file [" + log.getAbsolutePath() + "]", 1);
        return log;
    }

    void verifyFailOnError() {
        this._failOnError = false;
        if (this._orginFailOnError != null) {
            this._failOnError = this.castBool(this.expanse(this._orginFailOnError), "failonerror");
        }
    }

    public void setFailonerror(String value) {
        this._orginFailOnError = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void log(MessageManager errorMng) {
        if (errorMng.getMsgCount() == 0) {
            this.log("Message manager empty ...", 1);
            return;
        }
        File logFile = this.getLogFile();
        boolean logMsg = false;
        if (logFile != null) {
            Object out = null;
            try {
                out = new BufferedWriter(new FileWriter(logFile));
                for (int i = 0; i < errorMng.getMsgCount(); ++i) {
                    if (i > 0) {
                        ((Writer)out).write("\n");
                    }
                    ((Writer)out).write(errorMng.getMsg(i));
                }
                ((Writer)out).close();
                logMsg = true;
            }
            catch (IOException e) {
                if (this._failOnError) {
                    throw new AltaProcessException(e);
                }
                this.log(e.getMessage(), 0);
            }
            finally {
                if (out != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        for (destination banDest : this._destinations) {
            Destination realDest = banDest.constructDestination(this);
            for (int i = 0; i < errorMng.getMsgCount(); ++i) {
                realDest.publish(errorMng.getRecord(i));
            }
            realDest.close();
            logMsg = true;
        }
        if (!logMsg) {
            for (int i = 0; i < errorMng.getMsgCount(); ++i) {
                this.log(errorMng.getMsg(i), 0);
            }
        }
        if (this._failOnError && errorMng.withError()) {
            throw new AltaProcessException("Fatal error : " + this.getName());
        }
    }

    protected void log(TranslateException e) {
        ErrorManager errorMng = new ErrorManager();
        errorMng.add(e);
        this.log(errorMng);
    }

    public destination createDestination() {
        destination app = new destination();
        this._destinations.add(app);
        return app;
    }

    @Override
    public Class<? extends Layout> configureLayout(String key, Map<String, String> params) {
        if (key.equals("default") || key.equals("txt")) {
            return TransLayoutSimple.class;
        }
        if (key.equals("xml")) {
            return TransLayoutXML.class;
        }
        throw new BanProcessException("layout unknow for diff unit : " + key);
    }
}

