/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.ban.BanProcess;
import com.dassault.cecilia.lib.ban.BanProcessException;
import com.dassault.cecilia.lib.ban.type.Param;
import com.dassault.cecilia.lib.ban.util.UtilFileDst;
import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.stepper.StatisticsStepper;
import com.dassault.cecilia.lib.mbsa.translator.ban.AlTransModel;
import com.dassault.cecilia.lib.mbsa.translator.ban.TransStepper;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.simul.ReaderCompilerTranslate;
import com.dassault.cecilia.lib.mbsa.translator.simul.Simulator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AlTransStepper
extends AlTransModel {
    private String _id;
    UtilFileDst _dst = new UtilFileDst();
    List<Param> _params = new ArrayList<Param>();

    public void setId(String value) {
        if (this._id != null) {
            this.log("Stepper 'id' already define : " + this._id + " => " + value, 1);
        }
        this._id = value;
    }

    public void setDestfile(String value) {
        this._dst.setFile("destfile", value);
    }

    public void setDestref(String value) {
        this._dst.setRef("destref", value);
    }

    public Param createParam() {
        Param param = new Param();
        this._params.add(param);
        return param;
    }

    Map<String, String> recupParams() {
        return Param.mapParams(this._params);
    }

    @Override
    public void setProcess(BanProcess process) {
        super.setProcess(process);
        this._dst.setProcess(process);
    }

    @Override
    public void endValid() {
        if (this._id == null) {
            throw new BanProcessException("No attribut 'id' define");
        }
        this._dst.endValid();
        super.endValid();
    }

    @Override
    public void execute() {
        this.setResult(false);
        this.verifyFailOnError();
        String id = this.expanse(this._id);
        if (!this.isSimpleID(id)) {
            throw this.errorComplexId("id", id, this._id);
        }
        Model fromModel = this.getRefModel();
        if (fromModel.getNodeCount() != 1) {
            throw new BanProcessException("Model '" + this.getRef() + "' is not flatness model.");
        }
        Simulator simul = new Simulator(fromModel.getNode(0), fromModel);
        File destFile = null;
        try {
            destFile = this._dst.getDstFile();
            boolean reload = simul.save(destFile);
            if (reload || Boolean.getBoolean("cecilia.mbsa.stepper.reload")) {
                simul = new Simulator();
                simul.load(destFile);
            }
        }
        catch (IOException e) {
            throw new BanProcessException(this.getName() + " - IOexception", e);
        }
        Stepper delegate = simul;
        if (Boolean.getBoolean("cecilia.mbsa.stepper.statistics")) {
            delegate = new StatisticsStepper(delegate);
        }
        TransStepper stepper = new TransStepper(delegate);
        Map<String, String> params = this.recupParams();
        ArrayList<String> args = new ArrayList<String>(params.size());
        for (Map.Entry<String, String> item : params.entrySet()) {
            args.add(item.getKey() + "=\"" + item.getValue() + "\"");
        }
        if (!stepper.setSimulOptions(args)) {
            this.log("Stepper configure with warning\n" + params, 1);
        }
        stepper.configure(destFile, new ReaderCompilerTranslate(), params);
        stepper.setBanEntry(this.getBanEntry());
        this.getProcess().setIdObject(id, stepper, 2);
        this.setResult(true);
    }
}

