/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.ban;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyItem;
import com.dassault.cecilia.lib.util.destination.Destination;
import com.dassault.cecilia.lib.util.destination.Layout;
import com.dassault.cecilia.lib.util.destination.Record;
import com.dassault.cecilia.lib.util.destination.RecordString;

public class TransLayoutXML
extends Layout {
    private void formatTranslate(StringBuffer sb, TranslateException rec, String begin) {
        sb.append(begin).append("<translate-record>\n");
        TranslateException parent = rec.getParent();
        if (parent != null) {
            this.formatTranslate(sb, parent, begin + "  ");
        }
        sb.append(begin).append("  <type>").append(rec.getBaseName()).append("</type>\n");
        sb.append(begin).append("  <line>").append(rec.getLine()).append("</line>\n");
        sb.append(begin).append("  <code>").append(rec.getCodeMsg()).append("</code>\n");
        Object[] args = rec.getArgsMsg();
        if (args != null && args.length > 0) {
            switch (args.length) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(begin).append("  <args><arg>");
                    this.escapeXML(sb, args[0].toString());
                    sb.append("</arg></args>\n");
                    break;
                }
                default: {
                    sb.append(begin).append("  <args>\n");
                    for (int i = 0; i < args.length; ++i) {
                        sb.append(begin).append("    <arg>");
                        this.escapeXML(sb, args[i].toString());
                        sb.append("</arg>\n");
                    }
                    sb.append(begin).append("  </args>\n");
                }
            }
        }
        sb.append(begin).append("  <msg>");
        this.escapeXML(sb, rec.getMessage());
        sb.append("</msg>\n");
        sb.append(begin).append("</translate-record>\n");
    }

    private void formatVerif(StringBuffer sb, VerifyItem rec) {
        sb.append("<verify-record>\n");
        sb.append("  <type>").append(rec.getBaseName()).append("</type>\n");
        sb.append("  <line>").append(rec.getLine()).append("</line>\n");
        sb.append("  <construct-path>");
        this.escapeXML(sb, rec.getPath());
        sb.append("</construct-path>\n");
        sb.append("  <code>").append(rec.getCodeMsg()).append("</code>\n");
        Object[] args = rec.getArgsMsg();
        if (args != null && args.length > 0) {
            switch (args.length) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append("  <args><arg>");
                    this.escapeXML(sb, args[0].toString());
                    sb.append("</arg></args>\n");
                    break;
                }
                default: {
                    sb.append("  <args>\n");
                    for (int i = 0; i < args.length; ++i) {
                        sb.append("    <arg>");
                        this.escapeXML(sb, args[i].toString());
                        sb.append("</arg>\n");
                    }
                    sb.append("  </args>\n");
                }
            }
        }
        sb.append("  <msg>");
        this.escapeXML(sb, rec.getMessage());
        sb.append("</msg>\n");
        sb.append("  <data>");
        this.escapeXML(sb, rec.getDataToString());
        sb.append("</data>\n");
        sb.append("</verify-record>\n");
    }

    @Override
    public String format(Record rec) {
        if (rec instanceof RecordString) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("<string-record>\n");
            sb.append("  <msg>");
            this.escapeXML(sb, rec.toString());
            sb.append("</msg>\n");
            sb.append("</string-record>\n");
            return sb.toString();
        }
        if (rec instanceof TranslateException) {
            StringBuffer sb = new StringBuffer(128);
            this.formatTranslate(sb, (TranslateException)rec, "");
            return sb.toString();
        }
        if (rec instanceof VerifyItem) {
            StringBuffer sb = new StringBuffer(128);
            this.formatVerif(sb, (VerifyItem)rec);
            return sb.toString();
        }
        throw new RuntimeException("Record unknow");
    }

    @Override
    public String getHead(Destination destination2) {
        StringBuffer sb = new StringBuffer(128);
        this.prepareHeadXML(sb, destination2);
        sb.append("<altarica-message>\n");
        return sb.toString();
    }

    @Override
    public String getTail(Destination destination2) {
        return "</altarica-message>\n";
    }
}

