/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.BoolDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainEnum;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainRange;
import com.dassault.cecilia.lib.mbsa.translator.model.FloatDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.IntDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.UndefDomain;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DomainDefine
implements Externalizable {
    ArrayList<Domain> _createDomains = new ArrayList();
    Map<Domain, Domain> _uniqueDomains = new HashMap<Domain, Domain>();
    ArrayList<String> _enumValToStr = new ArrayList();
    Map<String, Integer> _enumStrToVal = new TreeMap<String, Integer>();

    public Domain getUndef() {
        return UndefDomain.getInstance();
    }

    public Domain getBool() {
        return BoolDomain.getInstance();
    }

    public Domain getInt() {
        return IntDomain.getInstance();
    }

    public Domain getFloat() {
        return FloatDomain.getInstance();
    }

    public Domain createRange(int min, int max) {
        assert (min <= max);
        DomainRange keyDom = new DomainRange(min, max);
        Domain dom = this._uniqueDomains.get(keyDom);
        if (dom == null) {
            dom = keyDom;
            this.addDomain(dom);
        }
        return dom;
    }

    public Domain createEnum(List<String> enums) {
        assert (enums.size() > 0);
        DomainEnum keyDom = new DomainEnum(this, enums);
        Domain dom = this._uniqueDomains.get(keyDom);
        if (dom == null) {
            dom = keyDom;
            this.addDomain(dom);
        }
        return dom;
    }

    void addDomain(Domain dom) {
        dom.setIdx(this._createDomains.size());
        this._createDomains.add(dom);
        this._uniqueDomains.put(dom, dom);
    }

    public int getDomainSize() {
        return this._createDomains.size();
    }

    public Domain getDomainFromIndex(int idx) {
        return this._createDomains.get(idx);
    }

    public int getEnumSize() {
        return this._enumValToStr.size();
    }

    public String getEnumStr(int val) {
        return this._enumValToStr.get(val);
    }

    public Integer getEnumVal(String str) {
        return this._enumStrToVal.get(str);
    }

    Integer addEnumStr(String str) {
        Integer val = this._enumStrToVal.get(str);
        if (val == null) {
            val = this._enumValToStr.size();
            this._enumValToStr.add(str);
            this._enumStrToVal.put(str, val);
        }
        return val;
    }

    protected ArrayList<Integer> convertEnum(List<String> strs) {
        Collections.sort(strs);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < strs.size(); ++i) {
            result.add(this.addEnumStr(strs.get(i)));
        }
        return result;
    }

    public void rename(Model.RenameHelper helper) {
        this._enumStrToVal.clear();
        for (int i = 0; i < this._enumValToStr.size(); ++i) {
            String oldE = this._enumValToStr.get(i);
            String newE = helper.putEnum(null, oldE);
            this._enumValToStr.set(i, newE);
            this._enumStrToVal.put(newE, i);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        int size = this._enumValToStr.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._enumValToStr.get(i));
        }
        size = this._createDomains.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._createDomains.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size = in.readInt();
        this._enumValToStr.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            String enumStr = (String)in.readObject();
            this._enumValToStr.add(enumStr);
            this._enumStrToVal.put(enumStr, i);
        }
        size = in.readInt();
        this._createDomains.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            Domain dom = (Domain)in.readObject();
            this._createDomains.add(dom);
        }
    }

    public static void writeExternalDomain(Domain dom, ObjectOutput out) throws IOException {
        if (dom == UndefDomain.getInstance()) {
            out.writeShort(0);
        } else if (dom == BoolDomain.getInstance()) {
            out.writeShort(1);
        } else if (dom == IntDomain.getInstance()) {
            out.writeShort(2);
        } else if (dom == FloatDomain.getInstance()) {
            out.writeShort(3);
        } else {
            out.writeShort(10);
            out.writeObject(dom);
        }
    }

    public static Domain readExternalDomain(ObjectInput in) throws IOException, ClassNotFoundException {
        switch (in.readShort()) {
            case 0: {
                return UndefDomain.getInstance();
            }
            case 1: {
                return BoolDomain.getInstance();
            }
            case 2: {
                return IntDomain.getInstance();
            }
            case 3: {
                return FloatDomain.getInstance();
            }
            case 10: {
                return (Domain)in.readObject();
            }
        }
        return UndefDomain.getInstance();
    }
}

