/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DomainEnum
extends Domain
implements Externalizable {
    protected ArrayList<Integer> _enums;
    protected DomainDefine _define;
    List<String> _stringValues = null;
    List<Double> _doubleValues = null;

    public DomainEnum(DomainDefine ddef, List<String> enums) {
        this._define = ddef;
        this._enums = this._define.convertEnum(enums);
    }

    public DomainEnum() {
        this._define = null;
        this._enums = null;
    }

    @Override
    public Iterator<String> getSymbolic() {
        return new SymbolicIterator(this._enums.iterator());
    }

    public int hashCode() {
        int result = 11;
        for (int i = this._enums.size() - 1; i >= 0; --i) {
            result += this._enums.get(i).intValue();
            if (i <= 0) continue;
            result *= 3;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DomainEnum domain = (DomainEnum)obj;
        return this._enums.equals(domain._enums);
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    @Override
    public boolean verifyValueOf(Expr expr) {
        if (expr.getScale() != Expr.Scale.Symbolic) {
            return false;
        }
        int ival = expr.getSymbol();
        Iterator<Integer> i = this._enums.iterator();
        while (i.hasNext()) {
            if (ival != i.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean verifyValueOf(double value) {
        int ival = (int)value;
        Iterator<Integer> i = this._enums.iterator();
        while (i.hasNext()) {
            if (ival != i.next()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void printDefLL(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        out.write(this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this._enums.size() * 10);
        sb.append("{");
        for (int i = 0; i < this._enums.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._define.getEnumStr(this._enums.get(i)));
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void printDefJava(IndentWriter out) throws IOException {
        out.addData(this);
        out.write("createEnum( new String[] {\n    ");
        for (int i = 0; i < this._enums.size(); ++i) {
            if (i > 0) {
                out.write(", ");
                if (i % 6 == 0) {
                    out.write("\n    ");
                }
            }
            out.write("\"");
            out.write(this._define.getEnumStr(this._enums.get(i)));
            out.write("\"");
        }
        out.write("} ) ");
    }

    @Override
    public void printDefaultValue(IndentWriter out) throws IOException {
        out.write("getEnumValue(\"");
        out.write(this._define.getEnumStr(this._enums.get(0)));
        out.write("\")");
    }

    @Override
    public boolean isDefLL() {
        return true;
    }

    @Override
    public int getNbrValue() {
        return this._enums.size();
    }

    @Override
    public double getDouble(int idx) {
        return this._enums.get(idx).intValue();
    }

    @Override
    public String toString(double value) {
        if (Double.isNaN(value)) {
            return "NaN";
        }
        int i = (int)value;
        return this._define.getEnumStr(i);
    }

    @Override
    public double parse(String sval) {
        for (int val : this._enums) {
            String str = this._define.getEnumStr(val);
            if (!str.equals(sval)) continue;
            return val;
        }
        return Double.NaN;
    }

    @Override
    public List<String> getStringValues() {
        if (this._stringValues == null) {
            this._stringValues = new ArrayList<String>(this._enums.size() + 1);
            for (Integer idxEnum : this._enums) {
                this._stringValues.add(this._define.getEnumStr(idxEnum));
            }
        }
        return this._stringValues;
    }

    @Override
    public List<Double> getDoubleValues() {
        if (this._doubleValues == null) {
            this._doubleValues = new ArrayList<Double>(this._enums.size() + 1);
            for (Integer idxEnum : this._enums) {
                this._doubleValues.add((double)idxEnum);
            }
        }
        return this._doubleValues;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._idx);
        out.writeObject(this._define);
        int size = this._enums.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeInt(this._enums.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._idx = in.readInt();
        this._define = (DomainDefine)in.readObject();
        int size = in.readInt();
        this._enums = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this._enums.add(in.readInt());
        }
    }

    class SymbolicIterator
    implements Iterator<String> {
        Iterator<Integer> _intIterator = null;

        public SymbolicIterator(Iterator<Integer> intIterator) {
            this._intIterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this._intIterator.hasNext();
        }

        @Override
        public String next() {
            Integer ival = this._intIterator.next();
            if (ival == null) {
                return "<error>";
            }
            return DomainEnum.this._define.getEnumStr(ival);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

