/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class DomainRange
extends Domain
implements Externalizable {
    protected int _min;
    protected int _max;
    List<String> _stringValues = null;
    List<Double> _doubleValues = null;

    public DomainRange(int min, int max) {
        this._min = min;
        this._max = max;
    }

    public DomainRange() {
    }

    public int hashCode() {
        return (7 + this._min) * 5 + this._max;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        DomainRange domain = (DomainRange)obj;
        if (this._min != domain._min) {
            return false;
        }
        return this._max == domain._max;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public boolean verifyValueOf(Expr expr) {
        if (expr.getScale() != Expr.Scale.Integer) {
            return false;
        }
        long ival = expr.getInt();
        return ival >= (long)this._min && ival <= (long)this._max;
    }

    @Override
    public boolean verifyValueOf(double value) {
        int ival = (int)value;
        return ival >= this._min && ival <= this._max;
    }

    @Override
    public void printDefLL(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        out.write(this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(32);
        sb.append("[").append(this._min).append(",").append(this._max).append("]");
        return sb.toString();
    }

    @Override
    public boolean isDefLL() {
        return true;
    }

    @Override
    public void printDefJava(IndentWriter out) throws IOException {
        out.addData(this);
        out.write("createRange(");
        out.write(String.valueOf(this._min));
        out.write(",");
        out.write(String.valueOf(this._max));
        out.write(")");
    }

    @Override
    public void printDefaultValue(IndentWriter out) throws IOException {
        out.write(String.valueOf(this._min));
    }

    @Override
    public int getNbrValue() {
        return this._max - this._min + 1;
    }

    @Override
    public double getDouble(int idx) {
        return this._min + idx;
    }

    @Override
    public String toString(double value) {
        long i = (int)value;
        return Long.toString(i);
    }

    @Override
    public double parse(String strValue) {
        try {
            long res = Long.parseLong(strValue);
            if (res >= (long)this._min && res <= (long)this._max) {
                return res;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Double.NaN;
    }

    @Override
    public List<String> getStringValues() {
        if (this._stringValues == null) {
            this._stringValues = new ArrayList<String>(this._max - this._min + 2);
            for (long i = (long)this._min; i <= (long)this._max; ++i) {
                this._stringValues.add(Long.toString(i));
            }
        }
        return this._stringValues;
    }

    @Override
    public List<Double> getDoubleValues() {
        if (this._doubleValues == null) {
            this._doubleValues = new ArrayList<Double>(this._max - this._min + 2);
            for (long i = (long)this._min; i <= (long)this._max; ++i) {
                this._doubleValues.add(Double.valueOf(i));
            }
        }
        return this._doubleValues;
    }

    @Override
    public boolean verifyValue(double value) {
        if (value - (double)((int)value) != 0.0) {
            return false;
        }
        if (value < (double)this._min) {
            return false;
        }
        return !(value > (double)this._max);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._idx);
        out.writeInt(this._min);
        out.writeInt(this._max);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._idx = in.readInt();
        this._min = in.readInt();
        this._max = in.readInt();
    }
}

