/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;

public class ExprCst
extends Expr {
    @Override
    Expr.Scale defineScale() {
        return this._scale;
    }

    public ExprCst() {
    }

    ExprCst(boolean bval) {
        this._scale = Expr.Scale.Boolean;
        this._double = bval ? 1.0 : 0.0;
    }

    public ExprCst(long ival) {
        this._scale = Expr.Scale.Integer;
        this._double = ival;
    }

    public ExprCst(double fval) {
        this._scale = Expr.Scale.Float;
        this._double = fval;
    }

    ExprCst(double val, Expr.Scale scale) {
        this._scale = scale;
        this._double = val;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Expr oth = (Expr)obj;
        if (this._scale != oth.getScale()) {
            return false;
        }
        return this._double == oth._double;
    }

    @Override
    protected void copy(Data src) {
        super.copy(src);
        this._scale = ((Expr)src).getScale();
    }

    protected String valueToString() {
        switch (this.getScale()) {
            case Boolean: {
                return this.getBool() ? "true" : "false";
            }
            case Integer: {
                return Long.toString(this.getInt());
            }
            case Float: {
                return Double.toString(this.getDouble());
            }
            case Symbolic: {
                return "[Enum]:" + this.getSymbol();
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getArgCount() {
        return 0;
    }

    @Override
    public Expr getArg(int i) {
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public void setArg(int i, Expr expr) {
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append(this.valueToString());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    protected void instance(Data src) {
        super.instance(src);
        this._scale = ((Expr)src).getScale();
    }

    @Override
    protected Expr instance(Node owner, String inst) {
        if (this == owner.getModel().getBooleanExpr(true) || this == owner.getModel().getBooleanExpr(false)) {
            return owner.addUniqueExpr(this);
        }
        ExprCst res = new ExprCst();
        res.instance(this);
        return owner.addUniqueExpr(res);
    }

    @Override
    public void verifyGuard(VerifyManager mng, Data src) {
        if (this.isBoolean()) {
            if (this.getBool()) {
                if (mng.withWarning("GuardTrue")) {
                    mng.addError("GuardTrue", src, "WRN_GUARD_TRUE", new Object[0]);
                }
            } else if (mng.withWarning("GuardFalse")) {
                mng.addError("GuardFalse", src, "WRN_GUARD_FALSE", new Object[0]);
            }
        }
        super.verifyGuard(mng, src);
    }

    @Override
    public void printJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        out.addData(this);
        switch (this.getScale()) {
            case Boolean: {
                out.write(this.getBool() ? "1." : "0.");
                break;
            }
            case Symbolic: {
                out.write("getEnumValue(\"");
                out.write(this.valueToString());
                out.write("\")");
                break;
            }
            case Integer: {
                out.write(Long.toString((long)this._double));
                break;
            }
            case Float: {
                out.write(Double.toString(this._double));
            }
        }
    }

    @Override
    public void printNaNJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        this.printJava(out, outs, csts);
    }

    @Override
    public void printMoca(IndentWriter out) throws IOException {
        out.addData(this);
        if (this.getScale() == Expr.Scale.Symbolic) {
            out.write("'e..");
            out.write(this.valueToString());
            out.write("'");
        } else {
            out.write(this.valueToString());
        }
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        out.write(this.valueToString());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeShort(this._scale.getIndex());
        out.writeDouble(this._double);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._scale = Expr.Scale.valueOf(in.readShort());
        this._double = in.readDouble();
    }
}

