/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprCst;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExprCstEnum
extends ExprCst
implements Comparable<ExprCstEnum> {
    String _strValue;

    public ExprCstEnum(String strValue) {
        super(-1.0, Expr.Scale.Symbolic);
        this._strValue = strValue;
    }

    public ExprCstEnum(int ivalue, String strValue) {
        super(ivalue, Expr.Scale.Symbolic);
        this._strValue = strValue;
    }

    @Override
    public String getString() {
        return this._strValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._strValue);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._strValue = (String)in.readObject();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExprCstEnum oth = (ExprCstEnum)obj;
        return this._strValue.equals(oth._strValue);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 7 + this._strValue.hashCode();
        return result;
    }

    @Override
    protected void copy(Data dataSrc) {
        super.copy(dataSrc);
        if (dataSrc instanceof ExprCstEnum) {
            this._strValue = ((ExprCstEnum)dataSrc)._strValue;
        }
    }

    @Override
    protected Expr instance(Node owner, String inst) {
        ExprCstEnum res = new ExprCstEnum(-1, this._strValue);
        res.instance(this);
        return owner.addUniqueExpr(res);
    }

    @Override
    protected String valueToString() {
        return this._strValue;
    }

    @Override
    public int compareTo(ExprCstEnum o) {
        return this._strValue.compareTo(o._strValue);
    }

    @Override
    public Expr convertVar(Node node) throws TranslateException {
        Var var = null;
        if (var == null) {
            var = (Var)node.findData(2, node, this._strValue);
        }
        if (var == null) {
            var = (Var)node.findData(1, node, this._strValue);
        }
        if (var != null) {
            String context = this._strValue.substring(0, this._strValue.length() - var.getName().length());
            ExprVar result = new ExprVar(var, context);
            result.setPosition(this.getStart());
            return node.addUniqueExpr(result);
        }
        if (!node.isSymbolic(this._strValue)) {
            throw new TranslateException(this, "EXC_EXPR_SYMBOL_UNKOW", this._strValue);
        }
        this._double = node.getModel().getDomainDefine().getEnumVal(this._strValue).intValue();
        return node.addUniqueExpr(this);
    }

    @Override
    public Expr verifySymbolic(Var var) {
        if (var.getDomain().verifyValueOf(this)) {
            return null;
        }
        return this;
    }
}

