/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.Fct;
import com.dassault.cecilia.lib.mbsa.translator.model.FloatDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExprFct
extends ExprOp {
    private Fct _fct;

    private ExprFct(Fct fct) {
        this._fct = fct;
        this._args = null;
    }

    public ExprFct(Fct fct, List<Expr> args) {
        this._fct = fct;
        this.setArgs(args);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExprFct oth = (ExprFct)obj;
        return this._fct == oth._fct;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 17 + this._fct.getName().hashCode();
        return result;
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append("fct(");
        sb.append(this._fct.getName());
        sb.append(")");
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isStructured() {
        return this._fct.isStructured();
    }

    @Override
    public Domain getDomain() {
        return this._fct.getDomain();
    }

    @Override
    Expr.Scale defineScale() {
        if (this.getDomain().isBoolean()) {
            this._scale = Expr.Scale.Boolean;
            return this._scale;
        }
        if (this.getDomain().isSymbolic()) {
            this._scale = Expr.Scale.Symbolic;
            return this._scale;
        }
        if (!this.getDomain().isNumeric()) {
            this._scale = Expr.Scale.Undef;
            return this._scale;
        }
        if (this.getDomain() == FloatDomain.getInstance()) {
            this._scale = Expr.Scale.Float;
            return this._scale;
        }
        this._scale = Expr.Scale.Integer;
        return this._scale;
    }

    @Override
    protected Expr simplifyConstant(Node node) throws TranslateException {
        return this;
    }

    @Override
    public Expr verify(Node node, boolean affect) throws TranslateException {
        boolean bChange = false;
        Expr[] argsChange = new Expr[this._args.length];
        for (int i = 0; i < this.getArgCount(); ++i) {
            Expr arg = this.getArg(i);
            argsChange[i] = arg.verify(node, affect);
            if (arg == argsChange[i]) continue;
            bChange = true;
        }
        this._fct.verify(node, this, argsChange);
        if (bChange) {
            ExprFct result = new ExprFct(this._fct);
            ((ExprOp)result)._args = argsChange;
            return node.addUniqueExpr(result);
        }
        return this;
    }

    @Override
    public Expr translateFct(Node node) {
        super.translateFct(node);
        return this._fct.translate(node, this._args);
    }

    @Override
    protected Expr instance(Node owner, String inst) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        throw new IOException("Error translate Function to Java simulator");
    }

    @Override
    public void printNaNJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        throw new IOException("Error translate Function to Java simulator");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IOException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IOException();
    }
}

