/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.translator.error.LoopManager;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.FloatDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ExprVar
extends Expr {
    private static Logger _LOG = Logger.getLogger(ExprVar.class.getPackage().getName());
    private Var _var;
    private String _context;

    public ExprVar() {
        this(null);
    }

    public ExprVar(Var var) {
        this._var = var;
        this._context = "";
    }

    public ExprVar(Var var, String context) {
        this._var = var;
        this._context = context == null ? "" : context;
    }

    public Var getVar() {
        return this._var;
    }

    public String getContext() {
        return this._context;
    }

    void setContext(String value) {
        this._context = value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._var);
        out.writeObject(this._context);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._var = (Var)in.readObject();
        this._context = (String)in.readObject();
    }

    @Override
    protected void copy(Data src) {
        super.copy(src);
        ExprVar Src = (ExprVar)src;
        if (Src._context != null) {
            this._context = new String(Src._context);
        }
        if (Src._var != null) {
            this._var = Src._var;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        ExprVar oth = (ExprVar)obj;
        if (this._var != oth._var) {
            return false;
        }
        return this._context.equals(oth._context);
    }

    @Override
    public int hashCode() {
        int result = new StringBuffer(64).append(this._context).append(".").append(this._var.getName()).toString().hashCode() + 13;
        return result;
    }

    @Override
    public int getArgCount() {
        return 0;
    }

    @Override
    public Expr getArg(int i) {
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public void setArg(int i, Expr expr) {
        throw new ArrayIndexOutOfBoundsException(i);
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append(this._context);
        sb.append(this._var.getName());
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isStructured() {
        return this._var.getDomain().isStructured();
    }

    @Override
    Expr.Scale defineScale() {
        if (this.getDomain().isBoolean()) {
            this._scale = Expr.Scale.Boolean;
            return this._scale;
        }
        if (this.getDomain().isSymbolic()) {
            this._scale = Expr.Scale.Symbolic;
            return this._scale;
        }
        if (!this.getDomain().isNumeric()) {
            this._scale = Expr.Scale.Undef;
            return this._scale;
        }
        if (this.getDomain() == FloatDomain.getInstance()) {
            this._scale = Expr.Scale.Float;
            return this._scale;
        }
        this._scale = Expr.Scale.Integer;
        return this._scale;
    }

    @Override
    public Domain getDomain() {
        return this._var.getDomain();
    }

    @Override
    public Expr verifySymbolic(Var var) {
        return var.getDomain().equals(this.getDomain()) ? null : this;
    }

    boolean isOrientationFlow(char orient) {
        if (!(this._var instanceof Flow)) {
            return false;
        }
        if (((Flow)this._var).getOrientation() != orient) {
            return false;
        }
        return this._context.length() == 0;
    }

    boolean isFlowIn(Node node) {
        if (!(this._var instanceof Flow)) {
            return false;
        }
        return ((Flow)this._var).getOrientation() == (this._context.length() == 0 ? (char)'\u0001' : '\u0002');
    }

    public Var getInstanceVar(Node parent, String inst) {
        Var var;
        String name = inst + "." + this._var.getName();
        if (inst.length() == 0 || this._context.length() > 0) {
            name = this._context + this._var.getName();
        }
        if ((var = null) == null) {
            var = parent.getFlow(name);
        }
        if (var == null) {
            var = parent.getState(name);
        }
        if (var == null) {
            throw new UnsupportedOperationException("Error Expr::instance(" + parent.getName() + ", \"" + inst + "\") [" + this.toString() + "]");
        }
        return var;
    }

    @Override
    protected Expr instance(Node owner, String inst) {
        Var var = this.getInstanceVar(owner, inst);
        Simular simVar = var.getSimular();
        if (simVar == null) {
            simVar = new Simular(owner, var);
            var.setSimular(simVar);
        }
        return owner.addUniqueExpr(simVar.getExprVar());
    }

    @Override
    public Expr translateLink(Node node) {
        if (this._context.indexOf(94) >= 0) {
            return node.createExpr(this.toString(), node);
        }
        return super.translateLink(node);
    }

    @Override
    public void rename(Model.RenameHelper helper, Node node) {
        String tmp = helper.convertPath(this._context, node);
        if (tmp == null) {
            assert (false) : this._context + this._var.getName();
        } else {
            this._context = tmp;
        }
        super.rename(helper, node);
    }

    @Override
    public boolean useVar(Var var) {
        return this._var == var;
    }

    @Override
    protected Flow getFirstFlow() {
        if (this._var instanceof Flow) {
            return (Flow)this._var;
        }
        return super.getFirstFlow();
    }

    @Override
    protected void verifyLoop(LoopManager mng, LinkedList<Var> lst, Map<Var, Expr> affects) {
        if (this._var._flag == 'W') {
            lst.addLast(this._var);
            mng.addLoop(LoopManager.realLoop(lst));
            lst.removeLast();
        } else if (this._var._flag == 'I') {
            this._var._flag = (char)87;
            this._flag = (char)87;
            Expr affect = affects.get(this._var);
            if (affect != null) {
                lst.addLast(this._var);
                affect.verifyLoop(mng, lst, affects);
                lst.removeLast();
            }
            this._var._flag = (char)84;
            this._flag = (char)84;
        }
    }

    public void verifyLoop(LoopManager mng, Expr affect, Map<Var, Expr> affects) {
        if (this._var._flag == 'W') {
            _LOG.severe("Unconsistency loop with: " + this.getVar().getName());
        } else if (this._var._flag == 'I') {
            this._var._flag = (char)87;
            this._flag = (char)87;
            if (affect != null) {
                LinkedList<Var> lst = new LinkedList<Var>();
                lst.addLast(this._var);
                affect.verifyLoop(mng, lst, affects);
                lst.removeLast();
            }
            this._var._flag = (char)84;
        }
        this._flag = (char)84;
    }

    @Override
    public void printJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        out.addData(this);
        Expr cst = null;
        if (csts != null) {
            cst = csts.get(this.toString());
        }
        if (cst != null) {
            cst.printJava(out, outs, csts);
        } else if (outs == null) {
            if (this._var instanceof State) {
                out.write("getState(\"");
            } else {
                out.write("getFlow(\"");
            }
            out.write(this._context);
            out.write(this._var.getName());
            out.write("\").getValue()");
        } else {
            out.write(ExprVar.toIDJava(this.toString()));
            if (this._var instanceof Flow && outs.contains(this.toString())) {
                out.write(".getValue()");
            }
        }
    }

    @Override
    public void printNaNJava(IndentWriter out, Set<String> outs, Map<String, Expr> csts) throws IOException {
        Expr cst = null;
        if (csts != null) {
            cst = csts.get(this.toString());
        }
        if (cst != null) {
            cst.printNaNJava(out, outs, csts);
        } else {
            out.write(ExprVar.toIDJava(this.toString()));
            if (this._var instanceof Flow && outs.contains(this.toString())) {
                out.write(".getValue()");
            }
        }
    }

    @Override
    protected void printVarDeclarationJava(IndentWriter out, Set<String> vars, Set<String> outs, Map<String, Expr> csts, Map<String, Expr> links) throws IOException {
        String name = this._context + this._var.getName();
        if (!vars.contains(name)) {
            out.addData(this);
            if (this._var instanceof State) {
                out.write("double ");
                out.write(Expr.toIDJava(name));
                out.write(" = getState(\"");
                out.write(name);
                out.write("\").getValue();\n");
            } else if (this._var instanceof Flow) {
                if (!csts.containsKey(name)) {
                    if (outs.contains(name)) {
                        out.write("JVariable ");
                        out.write(Expr.toIDJava(name));
                        out.write(" = getFlow(\"");
                        out.write(name);
                        out.write("\");\n");
                    } else {
                        out.write("double ");
                        out.write(Expr.toIDJava(name));
                        out.write(" = getFlow(\"");
                        out.write(name);
                        out.write("\").getValue();\n");
                    }
                }
            } else {
                throw new IOException("Internal error : Variable type unknow");
            }
            vars.add(name);
        }
    }

    @Override
    public void printMoca(IndentWriter out) throws IOException {
        out.addData(this);
        out.write("'");
        out.write(this._context);
        out.write(this._var == null ? "<null>" : this._var.getName());
        out.write("'");
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        out.addData(this);
        if (this._var == null) {
            out.write("<null>");
        } else if (this._context.length() == 0) {
            String name = this._var.getName();
            if (frm == 4 && name.indexOf(46) != -1) {
                out.write(name.replaceAll("\\.", "^^"));
            } else {
                out.write(name);
            }
        } else {
            out.write(this._context);
            String name = this._var.getName();
            if (frm == 4 && name.indexOf(46) != -1) {
                out.write(name.replaceAll("\\.", "^^"));
            } else {
                out.write(name);
            }
        }
    }

    @Override
    public String toString() {
        return this._context + this._var.getName();
    }

    @Override
    public boolean evaluateWithNaN() throws StepperException {
        if (Double.isNaN(this._var.getSimular().getValue())) {
            return false;
        }
        return super.evaluateWithNaN();
    }

    @Override
    public void verifyExpr(VerifyManager mng) {
        String type = "ExprState";
        if (mng.withWarning(type) && this._var instanceof State && this._context != null && !this._context.isEmpty()) {
            mng.addError(type, this, "WRN_EXPR_STATE", this.toString());
        }
        super.verifyExpr(mng);
    }
}

