/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupIndependant {
    List<Trans> _transs = new ArrayList<Trans>();
    Set<Event> _events = new LinkedHashSet<Event>();
    Set<State> _states = new LinkedHashSet<State>();
    Set<Flow> _flows = new LinkedHashSet<Flow>();
    int _groupID = -1;

    public GroupIndependant(int id) {
        this._groupID = id;
    }

    void addTrans(Trans data) {
        this._transs.add(data);
        data.setGroupID(this._groupID);
        this._events.add(data.getEvent());
    }

    void addVar(Var var) {
        if (var instanceof State) {
            this._states.add((State)var);
        } else {
            this._flows.add((Flow)var);
        }
        var.setGroupID(this._groupID);
    }

    private void merge(GroupIndependant other) {
        for (Trans trans : other._transs) {
            this._transs.add(trans);
            trans.setGroupID(this._groupID);
        }
        for (Event event : other._events) {
            this._events.add(event);
        }
        for (State state : other._states) {
            this._states.add(state);
            state.setGroupID(this._groupID);
        }
        for (Flow flow : other._flows) {
            this._flows.add(flow);
            flow.setGroupID(this._groupID);
        }
    }

    private void merge(int groupID, Map<Integer, GroupIndependant> groups) {
        GroupIndependant group = groups.get(groupID);
        if (group == null) assert (false);
        this.merge(group);
        groups.remove(groupID);
    }

    public void recupFrom(Var var, Map<Integer, GroupIndependant> groups) {
        Var refVar = var.getSimular().getVar();
        int id = refVar.getGroupID();
        if (id == this._groupID) {
            return;
        }
        if (id != -1) {
            this.merge(id, groups);
        } else {
            this.addVar(refVar);
            Expr define = refVar.getSimular().getDefine();
            if (define != null) {
                this.recupFrom(define, groups);
            }
        }
    }

    public void recupFrom(Expr expr, Map<Integer, GroupIndependant> groups) {
        if (expr instanceof ExprVar) {
            Var var = ((ExprVar)expr).getVar();
            this.recupFrom(var, groups);
        } else {
            int nbrArg = expr.getArgCount();
            for (int i = 0; i < nbrArg; ++i) {
                this.recupFrom(expr.getArg(i), groups);
            }
        }
    }

    public void recupFrom(Trans tr, Map<Integer, GroupIndependant> groups) {
        int id = tr.getGroupID();
        if (id == this._groupID) {
            return;
        }
        if (id != -1) {
            this.merge(id, groups);
        } else {
            this.addTrans(tr);
            this.recupFrom(tr.getGuard(), groups);
            List<Data> affects = tr.getAffects();
            int nbrAffect = affects.size();
            for (int j = 0; j < nbrAffect; j += 2) {
                this.recupFrom((State)affects.get(j), groups);
                this.recupFrom((Expr)affects.get(j + 1), groups);
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append(this._groupID).append(" |- {");
        Iterator<Event> iEvt = this._events.iterator();
        while (iEvt.hasNext()) {
            sb.append(iEvt.next().getName());
            if (!iEvt.hasNext()) continue;
            sb.append(",");
        }
        sb.append("} -> [");
        Iterator<Var> iVar = this._states.iterator();
        while (iVar.hasNext()) {
            sb.append(((Var)iVar.next()).getName());
            if (!iVar.hasNext()) continue;
            sb.append(",");
        }
        sb.append("] := [");
        iVar = this._flows.iterator();
        while (iVar.hasNext()) {
            sb.append(iVar.next().getName());
            if (!iVar.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

