/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.error.MessageManager;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.LineCorrespondence;
import com.dassault.cecilia.lib.util.destination.Record;
import com.dassault.cecilia.lib.util.destination.RecordString;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndentWriter
implements LineCorrespondence {
    private Writer _write;
    private StringBuffer _buffer;
    private String _indent;
    private int _cpt;
    private boolean _newLine;
    private int _nbr;
    private Map<Integer, List<Data>> _lines = new HashMap<Integer, List<Data>>();
    private boolean _exportString = false;

    public IndentWriter(Writer write) {
        this(write, "  ");
    }

    public IndentWriter(Writer write, String base) {
        this._write = write;
        this._buffer = null;
        this._indent = base;
        this._cpt = 0;
        this._newLine = false;
        this._nbr = 1;
    }

    public IndentWriter(StringBuffer sb) {
        this(sb, "  ");
    }

    public IndentWriter(StringBuffer sb, String base) {
        this._write = null;
        this._buffer = sb;
        this._indent = base;
        this._cpt = 0;
        this._newLine = false;
        this._nbr = 1;
    }

    private void print(String txt) throws IOException {
        if (this._write != null) {
            this._write.write(txt);
        } else {
            this._buffer.append(txt);
        }
    }

    private void writeIndent() throws IOException {
        for (int i = 0; i < this._cpt; ++i) {
            this.print(this._indent);
        }
        ++this._nbr;
    }

    public void write(String add) throws IOException {
        int pos;
        if (this._exportString && (pos = add.indexOf(34)) != -1) {
            StringBuffer sb = new StringBuffer((add.length() + 10) * 125 / 100);
            while (pos != -1) {
                sb.append(add.substring(0, pos));
                sb.append("\\\"");
                add = add.substring(pos + 1);
                pos = add.indexOf(10);
            }
            add = sb.toString();
        }
        if (this._newLine) {
            this.writeIndent();
        }
        pos = add.indexOf("\n");
        while (pos != -1) {
            this.print(add.substring(0, pos + 1));
            if (pos == add.length() - 1) {
                this._newLine = true;
                return;
            }
            this.writeIndent();
            add = add.substring(pos + 1);
            pos = add.indexOf("\n");
        }
        this._newLine = false;
        this.print(add);
    }

    public void addIndent(int mod) {
        this._cpt += mod;
        assert (this._cpt >= 0);
    }

    public void exportString(boolean val) {
        this._exportString = val;
    }

    public void close(boolean writer) throws IOException {
        if (this._newLine) {
            this.writeIndent();
        }
        this._newLine = false;
        if (this._write != null) {
            if (writer) {
                this._write.close();
            } else {
                this._write.flush();
            }
        }
    }

    protected int getLine() {
        return this._nbr + (this._newLine ? 1 : 0);
    }

    public void addData(Data data) {
        int num = this.getLine();
        List<Data> line = this._lines.get(num);
        if (line == null) {
            line = new ArrayList<Data>();
            line.add(data);
            this._lines.put(num, line);
        } else {
            line.add(data);
        }
    }

    @Override
    public MessageManager getLineSource(int num) {
        LineManager mess = new LineManager();
        if (num >= this._lines.size()) {
            mess.add("Line unknow : " + num + "> eof");
            return mess;
        }
        List<Data> line = this._lines.get(num);
        if (line == null) {
            mess.add("Line " + num + "empty");
            return mess;
        }
        for (int i = 0; i < line.size(); ++i) {
            Data data = line.get(i);
            StringBuffer path = new StringBuffer(128);
            Data orig = data.findOrigin(path);
            StringBuffer sb = new StringBuffer(path.length() + 128);
            sb.append("OriginFile : ");
            sb.append(orig.getStart());
            sb.append(" : ");
            sb.append(path);
            sb.append(" [");
            sb.append(data.getNamedType());
            sb.append("]");
            mess.add(sb.toString());
        }
        return mess;
    }

    class LineManager
    extends ArrayList<String>
    implements MessageManager {
        LineManager() {
        }

        @Override
        public int getMsgCount() {
            return this.size();
        }

        @Override
        public String getMsg(int i) {
            return (String)this.get(i);
        }

        @Override
        public boolean withError() {
            return this.size() > 0;
        }

        @Override
        public Record getRecord(int i) {
            return new RecordString((String)this.get(i));
        }
    }
}

