/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.NodeReader;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.error.GenerateException;
import com.dassault.cecilia.lib.mbsa.translator.error.LoopManager;
import com.dassault.cecilia.lib.mbsa.translator.error.TranslateException;
import com.dassault.cecilia.lib.mbsa.translator.error.VerifyManager;
import com.dassault.cecilia.lib.mbsa.translator.model.ABool;
import com.dassault.cecilia.lib.mbsa.translator.model.AFloat;
import com.dassault.cecilia.lib.mbsa.translator.model.AInteger;
import com.dassault.cecilia.lib.mbsa.translator.model.ANumber;
import com.dassault.cecilia.lib.mbsa.translator.model.AString;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.DataFlow;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprFct;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprUndef;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.FloatDomain;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.GroupDepend;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Init;
import com.dassault.cecilia.lib.mbsa.translator.model.Link;
import com.dassault.cecilia.lib.mbsa.translator.model.LocalSimul;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.model.StoreExpr;
import com.dassault.cecilia.lib.mbsa.translator.model.Sub;
import com.dassault.cecilia.lib.mbsa.translator.model.Sync;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.util.compiler.DiagnosticArray;
import com.dassault.cecilia.lib.util.compiler.RAMFileManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class Node
extends ExprParent
implements NodeReader,
Externalizable {
    protected Model _parent;
    protected StoreExpr _storeExpr;
    protected String _name;
    private int _cpt = 1;
    private static final String PROP_NODE_VERIFY_EXPRS = "cecilia.mbsa.translator.node.VerifyExprs";
    private ArrayList<Flow> _flowLst = new ArrayList();
    private HashMap<String, Flow> _flowMap = new HashMap();
    private ArrayList<State> _stateLst = new ArrayList();
    private HashMap<String, State> _stateMap = new HashMap();
    private ArrayList<Event> _eventLst = new ArrayList();
    private HashMap<String, Event> _eventMap = new HashMap();
    private ArrayList<Node> _parentLst;
    private ArrayList<Sub> _subLst = new ArrayList();
    private HashMap<String, Sub> _subMap = new HashMap();
    private ArrayList<Trans> _transLst;
    protected ArrayList<Expr> _assertLst;
    protected Map<Expr, Integer> _assertIdxMap;
    private ArrayList<Sync> _syncLst;
    private ArrayList<Init> _initLst;
    private ArrayList<Extern> _externLst;
    public static final int FLOW = 1;
    public static final int STATE = 2;
    public static final int EVENT = 3;
    public static final int SUB = 4;
    private HashSet<String> _symbSet = new HashSet();
    private boolean _bDataflow = false;
    private static final boolean __DEBUG = true;
    private boolean _bFlatness = false;
    private static int __cptGeneratedJava = 0;
    private Map<Integer, GroupDepend> _groups = null;
    private static final boolean __TO_JAVA = false;

    public Node() {
        this._assertLst = new ArrayList();
        this._assertIdxMap = new HashMap<Expr, Integer>();
        this._transLst = new ArrayList();
        this._syncLst = new ArrayList();
        this._initLst = new ArrayList();
        this._externLst = new ArrayList();
    }

    public Node(Model parent, String name, StoreExpr.Type typeStore) {
        this();
        this._parent = parent;
        this._name = name;
        this._storeExpr = new StoreExpr(this, typeStore);
    }

    public Node(Model parent, String name) {
        this(parent, name, StoreExpr.Type.NONE);
    }

    public final Model getModel() {
        return this._parent;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public final int getCpt() {
        return this._cpt++;
    }

    public final Expr addUniqueExpr(Expr expr) {
        return this._storeExpr.addExpr(expr);
    }

    public final void delUniqueExpr(Expr expr) {
        this._storeExpr.delExpr(expr);
    }

    public final void garbageCollect() {
        this._storeExpr.garbageCollect();
    }

    public final StoreExpr getStoreExpr() {
        return this._storeExpr;
    }

    void debugVerifyExpr(Expr expr) {
        int nbrArgs = expr.getArgCount();
        for (int i = 0; i < nbrArgs; ++i) {
            this.debugVerifyExpr(expr.getArg(i));
        }
        if (this.getStoreExpr().get(expr) != expr) {
            MsgTrans.LOG.finest("ExprNotInNode: " + expr.toLL());
        }
        Iterator<ExprParent> iter = expr.getParents();
        while (iter.hasNext()) {
            ExprParent parent = iter.next();
            if (!(parent instanceof Expr)) continue;
            Expr exprParent = (Expr)parent;
            if (this.getStoreExpr().get(exprParent) == exprParent) continue;
            MsgTrans.LOG.finest("ExprParentNotInNode: " + exprParent.toLL());
        }
    }

    void debugVerifyExprs() {
        int i;
        if (!Boolean.getBoolean(PROP_NODE_VERIFY_EXPRS)) {
            return;
        }
        if (!MsgTrans.LOG.isLoggable(Level.FINEST)) {
            return;
        }
        for (i = 0; i < this.getAssertCount(); ++i) {
            Expr expr = this.getAssert(i);
            if (expr.isAliasAssert()) continue;
            this.debugVerifyExpr(expr);
        }
        for (i = 0; i < this.getTransCount(); ++i) {
            Trans tr = this.getTrans(i);
            this.debugVerifyExpr(tr.getGuard());
            List<Data> affects = tr.getAffects();
            int nbrAffect = affects.size();
            for (int j = 0; j < nbrAffect; j += 2) {
                this.debugVerifyExpr((Expr)affects.get(j + 1));
            }
        }
        for (i = 0; i < this.getInitCount(); ++i) {
            this.debugVerifyExpr(this.getInit(i).getExprValue());
        }
    }

    @Override
    public String getNamedType() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(super.getNamedType());
        sb.append("(");
        sb.append(this._name);
        sb.append(")");
        return sb.toString();
    }

    final void addPrivateFlow(Flow flow) {
        this._flowLst.add(flow);
        assert (!this._flowMap.containsKey(flow.getName()));
        this._flowMap.put(flow.getName(), flow);
    }

    protected void delFlow(Flow flow) {
        assert (this._flowMap.containsKey(flow.getName()));
        this._flowMap.remove(flow.getName());
        this._flowLst.remove(flow);
        this.purgeFlow(flow);
    }

    protected void purgeFlow(Flow flow) {
        for (int k = this.getExternCount() - 1; k >= 0; --k) {
            Extern ext = this.getExtern(k);
            if (!ext.purge(1, flow)) continue;
            this._externLst.remove(k);
        }
        if (this._parentLst != null) {
            for (int i = 0; i < this._parentLst.size(); ++i) {
                Node parent = this._parentLst.get(i);
                parent.purgeFlow(flow);
            }
        }
    }

    @Override
    public final int getFlowCount() {
        return this._flowLst.size();
    }

    @Override
    public final String getFlowName(int i) {
        return this.getFlow(i).getName();
    }

    public final Flow getFlow(int i) {
        return this._flowLst.get(i);
    }

    public final Flow getFlow(String name) {
        return this._flowMap.get(name);
    }

    public final boolean containFlow(Flow flow) {
        return this._flowLst.contains(flow);
    }

    public final Set<Flow> getFlows() {
        return new HashSet<Flow>(this._flowLst);
    }

    final void addPrivateState(State state) {
        this._stateLst.add(state);
        assert (!this._stateMap.containsKey(state.getName()));
        this._stateMap.put(state.getName(), state);
    }

    protected void delState(State state) {
        assert (this._stateMap.containsKey(state.getName()));
        this._stateMap.remove(state.getName());
        this._stateLst.remove(state);
        this.purgeState(state);
    }

    protected void purgeState(State state) {
        for (int k = this.getExternCount() - 1; k >= 0; --k) {
            Extern ext = this.getExtern(k);
            if (!ext.purge(2, state)) continue;
            this._externLst.remove(k);
        }
        if (this._parentLst != null) {
            for (int i = 0; i < this._parentLst.size(); ++i) {
                Node parent = this._parentLst.get(i);
                parent.purgeState(state);
            }
        }
    }

    @Override
    public final int getStateCount() {
        return this._stateLst.size();
    }

    @Override
    public final String getStateName(int i) {
        return this.getState(i).getName();
    }

    public final State getState(int i) {
        return this._stateLst.get(i);
    }

    public final State getState(String name) {
        return this._stateMap.get(name);
    }

    public final Set<State> getStates() {
        return new HashSet<State>(this._stateLst);
    }

    protected final Var getVar(String name) {
        Var var = null;
        if (var == null) {
            var = this.getState(name);
        }
        if (var == null) {
            var = this.getFlow(name);
        }
        return var;
    }

    protected final void addPrivateEvent(Event event) {
        this._eventLst.add(event);
        assert (!this._eventMap.containsKey(event.getName()));
        this._eventMap.put(event.getName(), event);
    }

    protected void delEvent(Event event) {
        assert (this._eventMap.containsKey(event.getName()));
        this._eventMap.remove(event.getName());
        this._eventLst.remove(event);
        this.purgeEvent(event);
    }

    protected void purgeEvent(Event event) {
        for (int k = this.getExternCount() - 1; k >= 0; --k) {
            Extern ext = this.getExtern(k);
            if (!ext.purge(3, event)) continue;
            this._externLst.remove(k);
        }
        if (this._parentLst != null) {
            for (int i = 0; i < this._parentLst.size(); ++i) {
                Node parent = this._parentLst.get(i);
                parent.purgeEvent(event);
            }
        }
    }

    @Override
    public final int getEventCount() {
        return this._eventLst.size();
    }

    @Override
    public final Event getEvent(int i) {
        return this._eventLst.get(i);
    }

    public final Event getEvent(String name) {
        return this._eventMap.get(name);
    }

    protected final void addParent(Node parent) {
        if (this._parentLst == null) {
            this._parentLst = new ArrayList();
        }
        if (!this._parentLst.contains(parent)) {
            this._parentLst.add(parent);
        }
    }

    protected final void addPrivateSub(Sub sub) {
        this._subLst.add(sub);
        assert (!this._subMap.containsKey(sub.getName()));
        this._subMap.put(sub.getName(), sub);
        sub.getType().addParent(this);
    }

    @Override
    public final int getSubCount() {
        return this._subLst.size();
    }

    @Override
    public final String getSubName(int i) {
        return this.getSub(i).getName();
    }

    @Override
    public final NodeReader getSubType(int i) {
        return this.getSub(i).getType();
    }

    public final Sub getSub(int i) {
        return this._subLst.get(i);
    }

    public final Sub getSub(String name) {
        return this._subMap.get(name);
    }

    protected final void addPrivateTrans(Trans tr) {
        this._transLst.add(tr);
    }

    public final int getTransCount() {
        return this._transLst.size();
    }

    public final Trans getTrans(int i) {
        return this._transLst.get(i);
    }

    public final int getAssertCount() {
        return this._assertLst.size();
    }

    public final Expr getAssert(int i) {
        return this._assertLst.get(i);
    }

    protected final void addPrivateAssert(Expr expr) {
        this._assertLst.add(expr);
    }

    protected final void addTranslateAssert(Expr expr) {
        this.addPrivateAssert(this._storeExpr.addExpr(expr));
    }

    public final int getSyncCount() {
        return this._syncLst.size();
    }

    public final Sync getSync(int i) {
        return this._syncLst.get(i);
    }

    protected void addTranslateSync(Sync sync) {
        String txt = sync.toString();
        for (int i = 0; i < this.getSyncCount(); ++i) {
            if (!txt.equals(this.getSync(i).toString())) continue;
            return;
        }
        this._syncLst.add(sync);
    }

    public final int getInitCount() {
        return this._initLst.size();
    }

    public final Init getInit(int i) {
        return this._initLst.get(i);
    }

    protected void addPrivateInit(Init init) {
        Iterator<Init> i = this._initLst.iterator();
        while (i.hasNext()) {
            Init other = i.next();
            if (other.getVar() != init.getVar() || !other.getPathVar().equalsIgnoreCase(init.getPathVar())) continue;
            i.remove();
            break;
        }
        this._initLst.add(init);
    }

    public final int getExternCount() {
        return this._externLst.size();
    }

    public final Extern getExtern(int i) {
        return this._externLst.get(i);
    }

    protected final void addTranslateExtern(Tree tree) {
        Extern extern = new Extern(tree);
        this._externLst.add(extern);
    }

    public Data findData(int type, Node current, String name) {
        Sub sub = null;
        int pos = name.indexOf(46);
        while (pos != -1) {
            String id = name.substring(0, pos);
            name = name.substring(pos + 1);
            sub = current.getSub(id);
            if (sub == null) {
                return null;
            }
            current = sub.getType();
            pos = name.indexOf(46);
        }
        switch (type) {
            case 1: {
                pos = name.indexOf(94);
                if (pos == -1) {
                    Flow flow = current.getFlow(name);
                    if (flow != null && sub != null && flow.getOrientation() == '\u0003') {
                        return null;
                    }
                    return flow;
                }
                Flow flow = current.getFlow(name.substring(0, pos));
                if (flow == null) {
                    return null;
                }
                if (sub != null && flow.getOrientation() == '\u0003') {
                    return null;
                }
                Domain domain = flow.getDomain();
                if (domain == null || !(domain instanceof Link)) {
                    return null;
                }
                return ((Link)domain).getFlow(name.substring(pos + 1));
            }
            case 2: {
                return current.getState(name);
            }
            case 3: {
                return current.getEvent(name);
            }
            case 4: {
                return current.getSub(name);
            }
        }
        return null;
    }

    public String findContext(int type, Node current, String name) {
        String id;
        StringBuffer sb = new StringBuffer();
        int pos = name.indexOf(46);
        while (pos != -1) {
            id = name.substring(0, pos);
            sb.append(id);
            sb.append('.');
            name = name.substring(pos + 1);
            Sub sub = current.getSub(id);
            if (sub == null) {
                return null;
            }
            current = sub.getType();
            pos = name.indexOf(46);
        }
        if (type == 1 && (pos = name.indexOf(94)) != -1) {
            id = name.substring(0, pos);
            sb.append(id);
            sb.append('^');
            Flow flow = current.getFlow(id);
            if (flow == null) {
                return null;
            }
        }
        return sb.toString();
    }

    protected boolean isSymbolic(String symbol) {
        if (this._symbSet.contains(symbol)) {
            return true;
        }
        for (int i = 0; i < this.getSubCount(); ++i) {
            if (!this.getSub(i).getType().isSymbolic(symbol)) continue;
            return true;
        }
        return false;
    }

    protected void addDomainToSymbolic(Domain dom) throws TranslateException {
        Iterator<String> i = dom.getSymbolic();
        while (i.hasNext()) {
            String symb = i.next();
            this.verifyNamedObj(symb, dom, true);
            this._symbSet.add(symb);
        }
    }

    protected void verifyNamedObj(String name, Data src, boolean onlyVar) throws TranslateException {
        if (this.getFlow(name) != null) {
            throw new TranslateException(src, "EXC_NODE_CONFICT_FLOW", name);
        }
        if (this.getState(name) != null) {
            throw new TranslateException(src, "EXC_NODE_CONFICT_STATE", name);
        }
        if (onlyVar) {
            return;
        }
        if (this.isSymbolic(name)) {
            throw new TranslateException(src, "EXC_NODE_CONFICT_SYMBOL", name);
        }
    }

    public void addFlow(Flow flow) throws TranslateException {
        this.verifyNamedObj(flow.getName(), flow, false);
        this.addDomainToSymbolic(flow.getDomain());
        this.addPrivateFlow(flow);
    }

    public void addState(State state) throws TranslateException {
        this.verifyNamedObj(state.getName(), state, false);
        this.addDomainToSymbolic(state.getDomain());
        this.addPrivateState(state);
    }

    public void addEvent(Event event) throws TranslateException {
        if (this.getEvent(event.getName()) != null) {
            throw new TranslateException(event, "EXC_EVENT_EXIST", event.getName());
        }
        this.addPrivateEvent(event);
    }

    public void addSub(Sub sub) throws TranslateException {
        if (this.getSub(sub.getName()) != null) {
            throw new TranslateException(sub, "EXC_SUB_EXIST", sub.getName());
        }
        this.addPrivateSub(sub);
    }

    public void addTrans(Tree tree) throws TranslateException {
        Expr guard;
        if (tree == null) {
            return;
        }
        assert (tree._type == 270);
        Expr originGuard = guard = (Expr)tree._son;
        if (guard.withType(ExprUndef.class)) {
            throw new TranslateException(guard, "EXC_EXPR_UNDEF", new Object[0]);
        }
        guard = guard.convertVar(this);
        if ((guard = guard.verify(this, false)).withType(ExprFct.class)) {
            throw new TranslateException(guard, "EXC_EXPR_FUNC", new Object[0]);
        }
        if (!guard.isBoolean()) {
            throw new TranslateException(originGuard, "EXC_TRANS_GUARD_NOBOOL", new Object[0]);
        }
        if (guard.isConstant() && !guard.getBool()) {
            throw new TranslateException(originGuard, "EXC_TRANS_GUARD_FALSE", new Object[0]);
        }
        Tree transLst = tree._next;
        while (transLst != null) {
            assert (transLst._type == 290);
            Trans tr = new Trans();
            tr.setPosition(tree.getStart());
            tr.setGuard(guard);
            Event evt = (Event)this.findData(3, this, transLst._sval);
            if (evt == null) {
                throw new TranslateException(transLst, "EXC_EVENT_UNKNOW", transLst._sval);
            }
            tr.setEvent(evt);
            Tree affectLst = (Tree)transLst._son;
            while (affectLst != null) {
                Expr badAffect;
                assert (affectLst._type == 292);
                State var = (State)this.findData(2, this, affectLst._sval);
                if (var == null) {
                    throw new TranslateException(affectLst, "EXC_STATE_UNKNOW", affectLst._sval);
                }
                Expr expr = (Expr)affectLst._son;
                if (expr.withType(ExprUndef.class)) {
                    throw new TranslateException(expr, "EXC_EXPR_UNDEF", new Object[0]);
                }
                expr = expr.convertVar(this);
                if ((expr = expr.verify(this, false)).withType(ExprFct.class)) {
                    throw new TranslateException(expr, "EXC_EXPR_FUNC", new Object[0]);
                }
                if (var.getDomain().isSymbolic() && (badAffect = expr.verifySymbolic(var)) != null) {
                    throw new TranslateException(expr, "EXC_EXPR_AFFECT_SYMBOL", var.toString(), var.getDomain().toString(), badAffect.toString());
                }
                tr.addAffect(var, expr);
                affectLst = affectLst._next;
            }
            this.addPrivateTrans(tr);
            transLst = transLst._next;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addAssert(Expr expr) throws TranslateException {
        if (expr == null) {
            return;
        }
        if (expr instanceof ExprFct) {
            throw new TranslateException(expr, "EXC_ASSERT_FUNCT", new Object[0]);
        }
        if (expr.withType(ExprUndef.class)) {
            throw new TranslateException(expr, "EXC_EXPR_UNDEF", new Object[0]);
        }
        expr = expr.convertVar(this);
        if ((expr = expr.verify(this, true)).isConstant()) {
            if (!expr.isBoolean()) throw new TranslateException(expr, "EXC_ASSERT_CST_NOBOOL", new Object[0]);
            if (expr.getBool()) return;
            throw new TranslateException(expr, "EXC_ASSERT_FALSE", new Object[0]);
        }
        if (ExprOp.isType(expr, ExprOp.Type.AND)) {
            for (int i = 0; i < expr.getArgCount(); ++i) {
                this.addPrivateAssert(expr.getArg(i));
            }
            return;
        } else {
            this.addPrivateAssert(expr);
        }
    }

    public void addSync(Sync sync) throws TranslateException {
        sync.verify(this);
        this._syncLst.add(sync);
    }

    public void addInit(Init init) throws TranslateException {
        init.verify(this);
        this.addPrivateInit(init);
    }

    public void addExtern(Tree tree) throws TranslateException {
        Extern extern = new Extern(tree);
        extern.verify(this);
        this._externLst.add(extern);
    }

    public Extern findExtern(String id, Tree tree) {
        for (int i = this._externLst.size() - 1; i >= 0; --i) {
            Extern Xtern = this._externLst.get(i);
            if (!Xtern.contains(id, tree)) continue;
            return Xtern;
        }
        return null;
    }

    public void verifyRead() throws TranslateException {
        int nbrEvt = this.getEventCount();
        int nbrTr = this.getTransCount();
        int nbrSync = this.getSyncCount();
        for (int i = 0; i < nbrEvt; ++i) {
            int j;
            Event evt = this.getEvent(i);
            boolean find = false;
            for (j = 0; !find && j < nbrTr; ++j) {
                if (this.getTrans(j).getEvent() != evt) continue;
                find = true;
            }
            for (j = 0; !find && j < nbrSync; ++j) {
                if (this.getSync(j).getSync() != evt) continue;
                find = true;
            }
            if (find) continue;
            throw new TranslateException(evt, "EXC_EVENT_ORPHAN", evt.getName());
        }
    }

    public void dataflow(boolean simul) throws TranslateException {
        if (this._bDataflow) {
            return;
        }
        this._bDataflow = true;
        if (this.getSubCount() > 0) {
            for (int i = 0; i < this.getSubCount(); ++i) {
                Sub sub = this.getSub(i);
                sub.getType().dataflow(simul);
            }
        }
        DataFlow df = new DataFlow(this, this._assertLst);
        df.action(simul);
        this._assertLst = new ArrayList(df.getAssert().size() + 1);
        this._assertIdxMap.clear();
        for (Expr expr : df.getAssert()) {
            this.addTranslateAssert(expr);
        }
        for (Flow local : df.getLocalNodef()) {
            if (this.useVar(local)) {
                throw df.CreateException("EXC_DFW_NOCONNECT_LOCAL", local.getName(), new Object[0]);
            }
            this.delFlow(local);
        }
    }

    public boolean useVar(Var var) {
        int i;
        for (i = 0; i < this.getTransCount(); ++i) {
            Trans tr = this.getTrans(i);
            if (tr.getGuard().useVar(var)) {
                return true;
            }
            List<Data> affects = tr.getAffects();
            for (int j = 1; j < affects.size(); j += 2) {
                Expr val = (Expr)affects.get(j);
                if (!val.useVar(var)) continue;
                return true;
            }
        }
        for (i = 0; i < this.getAssertCount(); ++i) {
            if (!this.getAssert(i).useVar(var)) continue;
            return true;
        }
        return false;
    }

    public void localSimul() throws TranslateException {
        if (this.getSubCount() == 0) {
            LocalSimul df = new LocalSimul(this, this._transLst);
            df.action();
        }
    }

    public Expr createExpr(String name, Node current) {
        StringBuffer context = new StringBuffer(name.length());
        int pos = name.indexOf(46);
        while (pos != -1) {
            String id = name.substring(0, pos);
            name = name.substring(pos + 1);
            Sub sub = current.getSub(id);
            if (sub == null) {
                return null;
            }
            context.append(id);
            context.append(".");
            current = sub.getType();
            pos = name.indexOf(46);
        }
        Var var = current.getFlow(name);
        if (var == null) {
            var = current.getState(name);
        }
        if (var == null) {
            return null;
        }
        return new ExprVar(var, context.toString());
    }

    public void translateAssert() {
        if (this.getAssertCount() > 0) {
            ArrayList<Expr> lst = this._assertLst;
            this._assertLst = new ArrayList();
            this._assertIdxMap.clear();
            for (int i = 0; i < lst.size(); ++i) {
                Expr expr = lst.get(i);
                Expr tr = expr.translateFct(this);
                this.addTranslateAssert(tr == null ? expr : tr);
            }
        }
    }

    public void translateFlow() {
        int i;
        ArrayList<Data> lst;
        block13: {
            if (this._flowLst.size() > 0) {
                lst = this._flowLst;
                this._flowLst = new ArrayList();
                this._flowMap.clear();
                try {
                    for (i = 0; i < lst.size(); ++i) {
                        Flow flow = (Flow)lst.get(i);
                        if (flow.getDomain().isStructured()) {
                            Link link = (Link)flow.getDomain();
                            link.createFlow(this, flow);
                            continue;
                        }
                        this.addFlow(flow);
                    }
                }
                catch (TranslateException pe) {
                    pe.printStackTrace();
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
        }
        if (this.getAssertCount() > 0) {
            lst = this._assertLst;
            this._assertLst = new ArrayList();
            this._assertIdxMap.clear();
            for (i = 0; i < lst.size(); ++i) {
                Expr expr = (Expr)lst.get(i);
                Expr tr = expr.translateLink(this);
                if (tr == null) {
                    this.addTranslateAssert(expr);
                    continue;
                }
                for (int j = 0; j < tr.getArgCount(); ++j) {
                    this.addTranslateAssert(tr.getArg(j));
                }
            }
        }
        if (this._transLst.size() > 0) {
            for (int i2 = 0; i2 < this._transLst.size(); ++i2) {
                Trans tr = this._transLst.get(i2);
                tr.translateLink(this);
            }
        }
        if (this._externLst.size() > 0) {
            for (int i3 = 0; i3 < this._externLst.size(); ++i3) {
                Extern Xtern = this._externLst.get(i3);
                Xtern.translateLink(this);
            }
        }
    }

    public void translateCCF(boolean withoutCCF) {
        ArrayList<Sync> lst = this._syncLst;
        this._syncLst = new ArrayList();
        for (int i = 0; i < lst.size(); ++i) {
            Sync sync = lst.get(i);
            if (sync.getType() == '\u0006') {
                if (withoutCCF) {
                    this.delEvent(sync.getSync());
                    continue;
                }
                sync.translateCCF(this);
                continue;
            }
            this.addTranslateSync(sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringWriter sw = new StringWriter();
        IndentWriter iw = new IndentWriter(sw, "  ");
        try {
            this.printOTools(iw, 100);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                iw.close(true);
            }
            catch (IOException iOException) {}
        }
        return sw.toString();
    }

    public String valueToString(Expr expr) {
        switch (expr.getScale()) {
            case Boolean: {
                return expr.getBool() ? "true" : "false";
            }
            case Integer: {
                return Long.toString(expr.getInt());
            }
            case Float: {
                return Double.toString(expr.getDouble());
            }
            case Symbolic: {
                if (expr.getSymbol() < 0) {
                    return expr.getString();
                }
                return this.getModel().getDomainDefine().getEnumStr(expr.getSymbol());
            }
        }
        throw new UnsupportedOperationException();
    }

    private void printLstLL(List<? extends Data> lst, String id, IndentWriter out, int frm, String sep) throws IOException {
        if (lst.size() > 0) {
            out.write(id + " \n");
            out.addIndent(1);
            for (int i = 0; i < lst.size(); ++i) {
                lst.get(i).printOTools(out, frm);
                if (i + 1 < lst.size()) {
                    out.write(sep);
                    continue;
                }
                out.write(";\n");
            }
            out.addIndent(-1);
        }
    }

    @Override
    public void printOTools(IndentWriter out, int frm) throws IOException {
        String name;
        int i;
        out.write(this._name);
        out.write("\n");
        out.addIndent(1);
        this.printLstLL(this._flowLst, "flow", out, frm, ";\n");
        this.printLstLL(this._stateLst, "state", out, frm, ";\n");
        if (frm == 4) {
            this.printEvtsMec5(out);
        } else {
            this.printLstLL(this._eventLst, "event", out, frm, frm == 2 ? ",\n" : ";\n");
        }
        this.printLstLL(this._subLst, "sub", out, frm, ";\n");
        this.printLstLL(this._transLst, "trans", out, frm, ";\n");
        boolean bAssert = false;
        if (this._storeExpr.getType() == StoreExpr.Type.EXPR) {
            for (i = 0; i < this._flowLst.size(); ++i) {
                Flow flow = this.getFlow(i);
                if (!flow.isAlias()) continue;
                if (!bAssert) {
                    out.write("assert \n");
                    out.addIndent(1);
                    bAssert = true;
                }
                if (frm == 100) {
                    out.write("/* alias */");
                }
                name = flow.getName();
                if (frm == 4 && name.indexOf(46) != -1) {
                    out.write(name.replaceAll("\\.", "^^"));
                } else {
                    out.write(name);
                }
                out.write(" = ");
                name = flow.getSimular().getVar().getName();
                if (frm == 4 && name.indexOf(46) != -1) {
                    out.write(name.replaceAll("\\.", "^^"));
                } else {
                    out.write(name);
                }
                out.write(frm == 2 && i + 1 < this.getAssertCount() ? ",\n" : ";\n");
            }
        }
        if (this.getAssertCount() > 0) {
            if (!bAssert) {
                out.write("assert \n");
                out.addIndent(1);
                bAssert = true;
            }
            for (i = 0; i < this.getAssertCount(); ++i) {
                this.getAssert(i).printAssertLL(out, frm);
                out.write(frm == 2 && i + 1 < this.getAssertCount() ? ",\n" : ";\n");
            }
        }
        if (bAssert) {
            out.addIndent(-1);
        }
        this.printLstLL(this._syncLst, "sync", out, frm, frm == 2 ? ",\n" : ";\n");
        if (this._bFlatness) {
            Simular simVar;
            assert (this._initLst.size() == 0);
            LinkedHashMap<String, Simular> inits = new LinkedHashMap<String, Simular>();
            for (Var var : this._stateLst) {
                simVar = var.getSimular();
                if (Double.isNaN(simVar.getInitValue()) || inits.containsKey(simVar.getName())) continue;
                inits.put(simVar.getName(), simVar);
            }
            for (Var var : this._flowLst) {
                simVar = var.getSimular();
                if (Double.isNaN(simVar.getInitValue()) || inits.containsKey(simVar.getName())) continue;
                inits.put(simVar.getName(), simVar);
            }
            if (inits.size() > 0) {
                out.write("init \n");
                out.addIndent(1);
                Iterator iSimVar = inits.values().iterator();
                while (iSimVar.hasNext()) {
                    Simular simular = (Simular)iSimVar.next();
                    name = simular.getName();
                    if (frm == 4 && name.indexOf(46) != -1) {
                        out.write(name.replaceAll("\\.", "^^"));
                    } else {
                        out.write(name);
                    }
                    out.write(" := ");
                    out.write(simular.getDomain().toString(simular.getInitValue()));
                    if (iSimVar.hasNext()) {
                        out.write(frm == 2 ? ",\n" : ";\n");
                        continue;
                    }
                    out.write(";\n");
                }
                out.addIndent(-1);
            }
        } else {
            this.printLstLL(this._initLst, "init", out, frm, frm == 2 ? ",\n" : ";\n");
        }
        if (frm != 4) {
            this.printLstLL(this._externLst, "extern", out, frm, ";\n");
        }
        out.addIndent(-1);
    }

    private void printEvtsMec5(IndentWriter out) throws IOException {
        if (this._eventLst.size() == 0) {
            return;
        }
        TreeMap<Integer, ArrayList<Event>> order = new TreeMap<Integer, ArrayList<Event>>();
        Tree tEvt = new Tree(268, 0L, 0.0, "", null, null);
        for (int i = 0; i < this.getEventCount(); ++i) {
            Extern xPrio;
            double delay;
            int priority = 0;
            Event evt = this.getEvent(i);
            tEvt._son = evt;
            Extern xLaw = this.findExtern("law", tEvt);
            if (xLaw != null && !Double.isNaN(delay = xLaw.delayOfLaw(this))) {
                if (delay < 0.0) {
                    throw new GenerateException(MsgTrans.getString("EXC_GEN_XLAW"));
                }
                priority = 1;
            }
            if ((xPrio = this.findExtern("priority", tEvt)) != null && (priority = 1 + xPrio.valueOfPriority()) < 1) {
                throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
            }
            ArrayList<Event> classEvt = (ArrayList<Event>)order.get(priority);
            if (classEvt == null) {
                classEvt = new ArrayList<Event>();
                order.put(priority, classEvt);
            }
            classEvt.add(evt);
        }
        out.write("event \n");
        out.addIndent(1);
        Iterator iCl = order.values().iterator();
        while (iCl.hasNext()) {
            List classEvt = (List)iCl.next();
            if (classEvt.size() == 1) {
                ((Event)classEvt.get(0)).printOTools(out, 4);
            } else {
                out.write("{ ");
                for (int i = 0; i < classEvt.size(); ++i) {
                    if (i > 0) {
                        out.write(" , ");
                    }
                    ((Event)classEvt.get(i)).printOTools(out, 4);
                }
                out.write(" }");
            }
            if (iCl.hasNext()) {
                out.write(" < ");
                continue;
            }
            out.write(" : public;\n");
        }
        out.addIndent(-1);
    }

    public void printMoca(IndentWriter out, int frm) throws IOException {
        Extern extern;
        int i;
        this._cpt = 1;
        if (this._externLst.size() > 0) {
            out.write("\n/* Convertion des parameters en constantes  */\n");
            out.addIndent(1);
            HashSet<String> defSet = new HashSet<String>();
            for (i = this._externLst.size() - 1; i >= 0; --i) {
                extern = this._externLst.get(i);
                extern.printMocaParameter(out, this, defSet);
            }
            out.addIndent(-1);
        }
        if (this._flowLst.size() > 0) {
            out.write("\n/* Variables : Ensemble des flux */\n");
            out.addIndent(1);
            for (int i2 = 0; i2 < this._flowLst.size(); ++i2) {
                Var var = this._flowLst.get(i2);
                var.printMoca(out, frm);
            }
            out.addIndent(-1);
        }
        if (this._stateLst.size() > 0) {
            out.write("\n/* Variables : Ensemble des variables d'etat */\n");
            out.addIndent(1);
            for (int i3 = 0; i3 < this._stateLst.size(); ++i3) {
                Var var = this._stateLst.get(i3);
                var.printMoca(out, frm);
            }
            out.addIndent(-1);
        }
        if (this._transLst.size() > 0) {
            int i4;
            out.write("\n/* Transitions du modele */\n");
            out.addIndent(1);
            for (i4 = 0; i4 < this._transLst.size(); ++i4) {
                this._transLst.get((int)i4)._flag = '\u0000';
            }
            for (i4 = 0; i4 < this._transLst.size(); ++i4) {
                Trans tr = this._transLst.get(i4);
                tr.printMoca(out, this);
            }
            out.addIndent(-1);
        }
        if (this.getAssertCount() > 0) {
            out.write("\n/* Assertion du modele */\n");
            out.addIndent(1);
            for (int i5 = 0; i5 < this.getAssertCount(); ++i5) {
                Expr aff = this.getAssert(i5);
                if (!ExprOp.isType(aff, ExprOp.Type.EQ)) {
                    throw new GenerateException(MsgTrans.getString("EXC_GEN_NODATAFLOW"));
                }
                aff.getArg(0).printMoca(out);
                out.write(" = ");
                aff.getArg(1).printMoca(out);
                out.write(" ;\n");
            }
            out.addIndent(-1);
        }
        out.write("\n/* Initialisation du modele */\n");
        out.addIndent(1);
        for (int i6 = 0; i6 < this._stateLst.size(); ++i6) {
            State var = this._stateLst.get(i6);
            out.write("AI: ");
            out.write("'");
            out.write(var.getName());
            out.write("' = ");
            if (var.getDomain().isSymbolic()) {
                out.write("'e..");
                out.write(this.getModel().getDomainDefine().getEnumStr((int)var.getSimular().getInitValue()));
                out.write("'");
            } else if (var.getDomain().isBoolean()) {
                out.write(var.getSimular().getInitValue() == 0.0 ? "0" : "1");
            } else if (var.getDomain() instanceof FloatDomain) {
                out.write(Double.toString(var.getSimular().getInitValue()));
            } else {
                out.write(Long.toString((long)var.getSimular().getInitValue()));
            }
            out.write(";\n");
        }
        out.addIndent(-1);
        if (this._externLst.size() > 0) {
            out.write("\n/* Convertion des observateurs en Etat statistique */\n");
            out.addIndent(1);
            HashSet<String> defSet = new HashSet<String>();
            for (i = this._externLst.size() - 1; i >= 0; --i) {
                extern = this._externLst.get(i);
                extern.printMocaObserver(out, this, defSet);
            }
            out.addIndent(-1);
        }
    }

    private void printJava_printDelayEvent(Tree son, double delay, IndentWriter out) throws IOException {
        if (son._type == 268) {
            out.write("getEvent(\"");
            out.write(son._sval);
            out.write(((Event)son._son).getName());
            out.write("\").setDelay(");
            if (Double.isInfinite(delay)) {
                out.write("Double.POSITIVE_INFINITY");
            } else {
                out.write(Double.toString(delay));
            }
            out.write(");\n");
        } else if (son._type == 40 && son._sval.length() == 0) {
            Tree cur = (Tree)son._son;
            while (cur != null) {
                this.printJava_printDelayEvent(cur, delay, out);
                cur = cur._next;
            }
        }
    }

    private void printJava_printPriorityEvent(Tree son, int priority, IndentWriter out) throws IOException {
        if (son._type == 268) {
            out.write("getEvent(\"");
            out.write(son._sval);
            out.write(((Event)son._son).getName());
            out.write("\").setPriority(");
            out.write(Integer.toString(priority));
            out.write(");\n");
        } else if (son._type == 40 && son._sval.length() == 0) {
            Tree cur = (Tree)son._son;
            while (cur != null) {
                this.printJava_printPriorityEvent(cur, priority, out);
                cur = cur._next;
            }
        }
    }

    private void printJava_printFlow(IndentWriter out, Flow fl) throws IOException {
        out.addData(fl);
        switch (fl.getOrientation()) {
            case '\u0001': {
                out.write("addFlow(new JFlowIn(\"");
                break;
            }
            case '\u0002': {
                out.write("addFlow(new JFlowOut(\"");
                break;
            }
            case '\u0003': {
                out.write("addFlow(new JVariable(\"");
            }
        }
        out.write(fl.getName());
        out.write("\", ");
        fl.getDomain().printJava(out);
        out.write(", this));\n");
    }

    private void printJava_defineData(IndentWriter out) throws IOException {
        int i;
        int i2;
        if (this.getFlowCount() > 0) {
            int cpt;
            int nbrFlow = 250;
            int cptMethode = 0;
            int idxFlow = 0;
            while (this.getFlowCount() - cptMethode * nbrFlow > nbrFlow) {
                out.write("private void defineFlow");
                out.write(Integer.toString(cptMethode++));
                out.write("() throws JCreateException {\n");
                out.addIndent(1);
                for (cpt = 0; cpt < nbrFlow; ++cpt) {
                    Flow fl = this.getFlow(idxFlow++);
                    this.printJava_printFlow(out, fl);
                }
                out.addIndent(-1);
                out.write("}\n");
            }
            out.write("private void defineFlow() throws JCreateException {\n");
            out.addIndent(1);
            for (cpt = 0; cpt < cptMethode; ++cpt) {
                out.write("defineFlow");
                out.write(Integer.toString(cpt));
                out.write("();\n");
            }
            while (idxFlow < this.getFlowCount()) {
                Flow fl = this.getFlow(idxFlow++);
                this.printJava_printFlow(out, fl);
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        if (this.getStateCount() > 0) {
            out.write("private void defineState() throws JCreateException {\n");
            out.addIndent(1);
            for (i2 = 0; i2 < this.getStateCount(); ++i2) {
                State st = this.getState(i2);
                out.addData(st);
                out.write("addState(new JState(\"");
                out.write(st.getName());
                out.write("\", ");
                st.getDomain().printJava(out);
                out.write(", this));\n");
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        if (this.getEventCount() > 0) {
            out.write("private void defineEvent() throws JCreateException {\n");
            out.addIndent(1);
            for (i2 = 0; i2 < this.getEventCount(); ++i2) {
                Event evt = this.getEvent(i2);
                out.addData(evt);
                out.write("addEvent(new JEvent(\"");
                out.write(evt.getName());
                out.write("\", this));\n");
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        if (this.getSubCount() > 0) {
            out.write("private void defineSub() throws JCreateException {\n");
            out.addIndent(1);
            for (i2 = 0; i2 < this.getSubCount(); ++i2) {
                Sub sub = this.getSub(i2);
                out.addData(sub);
                out.write("addSub(new ");
                out.write(sub.getType().getName());
                out.write("(\"");
                out.write(sub.getName());
                out.write("\", this));\n");
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        if (this.getTransCount() > 0) {
            out.write("private void defineTrans() throws JCreateException {\n");
            out.addIndent(1);
            for (i2 = 0; i2 < this.getTransCount(); ++i2) {
                this.getTrans(i2).printJava(out, this);
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        int cptLink = 0;
        for (i = 0; i < this.getAssertCount(); ++i) {
            Expr expr = this.getAssert(i);
            if (!expr.isLink()) continue;
            ++cptLink;
        }
        if (cptLink > 0) {
            int nbrLink = 250;
            int cptMethode = 0;
            int idxAssert = 0;
            while (cptLink - cptMethode * nbrLink > nbrLink) {
                out.write("private void defineLink");
                out.write(Integer.toString(cptMethode++));
                out.write("() throws JCreateException {\n");
                out.addIndent(1);
                int cpt = 0;
                while (cpt < nbrLink) {
                    Expr expr;
                    if (!(expr = this.getAssert(idxAssert++)).isLink()) continue;
                    expr.printLinkJava(out);
                    ++cpt;
                }
                out.addIndent(-1);
                out.write("}\n");
            }
            out.write("private void defineLink() throws JCreateException {\n");
            out.addIndent(1);
            for (int cpt = 0; cpt < cptMethode; ++cpt) {
                out.write("defineLink");
                out.write(Integer.toString(cpt));
                out.write("();\n");
            }
            while (idxAssert < this.getAssertCount()) {
                Expr expr;
                if (!(expr = this.getAssert(idxAssert++)).isLink()) continue;
                expr.printLinkJava(out);
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        if (this.getExternCount() > 0) {
            out.write("private void defineExtern() throws JCreateException {\n");
            out.addIndent(1);
            for (i = 0; i < this.getExternCount(); ++i) {
                Extern ext = this.getExtern(i);
                Tree tree = ext.getTree();
                if (tree._sval.equals("law")) {
                    double delay = ext.delayOfLaw(this);
                    if (this.getSubCount() > 0 && Double.isNaN(delay)) {
                        delay = Double.POSITIVE_INFINITY;
                    }
                    if (Double.isNaN(delay) || !(delay >= 0.0)) continue;
                    out.addData(ext);
                    this.printJava_printDelayEvent((Tree)tree._son, delay, out);
                    continue;
                }
                if (!tree._sval.equals("priority")) continue;
                int priority = ext.valueOfPriority();
                if (priority < 0) {
                    throw new GenerateException(MsgTrans.getString("EXC_GEN_XPRIORITY"));
                }
                out.addData(ext);
                this.printJava_printPriorityEvent((Tree)tree._son, priority, out);
            }
            out.addIndent(-1);
            out.write("}\n");
        }
        out.write("protected void defineData() throws JCreateException {\n");
        out.addIndent(1);
        if (this.getFlowCount() > 0) {
            out.write("defineFlow();\n");
        }
        if (this.getStateCount() > 0) {
            out.write("defineState();\n");
        }
        if (this.getEventCount() > 0) {
            out.write("defineEvent();\n");
        }
        if (this.getSubCount() > 0) {
            out.write("defineSub();\n");
        }
        if (this.getTransCount() > 0) {
            out.write("defineTrans();\n");
        }
        if (cptLink > 0) {
            out.write("defineLink();\n");
        }
        for (i = 0; i < this.getSyncCount(); ++i) {
            out.write("addSync(\"");
            this.getSync(i).printJava(out);
            out.write("\");\n");
        }
        for (i = 0; i < this.getInitCount(); ++i) {
            Init init = this.getInit(i);
            if (!(init.getVar() instanceof State)) continue;
            init.printJava(out, this);
        }
        if (this.getExternCount() > 0) {
            out.write("defineExtern();\n");
        }
        if (this.getSyncCount() > 0) {
            out.write("createAllSync();\n");
        }
        out.addIndent(-1);
        out.write("}\n\n");
    }

    private void printJava_doAssert(IndentWriter out) throws IOException {
        out.write("public void doAssert() throws StepperViolatedAssertionException {\n");
        out.addIndent(1);
        HashMap<String, Expr> defineCsts = new HashMap<String, Expr>();
        HashMap<String, Expr> defineLinks = new HashMap<String, Expr>();
        TreeSet<String> outputVars = new TreeSet<String>();
        boolean output = false;
        for (int i = 0; i < this.getAssertCount(); ++i) {
            Expr expr = this.getAssert(i);
            String name = expr.getArg(0).toString();
            outputVars.add(name);
            if (!expr.isLink()) {
                output = true;
                continue;
            }
            if (expr.getArg(1).isConstant()) {
                defineCsts.put(name, expr.getArg(1));
                continue;
            }
            defineLinks.put(name, expr.getArg(1));
        }
        if (output) {
            Expr expr;
            int i;
            HashSet<String> defineVars = new HashSet<String>();
            for (i = 0; i < this.getAssertCount(); ++i) {
                expr = this.getAssert(i);
                if (expr.isLink()) continue;
                expr.printDeclarationJava(out, defineVars, outputVars, defineCsts, defineLinks);
            }
            for (i = 0; i < this.getAssertCount(); ++i) {
                expr = this.getAssert(i);
                if (expr.isLink()) continue;
                expr.printAssertJava(out, outputVars, defineCsts);
            }
        }
        out.addIndent(-1);
        out.write("}\n");
    }

    private void printJava_doInitAssert(IndentWriter out) throws IOException {
        out.write("public int doInitAssert() throws StepperViolatedAssertionException {\n");
        out.addIndent(1);
        HashMap<String, Expr> defineCsts = new HashMap<String, Expr>();
        HashMap<String, Expr> defineLinks = new HashMap<String, Expr>();
        TreeSet<String> outputVars = new TreeSet<String>();
        boolean output = false;
        for (int i = 0; i < this.getAssertCount(); ++i) {
            Expr expr = this.getAssert(i);
            String name = expr.getArg(0).toString();
            outputVars.add(name);
            if (!expr.isLink()) {
                output = true;
                continue;
            }
            if (expr.getArg(1).isConstant()) {
                defineCsts.put(name, expr.getArg(1));
                continue;
            }
            defineLinks.put(name, expr.getArg(1));
        }
        if (output) {
            Expr expr;
            int i;
            HashSet<String> defineVars = new HashSet<String>();
            for (i = 0; i < this.getAssertCount(); ++i) {
                expr = this.getAssert(i);
                if (expr.isLink()) continue;
                expr.printDeclarationJava(out, defineVars, outputVars, defineCsts, defineLinks);
            }
            out.write("int result$$$java = 0;\n");
            for (i = 0; i < this.getAssertCount(); ++i) {
                expr = this.getAssert(i);
                if (expr.isLink()) continue;
                out.write("{\n");
                out.addIndent(1);
                out.write("double compute$$$Java = ");
                expr.getArg(1).printNaNJava(out, outputVars, defineCsts);
                out.write(";\n");
                out.write("if (!Double.isNaN(compute$$$Java))\n  ");
                out.write(Expr.toIDJava(expr.getArg(0).toString()));
                out.write(".setValue(compute$$$Java);\n");
                out.write("else result$$$java++;\n");
                out.addIndent(-1);
                out.write("}\n");
            }
            out.write("return result$$$java;\n");
        } else {
            out.write("return 0;\n");
        }
        out.addIndent(-1);
        out.write("}\n");
    }

    public void printJava(IndentWriter out) throws IOException {
        out.write("public class ");
        out.write(this._name);
        out.write(" extends ");
        out.write(this.getSubCount() > 0 ? "JDefEquipment" : "JDefComponent");
        out.write(" {\n\n");
        out.addIndent(1);
        out.write("public ");
        out.write(this._name);
        out.write("(String name)\n  throws JCreateException\n  {super(name);}\n");
        out.write("public ");
        out.write(this._name);
        out.write("(String name, JDefEquipment parent)\n");
        out.write("  throws JCreateException\n  {super(name, parent);}\n\n");
        this.printJava_defineData(out);
        this.printJava_doAssert(out);
        out.write("\n");
        this.printJava_doInitAssert(out);
        out.addIndent(-1);
        out.write("}\n\n");
    }

    public void rename(Model.RenameHelper helper, String name) {
        int i;
        helper.putNode(this, this._name);
        this._name = name;
        ArrayList<Data> lst = this._flowLst;
        this._flowLst = new ArrayList();
        this._flowMap = new HashMap();
        int in = 0;
        int out = 0;
        int loc = 0;
        for (int i2 = 0; i2 < lst.size(); ++i2) {
            Flow data = lst.get(i2);
            Object nname = "?";
            switch (data.getOrientation()) {
                case '\u0001': {
                    nname = "In_" + helper.format(++in);
                    break;
                }
                case '\u0002': {
                    nname = "Out_" + helper.format(++out);
                    break;
                }
                case '\u0003': {
                    nname = "Loc_" + helper.format(++loc);
                }
            }
            helper.putVar(this, data, data.getName());
            helper.appendTrace("\tFlow : " + data.getName() + " -> " + (String)nname + "\n");
            data.setName((String)nname);
            this.addPrivateFlow(data);
        }
        lst = this._stateLst;
        this._stateLst = new ArrayList();
        this._stateMap = new HashMap();
        for (i = 0; i < lst.size(); ++i) {
            State data = (State)lst.get(i);
            String nname = "Stt_" + helper.format(i + 1);
            helper.appendTrace("\tState : " + data.getName() + " -> " + nname + "\n");
            data.setName(nname);
            this.addPrivateState(data);
        }
        lst = this._eventLst;
        this._eventLst = new ArrayList();
        this._eventMap = new HashMap();
        for (i = 0; i < lst.size(); ++i) {
            Event data = (Event)lst.get(i);
            String nname = "Evt_" + helper.format(i + 1);
            helper.appendTrace("\tEvent : " + data.getName() + " -> " + nname + "\n");
            data.setName(nname);
            this.addPrivateEvent(data);
        }
        lst = this._subLst;
        this._subLst = new ArrayList();
        this._subMap = new HashMap();
        for (i = 0; i < lst.size(); ++i) {
            Sub data = (Sub)lst.get(i);
            String nname = "Sub_" + helper.format(i + 1);
            helper.appendTrace("\tSub : " + data.getName() + " -> " + nname + "\n");
            helper.putSub(this, data, data.getName());
            data.setName(nname);
            this.addPrivateSub(data);
        }
        lst = this._assertLst;
        for (i = 0; i < lst.size(); ++i) {
            Expr data = (Expr)lst.get(i);
            data.rename(helper, this);
        }
        lst = this._transLst;
        for (i = 0; i < lst.size(); ++i) {
            Trans data = (Trans)lst.get(i);
            data.rename(helper, this);
        }
        lst = this._syncLst;
        for (i = 0; i < lst.size(); ++i) {
            Sync data = (Sync)lst.get(i);
            data.rename(helper, this);
        }
        lst = this._initLst;
        for (i = 0; i < lst.size(); ++i) {
            Init data = (Init)lst.get(i);
            data.rename(helper, this);
        }
        lst = this._externLst;
        for (i = 0; i < lst.size(); ++i) {
            Extern data = (Extern)lst.get(i);
            data.rename(helper, this);
        }
    }

    @Override
    protected boolean exchangeChild(Expr oldChild, Expr newChild) {
        throw new UnsupportedOperationException("Error Node::exchangeChild(" + oldChild.toString() + ", " + newChild.toString() + ") [" + this.getName() + "]");
    }

    private void addNodeRename(Node sub, String inst) throws TranslateException {
        int i;
        for (i = 0; i < sub.getFlowCount(); ++i) {
            Flow flow = sub.getFlow(i);
            flow.setName(inst + "." + flow.getName());
            this.addPrivateFlow(flow);
        }
        for (i = 0; i < sub.getStateCount(); ++i) {
            State state = sub.getState(i);
            state.setName(inst + "." + state.getName());
            this.addPrivateState(state);
        }
        for (i = 0; i < sub.getEventCount(); ++i) {
            Event evt = sub.getEvent(i);
            evt.setName(inst + "." + evt.getName());
            this.addPrivateEvent(evt);
        }
        for (i = 0; i < sub.getAssertCount(); ++i) {
            this.addPrivateAssert(sub.getAssert(i).moveTo(this, this));
        }
        for (i = 0; i < sub.getTransCount(); ++i) {
            this.addPrivateTrans(sub.getTrans(i).instance(this, null));
        }
        for (i = 0; i < sub.getInitCount(); ++i) {
            this.addPrivateInit(sub.getInit(i).instance(this, null));
        }
        for (i = 0; i < sub.getExternCount(); ++i) {
            Extern extern = sub.getExtern(i);
            extern.instanceLocal(this, inst);
            this._externLst.add(extern);
        }
    }

    private void addNodeInstance(Node sub, String inst) throws TranslateException {
        Expr expr;
        int i;
        assert (this.getSubCount() == 0) : "Instance d'un bloc hierarchique !!!";
        for (i = 0; i < sub.getFlowCount(); ++i) {
            this.addPrivateFlow((Flow)sub.getFlow(i).instance(this, inst));
        }
        for (i = 0; i < sub.getStateCount(); ++i) {
            this.addPrivateState((State)sub.getState(i).instance(this, inst));
        }
        for (i = 0; i < sub.getEventCount(); ++i) {
            this.addPrivateEvent((Event)sub.getEvent(i).instance(this, inst));
        }
        this.setFlagPropage('\u0000');
        for (i = 0; i < sub.getFlowCount(); ++i) {
            Flow subVar = sub.getFlow(i);
            if (!subVar.isAlias()) continue;
            Var subRef = subVar.getSimular().getVar();
            Var var = this.getVar((String)(inst.length() == 0 ? "" : inst + ".") + subVar.getName());
            Var ref = this.getVar((String)(inst.length() == 0 ? "" : inst + ".") + subRef.getName());
            Simular simRef = ref.getSimular();
            if (simRef == null) {
                simRef = new Simular(this, ref);
                ref.setSimular(simRef);
            }
            simRef.addAlias(this, var);
        }
        for (i = 0; i < sub.getAssertCount(); ++i) {
            expr = sub.getAssert(i);
            if (!expr.isAliasAssert()) continue;
            Var leftVar = ((ExprVar)expr.getArg(0)).getInstanceVar(this, inst);
            Var rightVar = ((ExprVar)expr.getArg(1)).getInstanceVar(this, inst);
            Simular simVar = rightVar.getSimular();
            if (simVar == null) {
                simVar = new Simular(this, rightVar);
                rightVar.setSimular(simVar);
            }
            simVar.addAlias(this, leftVar);
        }
        for (i = 0; i < sub.getAssertCount(); ++i) {
            expr = sub.getAssert(i);
            if (expr.isAliasAssert()) continue;
            Expr affect = (Expr)expr.instance(this, inst, this);
            this.addPrivateAssert(affect);
        }
        for (i = 0; i < sub.getTransCount(); ++i) {
            this.addPrivateTrans(sub.getTrans(i).instance(this, inst));
        }
        for (i = 0; i < sub.getInitCount(); ++i) {
            sub.getInit(i).defineInitValue(this, inst);
        }
        for (i = 0; i < sub.getExternCount(); ++i) {
            this._externLst.add((Extern)sub.getExtern(i).instance(this, inst));
        }
    }

    private Node flatness(Model parent, Map<Node, DataFlatness> flatNodes) throws TranslateException {
        if (this.getSubCount() > 0) {
            DataFlatness data = flatNodes.get(this);
            if (data._fnode != null) {
                return data._fnode;
            }
            data._fnode = new Node(parent, this.getName(), StoreExpr.Type.EXPR);
            data._fnode.instance(this);
            for (int i = 0; i < this.getSubCount(); ++i) {
                Sub sub = this.getSub(i);
                Node subNode = sub.getType();
                if (subNode.getSubCount() > 0) {
                    DataFlatness subData = flatNodes.get(subNode);
                    if (subData._cur == -1) {
                        subNode.flatness(parent, flatNodes);
                        subData._cur = 0;
                    }
                    ++subData._cur;
                    if (subData._cur == subData._nbr) {
                        data._fnode.addNodeRename(subData._fnode, sub.getName());
                        continue;
                    }
                    data._fnode.addNodeInstance(subData._fnode, sub.getName());
                    continue;
                }
                data._fnode.addNodeInstance(subNode, sub.getName());
            }
            data._fnode.addNodeInstance(this, "");
            ArrayList<Sync> syncs = new ArrayList<Sync>();
            for (int i = 0; i < this._syncLst.size(); ++i) {
                syncs.add((Sync)this._syncLst.get(i).instance(data._fnode, ""));
            }
            data._fnode.flatnessSync(syncs);
            data._fnode.garbageCollect();
            return data._fnode;
        }
        return this;
    }

    private void addDeclaredNodeInstance(Node sub, String inst) throws TranslateException {
        int i;
        assert (this.getSubCount() == 0) : "Instance d'un bloc hierarchique !!!";
        for (i = 0; i < sub.getFlowCount(); ++i) {
            this.addPrivateFlow((Flow)sub.getFlow(i).instance(this, inst));
        }
        for (i = 0; i < sub.getStateCount(); ++i) {
            this.addPrivateState((State)sub.getState(i).instance(this, inst));
        }
        for (i = 0; i < sub.getEventCount(); ++i) {
            this.addPrivateEvent((Event)sub.getEvent(i).instance(this, inst));
        }
        this.setFlagPropage('\u0000');
        for (i = 0; i < sub.getFlowCount(); ++i) {
            Flow subVar = sub.getFlow(i);
            if (!subVar.isAlias()) continue;
            Var subRef = subVar.getSimular().getVar();
            Var var = this.getVar((String)(inst.length() == 0 ? "" : inst + ".") + subVar.getName());
            Var ref = this.getVar((String)(inst.length() == 0 ? "" : inst + ".") + subRef.getName());
            Simular simRef = ref.getSimular();
            if (simRef == null) {
                simRef = new Simular(this, ref);
                ref.setSimular(simRef);
            }
            simRef.addAlias(this, var);
        }
        for (i = 0; i < sub.getAssertCount(); ++i) {
            Expr expr = sub.getAssert(i);
            if (!expr.isAliasAssert()) continue;
            Var leftVar = ((ExprVar)expr.getArg(0)).getInstanceVar(this, inst);
            Var rightVar = ((ExprVar)expr.getArg(1)).getInstanceVar(this, inst);
            Simular simVar = rightVar.getSimular();
            if (simVar == null) {
                simVar = new Simular(this, rightVar);
                rightVar.setSimular(simVar);
            }
            simVar.addAlias(this, leftVar);
        }
    }

    private void addBehaviorNodeInstance(Node sub, String inst) throws TranslateException {
        int i;
        assert (this.getSubCount() == 0) : "Instance d'un bloc hierarchique !!!";
        for (i = 0; i < sub.getAssertCount(); ++i) {
            Expr expr = sub.getAssert(i);
            if (expr.isAliasAssert()) continue;
            Expr affect = (Expr)expr.instance(this, inst, this);
            this.addPrivateAssert(affect);
        }
        for (i = 0; i < sub.getTransCount(); ++i) {
            this.addPrivateTrans(sub.getTrans(i).instance(this, inst));
        }
        for (i = 0; i < sub.getInitCount(); ++i) {
            sub.getInit(i).defineInitValue(this, inst);
        }
        for (i = 0; i < sub.getExternCount(); ++i) {
            this._externLst.add((Extern)sub.getExtern(i).instance(this, inst));
        }
    }

    private Node flatnessV2(Model parent, Map<Node, DataFlatness> flatNodes) throws TranslateException {
        if (this.getSubCount() > 0) {
            DataFlatness subData;
            Node subNode;
            Sub sub;
            int i;
            DataFlatness data = flatNodes.get(this);
            if (data._fnode != null) {
                return data._fnode;
            }
            data._fnode = new Node(parent, this.getName(), StoreExpr.Type.EXPR);
            data._fnode.instance(this);
            Sub greaterSubEquip = null;
            int greaterSubEquipSize = 0;
            for (i = 0; i < this.getSubCount(); ++i) {
                int subEquipSize;
                sub = this.getSub(i);
                subNode = sub.getType();
                if (subNode.getSubCount() <= 0) continue;
                subData = flatNodes.get(subNode);
                if (subData._cur == -1) {
                    subNode.flatnessV2(parent, flatNodes);
                    subData._cur = 0;
                }
                if (subData._cur + 1 != subData._nbr || (subEquipSize = subData._fnode.getStoreExpr().size()) <= greaterSubEquipSize) continue;
                greaterSubEquipSize = subEquipSize;
                greaterSubEquip = sub;
            }
            if (greaterSubEquip != null) {
                MsgTrans.LOG.finest(new StringBuffer(256).append("Greater sub equipement for node ").append(this.getName()).append(" is ").append(greaterSubEquip.getType().getName()).append("(").append(greaterSubEquip.getName()).append(")").toString());
                DataFlatness subData2 = flatNodes.get(greaterSubEquip.getType());
                ++subData2._cur;
                assert (subData2._cur == subData2._nbr);
                data._fnode.addNodeRename(subData2._fnode, greaterSubEquip.getName());
            }
            for (i = 0; i < this.getSubCount(); ++i) {
                sub = this.getSub(i);
                if (sub == greaterSubEquip) continue;
                subNode = sub.getType();
                if (subNode.getSubCount() > 0) {
                    subData = flatNodes.get(subNode);
                    data._fnode.addDeclaredNodeInstance(subData._fnode, sub.getName());
                    continue;
                }
                data._fnode.addDeclaredNodeInstance(subNode, sub.getName());
            }
            data._fnode.addDeclaredNodeInstance(this, "");
            for (i = 0; i < this.getSubCount(); ++i) {
                sub = this.getSub(i);
                if (sub == greaterSubEquip) continue;
                subNode = sub.getType();
                if (subNode.getSubCount() > 0) {
                    subData = flatNodes.get(subNode);
                    data._fnode.addBehaviorNodeInstance(subData._fnode, sub.getName());
                    ++subData._cur;
                    if (subData._cur != subData._nbr) continue;
                    subData._fnode = null;
                    continue;
                }
                data._fnode.addBehaviorNodeInstance(subNode, sub.getName());
            }
            data._fnode.addBehaviorNodeInstance(this, "");
            ArrayList<Sync> syncs = new ArrayList<Sync>();
            for (int i2 = 0; i2 < this._syncLst.size(); ++i2) {
                syncs.add((Sync)this._syncLst.get(i2).instance(data._fnode, ""));
            }
            data._fnode.flatnessSync(syncs);
            data._fnode.garbageCollect();
            data._fnode.debugVerifyExprs();
            return data._fnode;
        }
        return this;
    }

    private void flatnessPrepare(Model parent, Map<Node, DataFlatness> map) {
        if (this.getSubCount() == 0) {
            return;
        }
        DataFlatness data = map.get(this);
        if (data == null) {
            data = new DataFlatness(this);
            map.put(this, data);
        }
        ++data._nbr;
        for (int i = 0; i < this.getSubCount(); ++i) {
            this.getSub(i).getType().flatnessPrepare(parent, map);
        }
    }

    public Node flatness(Model parent) throws TranslateException {
        IdentityHashMap<Node, DataFlatness> map = new IdentityHashMap<Node, DataFlatness>();
        this.flatnessPrepare(parent, map);
        Node result = this.flatnessV2(parent, map);
        result._bFlatness = true;
        for (int i = 0; i < result.getAssertCount(); ++i) {
            Expr define;
            Expr exprLeft;
            Expr expr = result.getAssert(i);
            if (!ExprOp.isType(expr, ExprOp.Type.EQ) || !((exprLeft = expr.getArg(0)) instanceof ExprVar)) continue;
            Var varLeft = ((ExprVar)exprLeft).getVar();
            Simular simVar = varLeft.getSimular();
            if (simVar == null) {
                simVar = new Simular(this, varLeft);
                varLeft.setSimular(simVar);
            }
            if ((define = expr.getArg(1)).isConstant() && !varLeft.getDomain().verifyValueOf(define)) {
                throw new TranslateException("EXC_EXPR_AFFECT_SYMBOL", varLeft.getName(), varLeft.getDomain().toString(), define.toString());
            }
            simVar.setDefine(define);
        }
        int nbrExtern = result.getExternCount();
        for (int i = 0; i < nbrExtern; ++i) {
            String name;
            Extern xTern = result.getExtern(i);
            if (!xTern.getName().equals("attribute")) continue;
            ArrayList<Event> evts = new ArrayList<Event>();
            int nbrEvt = Extern.verifyOnlyEvent(xTern.getVar(), evts, false);
            if (nbrEvt <= 0 || (name = xTern.getVar()._sval).length() == 0) continue;
            ANumber value = new ABool(true);
            Tree val = xTern.getVal();
            if (val != null) {
                if (val._type == 258) {
                    Expr eval = (Expr)val._son;
                    if (!eval.isConstant()) continue;
                    switch (eval.getScale()) {
                        case Boolean: {
                            value = new ABool(eval.getBool());
                            break;
                        }
                        case Integer: {
                            value = new AInteger(eval.getInt());
                            break;
                        }
                        case Float: {
                            value = new AFloat(eval.getDouble());
                            break;
                        }
                        case Symbolic: {
                            value = new AString(eval.getString());
                        }
                    }
                } else {
                    if (val._type != 303) continue;
                    String strValue = val._sval;
                    if (strValue.length() > 1 && strValue.startsWith("\"") && strValue.endsWith("\"")) {
                        strValue = strValue.substring(1, strValue.length() - 1);
                    }
                    value = new AString(strValue);
                }
            }
            for (Event evt : evts) {
                evt.addAttribute(name, value);
            }
        }
        return result;
    }

    private void flatnessSync(List<Sync> syncLst) throws TranslateException {
        Sync sync;
        int j;
        int i;
        Sync sync2;
        int j2;
        for (j2 = 0; j2 < syncLst.size(); ++j2) {
            sync2 = syncLst.get(j2);
            if (sync2.getSize() == 1) continue;
            Data instantaneous = null;
            for (int i2 = 0; i2 < sync2.getSize(); ++i2) {
                Event evt = sync2.getEventAt(i2);
                Tree tEvt = new Tree(268, 0L, 0.0, "", evt, null);
                Extern xLaw = this.findExtern("law", tEvt);
                if (xLaw == null) continue;
                if (xLaw.delayOfLaw(this) == 0.0) {
                    instantaneous = xLaw.getVal();
                    continue;
                }
                if (i2 == 0) break;
                Tree val = xLaw.getVal();
                if (val != null) {
                    val = (Tree)xLaw.getVal().clone();
                }
                Extern nLaw = new Extern("law", new Tree(268, 0L, 0.0, "", sync2.getSync(), null), val);
                nLaw.setPosition(evt, "Create Sync law since event '" + evt.getName() + "'");
                this._externLst.add(nLaw);
                instantaneous = null;
                break;
            }
            if (instantaneous == null) continue;
            Extern nLaw = new Extern("law", new Tree(268, 0L, 0.0, "", sync2.getSync(), null), (Tree)instantaneous.clone());
            nLaw.setPosition(sync2, "Create Sync instantaneous law");
            this._externLst.add(nLaw);
        }
        for (i = this.getEventCount() - 1; i >= 0; --i) {
            Event evt = this.getEvent(i);
            boolean remove = false;
            for (j = 0; j < syncLst.size(); ++j) {
                sync = syncLst.get(j);
                if (sync.getSize() == 1 && sync.getSync() == evt) {
                    remove = false;
                    break;
                }
                if (!sync.hasEvent(evt)) continue;
                remove = true;
            }
            if (!remove) continue;
            this._eventLst.remove(i);
            this._eventMap.remove(evt.getName());
            this.purgeEvent(evt);
        }
        for (i = this.getTransCount() - 1; i >= 0; --i) {
            Trans tr = this.getTrans(i);
            boolean remove = false;
            for (j = 0; j < syncLst.size(); ++j) {
                sync = syncLst.get(j);
                if (!sync.addTrans(tr)) continue;
                remove = true;
            }
            if (!remove) continue;
            this._transLst.remove(i);
        }
        for (j2 = 0; j2 < syncLst.size(); ++j2) {
            sync2 = syncLst.get(j2);
            sync2.flatness(this);
        }
    }

    public void sortVariable() {
        Comparator<Var> compareName = new Comparator<Var>(){

            @Override
            public int compare(Var o1, Var o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        Collections.sort(this._flowLst, compareName);
        Collections.sort(this._stateLst, compareName);
    }

    @Override
    public void setFlagPropage(char value) {
        int i;
        for (i = this.getFlowCount() - 1; i >= 0; --i) {
            this.getFlow((int)i)._flag = value;
        }
        for (i = this.getStateCount() - 1; i >= 0; --i) {
            this.getState((int)i)._flag = value;
        }
        for (i = this.getEventCount() - 1; i >= 0; --i) {
            this.getEvent((int)i)._flag = value;
        }
        for (i = this.getSubCount() - 1; i >= 0; --i) {
            this.getSub((int)i)._flag = value;
        }
        for (i = this.getInitCount() - 1; i >= 0; --i) {
            this.getInit(i).setFlagPropage(value);
        }
        for (i = this.getTransCount() - 1; i >= 0; --i) {
            this.getTrans(i).setFlagPropage(value);
        }
        for (i = this.getAssertCount() - 1; i >= 0; --i) {
            this.getAssert(i).setFlagPropage(value);
        }
        for (i = this.getExternCount() - 1; i >= 0; --i) {
            this.getExtern(i).setFlagPropage(value);
        }
        this._storeExpr.setFlag(value);
    }

    public void verifyWarning(VerifyManager mng, int filter) {
        int i;
        if (mng.withWarning("Loop") && filter != 1) {
            this.verifyLoop(mng);
        }
        if (mng.withWarning("Guard") && filter != 2) {
            for (i = 0; i < this.getTransCount(); ++i) {
                Trans tr = this.getTrans(i);
                Expr guard = tr.getGuard();
                guard.verifyGuard(mng, tr);
            }
        }
        if (mng.withWarning("LocalSimul") && filter != 2 && this.getSubCount() == 0) {
            LocalSimul df = new LocalSimul(this, this._transLst);
            df.verifyWarning(mng);
        }
        if (mng.withWarning("Sync") && filter != 2) {
            for (i = 0; i < this.getSyncCount(); ++i) {
                Sync sync = this.getSync(i);
                switch (sync.getRealType()) {
                    case '\u0002': {
                        if (sync.getBrother() != null && sync.getBrother() != sync || !mng.withWarning("SyncSync")) break;
                        mng.addError("SyncSync", sync, "WRN_SYNC_SYNC", sync.getSync().getName());
                        break;
                    }
                    case '\u0004': {
                        if (!mng.withWarning("SyncDiff")) break;
                        mng.addError("SyncDiff", sync, "WRN_SYNC_DIFF", sync.getSync().getName());
                        break;
                    }
                    case '\u0005': 
                    case '\u0006': {
                        if (!mng.withWarning("SyncCCF")) break;
                        mng.addError("SyncCCF", sync, "WRN_SYNC_CCF", sync.getSync().getName());
                    }
                }
                sync.verifyWarning(mng);
            }
        }
        if (mng.withWarning("TransConflict") && filter != 2) {
            for (i = 0; i < this.getEventCount(); ++i) {
                Event evt = this.getEvent(i);
                HashSet<Expr> guards = new HashSet<Expr>();
                for (int j = 0; j < this.getTransCount(); ++j) {
                    Trans tr = this.getTrans(j);
                    if (evt != tr.getEvent()) continue;
                    if (guards.contains(tr.getGuard())) {
                        mng.addError("TransConflict", tr, "WRN_TRANS_CONFLICT", evt.getName());
                        continue;
                    }
                    guards.add(tr.getGuard());
                }
            }
        }
        if (mng.withWarning("Expr") && filter != 2) {
            int i2;
            boolean wInt = mng.withWarning("ExprInt");
            boolean wFlt = mng.withWarning("ExprFloat");
            if (wInt || wFlt) {
                int i3;
                for (i3 = 0; i3 < this.getFlowCount(); ++i3) {
                    Flow var = this.getFlow(i3);
                    if (wInt && var.getDomain() == this._parent.getDomainDefine().getInt()) {
                        mng.addError("ExprInt", var, "WRN_EXPR_INT", var.getName());
                    }
                    if (!wFlt || var.getDomain() != this._parent.getDomainDefine().getFloat()) continue;
                    mng.addError("ExprFloat", var, "WRN_EXPR_FLOAT", var.getName());
                }
                for (i3 = 0; i3 < this.getStateCount(); ++i3) {
                    State var = this.getState(i3);
                    if (wInt && var.getDomain() == this._parent.getDomainDefine().getInt()) {
                        mng.addError("ExprInt", var, "WRN_EXPR_INT", var.getName());
                    }
                    if (!wFlt || var.getDomain() != this._parent.getDomainDefine().getFloat()) continue;
                    mng.addError("ExprFloat", var, "WRN_EXPR_FLOAT", var.getName());
                }
            }
            for (i2 = 0; i2 < this.getTransCount(); ++i2) {
                Trans tr = this.getTrans(i2);
                tr.verifyExpr(mng);
            }
            for (i2 = 0; i2 < this.getAssertCount(); ++i2) {
                Expr expr = this.getAssert(i2);
                expr.verifyExpr(mng);
            }
        }
        if (mng.withWarning("Event") && filter != 1) {
            Tree tEvt = new Tree(268, 0L, 0.0, "", null, null);
            for (int i4 = 0; i4 < this.getEventCount(); ++i4) {
                Event evt = this.getEvent(i4);
                tEvt._son = evt;
                Extern xLaw = this.findExtern("law", tEvt);
                if (xLaw == null) {
                    if (!mng.withWarning("EventLaw")) continue;
                    mng.addError("EventLaw", evt, "WRN_EVENT_NO_LAW", evt.getName());
                    continue;
                }
                double delay = xLaw.delayOfLaw(this);
                if (delay == 0.0) {
                    if (!mng.withWarning("EventInstantaneous")) continue;
                    mng.addError("EventInstantaneous", xLaw, "WRN_EVENT_DIRAC_0", evt.getName());
                    continue;
                }
                if (Double.isNaN(delay) || !mng.withWarning("EventTemporised")) continue;
                mng.addError("EventTemporised", xLaw, "WRN_EVENT_DIRAC_X", evt.getName());
            }
        }
        if (mng.withWarning("Extern") && filter != 1) {
            for (int i5 = 0; i5 < this._externLst.size(); ++i5) {
                Extern extern = this._externLst.get(i5);
                extern.verifyWarning(mng, this);
            }
        }
        if (mng.withWarning("GenerateJava1") && filter == 1) {
            this.verifyJavaCode(mng);
        }
    }

    private void verifyLoop(VerifyManager mng) {
        int i;
        this.setFlagPropage('I');
        HashMap<Var, Expr> affects = new HashMap<Var, Expr>();
        for (int i2 = 0; i2 < this.getAssertCount(); ++i2) {
            ExprVar var;
            Expr expr = this.getAssert(i2);
            if (!ExprOp.isType(expr, ExprOp.Type.EQ)) {
                mng.addError("Loop", expr, "WRN_LOOP_NDFW", expr.toLL());
                return;
            }
            if (expr.getArg(0) instanceof ExprVar && (var = (ExprVar)expr.getArg(0)).getVar() instanceof Flow) {
                affects.put(var.getVar(), expr.getArg(1));
                continue;
            }
            mng.addError("Loop", expr, "WRN_LOOP_NDFW", expr.toLL());
        }
        LoopManager loopMng = new LoopManager();
        for (i = 0; i < this.getAssertCount(); ++i) {
            Expr expr = this.getAssert(i);
            if (!(expr.getArg(0) instanceof ExprVar)) continue;
            ExprVar var = (ExprVar)expr.getArg(0);
            var.verifyLoop(loopMng, expr.getArg(1), affects);
        }
        if (loopMng.getNbrLoop() > 0) {
            for (i = 0; i < loopMng.getNbrLoop(); ++i) {
                mng.addError("Loop", loopMng.getLoop(i).get(0), "WRN_LOOP_DISPLAY", loopMng.getMsg(i));
            }
        }
    }

    private boolean verifyJavaCode(VerifyManager mng) {
        if (this.getSubCount() > 0) {
            return true;
        }
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            return false;
        }
        StringWriter writer = new StringWriter(65535);
        String name = this.getName() + "__" + __cptGeneratedJava++;
        try {
            IndentWriter out = new IndentWriter(writer);
            Model.printJavaImport(out);
            out.write("\n");
            out.write("public abstract class ");
            out.write(name);
            out.write(" extends JDefArchitecture {\n");
            out.addIndent(1);
            out.write("\n");
            this.printJava(out);
            out.write("public ");
            out.write(name);
            out.write("() {\n");
            out.addIndent(1);
            out.write("super();\n");
            out.addIndent(-1);
            out.write("}\n");
            out.addIndent(-1);
            out.write("}\n\n");
            out.close(false);
        }
        catch (IOException e) {
            mng.addError("GenerateJava1", this, "WRN_GENERATE_JAVA1_INTERNAL", this.getName(), e.getMessage());
            return false;
        }
        try {
            DiagnosticArray diags = new DiagnosticArray();
            JavaFileObject javaFile = RAMFileManager.makeSource(name, writer.toString());
            RAMFileManager mfm = new RAMFileManager(compiler.getStandardFileManager(diags, null, null));
            JavaCompiler.CompilationTask task = compiler.getTask(null, mfm, diags, null, null, Arrays.asList(javaFile));
            if (!task.call().booleanValue()) {
                boolean tooLargeCode = false;
                for (int i = 0; i < diags.getNbrDiagnostic(); ++i) {
                    Diagnostic<? extends JavaFileObject> diag = diags.getDiagnostic(i);
                    if (diag.getKind() != Diagnostic.Kind.ERROR) continue;
                    String mess = diag.getMessage(Locale.ENGLISH);
                    if (mess.contains("code too large")) {
                        if (tooLargeCode) continue;
                        mng.addError("GenerateJava1", this, "WRN_GENERATE_JAVA1", this.getName());
                        tooLargeCode = true;
                        continue;
                    }
                    int pos = mess.indexOf(58);
                    if (pos != -1) {
                        mess = mess.substring(pos + 1);
                    }
                    mng.addError("GenerateJava1", this, "WRN_GENERATE_JAVA1_OTHER", this.getName(), mess);
                }
                return false;
            }
        }
        catch (Exception e) {
            mng.addError("GenerateJava1", this, "WRN_GENERATE_JAVA1_INTERNAL", this.getName(), e.getMessage());
            return false;
        }
        return true;
    }

    public boolean withInstantaneousEvent() {
        Tree tEvt = new Tree(268, 0L, 0.0, "", null, null);
        for (int i = 0; i < this.getEventCount(); ++i) {
            Event evt = this.getEvent(i);
            tEvt._son = evt;
            Extern xLaw = this.findExtern("law", tEvt);
            if (xLaw == null || xLaw.delayOfLaw(this) != 0.0) continue;
            return true;
        }
        return false;
    }

    public Map<String, Integer> statistics(Map<Node, Map<String, Integer>> nodes) {
        Map<String, Integer> result = nodes.get(this);
        if (result == null) {
            int i;
            result = new HashMap<String, Integer>();
            if (this.getSubCount() > 0) {
                int inst = 0;
                int instEquip = 1;
                for (int i2 = 0; i2 < this.getSubCount(); ++i2) {
                    Sub sub = this.getSub(i2);
                    Map<String, Integer> child = sub.getType().statistics(nodes);
                    if (child.get("equipment") > 0) {
                        inst += child.get("sub").intValue();
                        instEquip += child.get("sub.equipment").intValue();
                        continue;
                    }
                    ++inst;
                }
                result.put("equipment", 1);
                result.put("sub", inst);
                result.put("sub.equipment", instEquip);
            } else {
                result.put("equipment", 0);
            }
            result.put("flow", this.getFlowCount());
            int alias = 0;
            for (i = this.getFlowCount() - 1; i >= 0; --i) {
                if (!this.getFlow(i).isAlias()) continue;
                ++alias;
            }
            result.put("flow.alias", alias);
            result.put("state", this.getStateCount());
            result.put("event", this.getEventCount());
            result.put("trans", this.getTransCount());
            result.put("assert", this.getAssertCount());
            int equalAssert = 0;
            for (i = this.getAssertCount() - 1; i >= 0; --i) {
                if (!this.getAssert(i).isAliasAssert()) continue;
                ++equalAssert;
            }
            result.put("assert.alias", equalAssert);
            result.put("extern", this.getExternCount());
            result.put("expression", this.getStoreExpr().size());
            nodes.put(this, result);
        }
        return result;
    }

    public void groupsDependConstruct() {
        if (this._groups != null) {
            return;
        }
        if (this.getSubCount() > 0) {
            assert (false);
            return;
        }
        this._groups = new LinkedHashMap<Integer, GroupDepend>();
        int groupID = 1;
        this.setFlagPropage('\u0000');
        int nbrTrans = this._transLst.size();
        for (int i = 0; i < nbrTrans; ++i) {
            Trans tr = this._transLst.get(i);
            GroupDepend group = new GroupDepend(groupID);
            this._groups.put(groupID++, group);
            group.recupFrom(tr, this._groups);
        }
    }

    public void groupsDependClear() {
        this._groups = null;
    }

    public Map<Integer, GroupDepend> groupsDependGet() {
        if (this._groups == null) {
            return null;
        }
        return Collections.unmodifiableMap(this._groups);
    }

    public void groupsDependPrint(Writer writer) throws IOException {
        if (this._groups == null) {
            return;
        }
        for (GroupDepend grp : this.groupsDependGet().values()) {
            writer.append(grp.toString());
            writer.append("\n");
        }
        writer.flush();
    }

    public Collection<Event> groupsDependVariables(Collection<Var> vars) {
        return GroupDepend.dependVariables(this, vars);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._name);
        out.writeObject(this._storeExpr);
        out.writeInt(this._flowLst.size());
        for (Var var : this._flowLst) {
            out.writeObject(var);
        }
        out.writeInt(this._stateLst.size());
        for (Var var : this._stateLst) {
            out.writeObject(var);
        }
        out.writeInt(this._eventLst.size());
        for (Event event : this._eventLst) {
            out.writeObject(event);
        }
        out.writeInt(this._transLst.size());
        for (Trans trans : this._transLst) {
            out.writeObject(trans);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this._name = (String)in.readObject();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            this._flowLst.add((Flow)in.readObject());
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this._stateLst.add((State)in.readObject());
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this._eventLst.add((Event)in.readObject());
        }
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this._transLst.add((Trans)in.readObject());
        }
        this._storeExpr = (StoreExpr)in.readObject();
    }

    class DataFlatness {
        Node _node;
        Node _fnode;
        int _nbr;
        int _cur;

        DataFlatness(Node node) {
            this._node = node;
            this._fnode = null;
            this._nbr = 0;
            this._cur = -1;
        }
    }
}

