/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.model;

import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Simular
implements Externalizable {
    Node _owner;
    Var _var;
    ExprVar _exprVar;
    Set<Var> _alias = new LinkedHashSet<Var>();
    double _value = Double.NaN;
    double _initValue = Double.NaN;
    Expr _define = null;
    char _flag = '\u0000';
    int _index = -1;
    Expr[] _parentsExpr;
    List<Simular> _parentsVar;
    Collection<Simular> _childrenVar;

    public Simular() {
    }

    Simular(Node owner, Var var) {
        this();
        this._owner = owner;
        this._var = var;
        this._exprVar = (ExprVar)owner.addUniqueExpr(new ExprVar(var));
    }

    Simular addAlias(Node owner, Var var) {
        if (var.getSimular() != null) {
            ExprVar newChild = this.getExprVar();
            ExprVar oldChild = var.getSimular().getExprVar();
            Iterator<ExprParent> iter = oldChild.getParents();
            while (iter.hasNext()) {
                iter.next().exchangeChild(owner, oldChild, newChild);
            }
            for (Var alias : var.getSimular()._alias) {
                this._alias.add(alias);
                alias.setSimular(this);
            }
        }
        this._alias.add(var);
        var.setSimular(this);
        return this;
    }

    public final void setIndex(int index) {
        this._index = index;
    }

    public final int getIndex() {
        return this._index;
    }

    public final void setParentsExpr(Expr[] parentsExpr) {
        this._parentsExpr = parentsExpr;
    }

    public final Expr[] getParentsExpr() {
        return this._parentsExpr;
    }

    public final void setOrderedParents(List<Simular> parents) {
        this._parentsVar = parents;
    }

    public final List<Simular> getOrderedParents() {
        return this._parentsVar;
    }

    public void addChildVar(Simular simVar) {
        if (this._childrenVar == null) {
            this._childrenVar = new LinkedHashSet<Simular>();
        }
        if (!this._childrenVar.contains(simVar)) {
            this._childrenVar.add(simVar);
        }
    }

    public final Collection<? extends Simular> getChildrenVar() {
        return this._childrenVar;
    }

    public final void setValue(double value) {
        this._value = value;
        this._exprVar.setDouble(value);
    }

    public final double getValue() {
        return this._value;
    }

    public void setInitValue(double initValue) {
        this._initValue = initValue;
    }

    public final double getInitValue() {
        return this._initValue;
    }

    public final Var getVar() {
        return this._var;
    }

    public final Expr getDefine() {
        return this._define;
    }

    public void setDefine(Expr define) {
        if (define == null) {
            throw new NullPointerException();
        }
        if (this._define != null) {
            throw new UnsupportedOperationException();
        }
        this._define = define;
    }

    public final Domain getDomain() {
        return this._var.getDomain();
    }

    public final String getName() {
        return this._var.getName();
    }

    public final ExprVar getExprVar() {
        return this._exprVar;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Simular)) {
            return false;
        }
        return this.getName().equals(((Simular)obj).getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getName());
        if (this._define != null) {
            sb.append(" [= ").append(this._define.toString()).append("]");
        }
        if (this._alias.size() > 0) {
            sb.append(" { ");
            for (Var var : this._alias) {
                sb.append(var.getName()).append(" ");
            }
            sb.append("}");
        }
        return sb.toString();
    }

    public Collection<Var> getListAlias() {
        return this._alias;
    }

    public final void setFlag(char flag) {
        this._flag = flag;
    }

    public final char getFlag() {
        return this._flag;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._var);
        out.writeObject(this._exprVar);
        out.writeInt(this._alias.size());
        for (Var var : this._alias) {
            out.writeObject(var);
        }
        out.writeDouble(this._value);
        out.writeDouble(this._initValue);
    }

    public void writeAdditionalExternal(ObjectOutput out) throws IOException {
        if (this._define != null) {
            out.writeBoolean(true);
            out.writeObject(this._define);
        } else {
            out.writeBoolean(false);
        }
        int size = this._parentsExpr.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this._parentsExpr[i]);
        }
        if (this._parentsVar != null) {
            out.writeInt(this._parentsVar.size());
            for (Simular simVar : this._parentsVar) {
                out.writeObject(simVar);
            }
        } else {
            out.writeInt(-1);
        }
        if (this._childrenVar != null) {
            out.writeInt(this._childrenVar.size());
            for (Simular simVar : this._childrenVar) {
                out.writeObject(simVar);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._var = (Var)in.readObject();
        this._exprVar = (ExprVar)in.readObject();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this._alias.add((Var)in.readObject());
        }
        this._value = in.readDouble();
        this._initValue = in.readDouble();
    }

    public void readAdditionalExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        if (in.readBoolean()) {
            this._define = (Expr)in.readObject();
        }
        int size = in.readInt();
        this._parentsExpr = new Expr[size];
        for (i = 0; i < size; ++i) {
            this._parentsExpr[i] = (Expr)in.readObject();
        }
        size = in.readInt();
        if (size >= 0) {
            this._parentsVar = new ArrayList<Simular>(size);
            for (i = 0; i < size; ++i) {
                this._parentsVar.add((Simular)in.readObject());
            }
        }
        if ((size = in.readInt()) >= 0) {
            this._childrenVar = new IdentityHashSet<Simular>();
            for (i = 0; i < size; ++i) {
                this._childrenVar.add((Simular)in.readObject());
            }
        }
    }

    public void dispose() {
        this._parentsVar = null;
        this._childrenVar = null;
        this._parentsExpr = null;
    }
}

