/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.parser;

import com.dassault.cecilia.lib.mbsa.translator.parser.OcasLexer;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class OcasTranslateAbstract {
    protected int _firstTok = 0;
    protected OcasLexer _lexer = null;
    private StringBuilder _code;
    private StringBuilder _errors;
    int _currentCode = 1;
    Map<Integer, String> _mapIdToName = new LinkedHashMap<Integer, String>();
    List<String> _stackName = new ArrayList<String>();
    List<Integer> _stackID = new ArrayList<Integer>();

    public OcasTranslateAbstract() {
        this._code = new StringBuilder(1024);
        this._errors = new StringBuilder(256);
    }

    public void restart(Reader reader, int firstTok) {
        this._lexer = new OcasLexer(reader, this);
        this._firstTok = firstTok;
        this._code = new StringBuilder(1024);
        this._errors = new StringBuilder(256);
    }

    public boolean withError() {
        return this._errors.length() > 0;
    }

    public void yyerror(String s) {
        if (this._errors.length() > 0) {
            this._errors.append("\n");
        }
        this._errors.append("{");
        this._errors.append(Integer.toString(this._lexer.nbline()));
        this._errors.append(",");
        this._errors.append(Integer.toString(this._lexer.nbcolumn()));
        this._errors.append("} [");
        this._errors.append(Integer.toString(this._lexer.nbchar()));
        this._errors.append("] : ");
        this._errors.append(s);
    }

    protected int yylex() {
        int yyl_return = -1;
        try {
            if (this._firstTok != 0) {
                yyl_return = this._firstTok;
                this._firstTok = 0;
            } else {
                yyl_return = this._lexer.yylex();
                this.append(yyl_return, this._lexer.yytext());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return yyl_return;
    }

    protected final String lastName() {
        if (this._stackName.isEmpty()) {
            return "";
        }
        return this._stackName.get(this._stackName.size() - 1);
    }

    protected final String popName() {
        if (this._stackName.isEmpty()) {
            return "";
        }
        return this._stackName.remove(this._stackName.size() - 1);
    }

    protected final Integer popID() {
        if (this._stackID.isEmpty()) {
            return -1;
        }
        return this._stackID.remove(this._stackID.size() - 1);
    }

    protected final void replace(int id, String text) {
        String ID = "$" + id + "$";
        int pos = this._code.lastIndexOf(ID);
        if (pos >= 0) {
            this._code.replace(pos, pos + ID.length(), text);
        }
    }

    protected void append(int token, String str) {
        if (token == 1028) {
            this._code.append("$").append(this._currentCode).append("$");
            this._stackName.add(str);
            this._stackID.add(this._currentCode);
            this._mapIdToName.put(this._currentCode, str);
            ++this._currentCode;
        } else {
            this._code.append(str);
        }
    }

    protected void appendBlank(String str) {
        this._code.append(str);
    }

    protected void appendComment(String str) {
        this._code.append(str);
    }

    protected void replaceID(String str, String rempl) {
        if (this.lastName().equals(str)) {
            this.replace(this.popID(), rempl);
            this.popName();
        }
    }

    void appendID(String str) {
        this.replaceID(str, str);
    }

    protected void appendOperator(String name) {
        this.appendID(name);
    }

    protected void appendVariable(String name) {
        int pos = name.lastIndexOf(94);
        if (pos != -1) {
            this.appendID(name.substring(pos + 1));
            name = name.substring(0, pos);
        }
        if ((pos = name.lastIndexOf(46)) != -1) {
            this.appendID(name.substring(pos + 1));
            name = name.substring(0, pos);
            pos = name.lastIndexOf(46);
            while (pos != -1) {
                this.appendID(name.substring(pos + 1));
                name = name.substring(0, pos);
            }
            if (name.length() > 0) {
                this.appendID(name);
            }
        } else {
            this.appendID(name);
        }
    }

    protected void appendEvent(String name) {
        int pos = name.lastIndexOf(46);
        if (pos != -1) {
            this.appendID(name.substring(pos + 1));
            name = name.substring(0, pos);
            pos = name.lastIndexOf(46);
            while (pos != -1) {
                this.appendID(name.substring(pos + 1));
                name = name.substring(0, pos);
            }
            if (name.length() > 0) {
                this.appendID(name);
            }
        } else {
            this.appendID(name);
        }
    }

    protected void appendSubDecl(List<String> vars, String node) {
        this.appendID(node);
        while (!vars.isEmpty()) {
            String var = vars.remove(vars.size() - 1);
            this.appendID(var);
        }
    }

    protected void appendVariables(List<String> vars) {
        while (!vars.isEmpty()) {
            String var = vars.remove(vars.size() - 1);
            this.appendVariable(var);
        }
    }

    protected void appendEnums(List<String> IDs) {
        while (!IDs.isEmpty()) {
            String id = IDs.remove(IDs.size() - 1);
            this.appendID(id);
        }
    }

    protected final void appendTxt(String txt) {
        this._code.append(txt);
    }

    public String getCode() {
        return this._code.toString();
    }

    public String getErrors() {
        return this._errors.toString();
    }
}

