/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul;

import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprOp;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprParent;
import com.dassault.cecilia.lib.mbsa.translator.model.ExprVar;
import com.dassault.cecilia.lib.mbsa.translator.model.Extern;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.StoreExpr;
import com.dassault.cecilia.lib.mbsa.translator.model.Tree;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimRecorder;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimTrans;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class Analyser
implements Externalizable {
    protected static final String PROP_STEPPER_FORCE_FIXPOINT = "cecilia.mbsa.translator.simul.ForceFixPoint";
    protected Node _main;
    protected DomainDefine _domains;
    protected ArrayList<SimTrans> _transs = new ArrayList(100);
    protected ArrayList<Simular> _vars = new ArrayList(100);
    protected ArrayList<Simular> _states = new ArrayList(100);
    protected int _lastIndexflowCst = 0;
    PrintStream _monitoring = null;
    int _levelMonitor = 0;
    boolean _loopModel = false;
    protected long _uid = -1L;
    private static Comparator<SimTrans> __transitionComparator = new Comparator<SimTrans>(){

        @Override
        public int compare(SimTrans o1, SimTrans o2) {
            return o1.getEvent().getName().compareTo(o2.getEvent().getName());
        }
    };
    private static Comparator<Simular> __simularComparator = new Comparator<Simular>(){

        @Override
        public int compare(Simular o1, Simular o2) {
            return o1.getIndex() - o2.getIndex();
        }
    };

    public Analyser() {
        String defMonitor = System.getProperty("cecilia.mbsa.stepper.DefaultMonitoring");
        if (defMonitor == null || defMonitor.length() == 0) {
            defMonitor = "1 stderr";
        }
        this.defineMonitoring(defMonitor);
    }

    public Analyser(Node main, Model architect) {
        this();
        this._main = main;
        this._domains = architect.getDomainDefine();
        this._uid = architect.getUID();
        this.compile(main);
    }

    /*
     * WARNING - void declaration
     */
    private void compile(Node main) {
        void var5_13;
        int idx;
        long nanoTime = -1L;
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            nanoTime = System.nanoTime();
        }
        if (this.withMonitoring(20)) {
            this.monitor("Flatness [node " + main.toString() + " edon]\n");
        }
        if (this.withMonitoring(14)) {
            this.monitor("*** Compil - display expressions - Begin ***\n");
            HashMap verifyString = new HashMap();
            for (Expr expr : main.getStoreExpr().getExpressions()) {
                String key = expr.toLL();
                if (verifyString.containsKey(key) && MsgTrans.LOG.isLoggable(Level.WARNING)) {
                    Expr firstExpr = (Expr)verifyString.get(key);
                    StringBuffer log = new StringBuffer(1024);
                    log.append("Two same expression : ").append(key).append("\n");
                    log.append("  ").append(firstExpr.getClass().getSimpleName()).append("@").append(Integer.toHexString(System.identityHashCode(firstExpr))).append("\n");
                    log.append("  ").append(expr.getClass().getSimpleName()).append("@").append(Integer.toHexString(System.identityHashCode(expr))).append("\n");
                    MsgTrans.LOG.warning(log.toString());
                }
                this.monitor(expr.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(expr)));
                this.monitor(";" + expr.toLL() + "\n");
            }
            this.monitor("*** Compil - display expressions - End ***\n\n");
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.Monitoring.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        for (idx = 0; idx < this._main.getFlowCount(); ++idx) {
            this._main.getFlow(idx).setFlagPropage('\u0000');
        }
        for (idx = 0; idx < this._main.getStateCount(); ++idx) {
            this._main.getState(idx).setFlagPropage('\u0000');
        }
        for (idx = 0; idx < this._main.getStateCount(); ++idx) {
            Simular simular = this._main.getState(idx).getSimular();
            if (simular.getFlag() != '\u0000') continue;
            this._states.add(simular);
            simular.setFlag('\u0001');
        }
        Collections.sort(this._states, new Comparator<Simular>(){

            @Override
            public int compare(Simular o1, Simular o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        int cpt = 0;
        boolean bl = false;
        while (var5_13 < this._main.getFlowCount()) {
            Simular simular = this._main.getFlow((int)var5_13).getSimular();
            if (simular.getFlag() == '\u0000') {
                this._vars.add(simular);
                simular.setFlag('\u0001');
            }
            ++var5_13;
        }
        if (cpt > 0) {
            MsgTrans.LOG.finer("Number of flow constant : " + cpt);
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.RecupSimular.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        for (Simular simular : this._vars) {
            this.compileVarChildren_rec(simular, simular.getDefine());
        }
        ArrayList<Simular> ordersVars = new ArrayList<Simular>();
        for (Simular simular : this._vars) {
            if (simular.getDefine() == null || simular.getDefine().isConstant()) {
                ordersVars.add(simular);
                simular.setFlag('A');
                continue;
            }
            simular.setFlag('C');
        }
        this._lastIndexflowCst = ordersVars.size();
        for (Simular simular : this._vars) {
            this.compilOrderVar_rec(simular, ordersVars);
        }
        this._vars = ordersVars;
        Iterator<Externalizable> iVar = this._vars.iterator();
        boolean bl2 = false;
        while (iVar.hasNext()) {
            void var5_18;
            Simular simular = iVar.next();
            simular.setFlag('\u0000');
            simular.setIndex((int)var5_18);
            ++var5_18;
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.OrderedVar.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        for (Expr expr : main.getStoreExpr().getExpressions()) {
            expr.setFlag('B');
        }
        for (Simular simular : this._vars) {
            this._loopModel |= this.compileVarParents(main, simular);
        }
        for (Simular simular : this._states) {
            this._loopModel |= this.compileVarParents(main, simular);
        }
        if (Boolean.getBoolean(PROP_STEPPER_FORCE_FIXPOINT)) {
            this._loopModel = true;
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.ParentsVar.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        if (this.withMonitoring(12)) {
            this.monitor("*** Compil - sort vars - Begin ***\n");
            for (Simular simular : this._vars) {
                this.monitor("  " + simular.getName() + " [" + simular.getOrderedParents().size() + "]\n");
            }
            this.monitor("*** Compil - sort vars - End ***\n");
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            nanoTime = System.nanoTime();
        }
        cpt = 0;
        for (cpt = 0; cpt < this._main.getTransCount(); ++cpt) {
            SimTrans simTrans = new SimTrans(this._main.getTrans(cpt));
            this._transs.add(simTrans);
        }
        Collections.sort(this._transs, __transitionComparator);
        cpt = 0;
        for (SimTrans simTrans : this._transs) {
            this.compileTrans(main, simTrans);
            simTrans.setIdx(cpt++);
        }
        for (Expr expr : main.getStoreExpr().getExpressions()) {
            expr.setFlag('\u0000');
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.Trans.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        for (int i = 0; i < main.getExternCount(); ++i) {
            int priority;
            Extern extern = main.getExtern(i);
            Tree tree = extern.getTree();
            if (tree._sval.equals("law")) {
                double delay = extern.delayOfLaw(main);
                if (main.getSubCount() > 0 && Double.isNaN(delay)) {
                    delay = Double.POSITIVE_INFINITY;
                }
                if (Double.isNaN(delay) || !(delay >= 0.0)) continue;
                this.computeDelayEvent_rec((Tree)tree._son, delay);
                continue;
            }
            if (!tree._sval.equals("priority") || (priority = extern.valueOfPriority()) < 0) continue;
            this.computePriorityEvent_rec((Tree)tree._son, priority);
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.Extern.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        main.sortVariable();
    }

    private void compileVarChildren_rec(Simular compilVar, Expr define) {
        if (define instanceof ExprVar) {
            Var var = ((ExprVar)define).getVar();
            compilVar.addChildVar(var.getSimular());
        } else if (define != null) {
            for (int i = define.getArgCount() - 1; i >= 0; --i) {
                this.compileVarChildren_rec(compilVar, define.getArg(i));
            }
        }
    }

    private void compilOrderVar_rec(Simular simVar, ArrayList<Simular> ordersVars) {
        if (simVar.getFlag() != 'C') {
            return;
        }
        simVar.setFlag('A');
        if (simVar.getChildrenVar() != null) {
            for (Simular simular : simVar.getChildrenVar()) {
                this.compilOrderVar_rec(simular, ordersVars);
            }
        }
        ordersVars.add(simVar);
    }

    private void compileVarParents_rec(ExprParent current, Simular compilVar, List<Simular> parentsVar, List<Expr> parentsExpr) {
        Expr expr;
        if (current.getFlag() == 'C') {
            return;
        }
        current.setFlag('C');
        if (current instanceof Expr && ((expr = (Expr)current).getFlag() == 'C' || expr.getFlag() == 'B') && !(expr instanceof ExprVar)) {
            if (expr instanceof ExprOp && ((ExprOp)expr).getType() == ExprOp.Type.EQ && expr.getArg(0) instanceof ExprVar) {
                Simular parentSim = ((ExprVar)expr.getArg(0)).getVar().getSimular();
                Expr define = parentSim.getDefine();
                if (define == null || define != expr.getArg(1)) {
                    parentsExpr.add(expr);
                } else if (parentSim.getIndex() >= 0 && parentSim != compilVar) {
                    if (parentsVar.contains(parentSim)) {
                        MsgTrans.LOG.severe("Compil[Parents-Var] : already exist one simular : " + parentSim.getName());
                    } else {
                        parentsVar.add(parentSim);
                    }
                }
            } else {
                parentsExpr.add(expr);
            }
        }
        Iterator<ExprParent> iParents = current.getParents();
        while (iParents.hasNext()) {
            this.compileVarParents_rec(iParents.next(), compilVar, parentsVar, parentsExpr);
        }
    }

    private boolean compileVarParents(Node main, Simular compilVar) {
        ArrayList<Simular> parentsVar = new ArrayList<Simular>();
        ArrayList<Expr> parentsExpr = new ArrayList<Expr>();
        this.compileVarParents_rec(compilVar.getExprVar(), compilVar, parentsVar, parentsExpr);
        compilVar.getExprVar().setFlagParentPropage('B');
        Collections.sort(parentsVar, __simularComparator);
        compilVar.setOrderedParents(parentsVar);
        Expr[] arrayParentExpr = new Expr[parentsExpr.size()];
        compilVar.setParentsExpr(parentsExpr.toArray(arrayParentExpr));
        return parentsVar.size() > 0 && ((Simular)parentsVar.get(0)).getIndex() < compilVar.getIndex();
    }

    private void compileTrans(Node main, SimTrans compilTrans) {
        ArrayList<Simular> parentsVar = new ArrayList<Simular>();
        ArrayList<Expr> parentsExpr = new ArrayList<Expr>();
        Iterator<Data> iAffects = compilTrans.getTrans().getAffects().iterator();
        while (iAffects.hasNext()) {
            Simular simVar = ((Var)iAffects.next()).getSimular();
            iAffects.next();
            this.compileVarParents_rec(simVar.getExprVar(), null, parentsVar, parentsExpr);
        }
        Collections.sort(parentsVar, __simularComparator);
        compilTrans.setOrderedParents(parentsVar);
        Expr[] arrayParentExpr = new Expr[parentsExpr.size()];
        compilTrans.setParentsExpr(parentsExpr.toArray(arrayParentExpr));
        iAffects = compilTrans.getTrans().getAffects().iterator();
        while (iAffects.hasNext()) {
            Simular simVar = ((Var)iAffects.next()).getSimular();
            iAffects.next();
            simVar.getExprVar().setFlagParentPropage('B');
        }
    }

    private void computeDelayEvent_rec(Tree son, double delay) {
        if (son._type == 268) {
            ((Event)son._son).putSimulTool("simul-delay", delay);
        } else if (son._type == 40 && son._sval.length() == 0) {
            Tree cur = (Tree)son._son;
            while (cur != null) {
                this.computeDelayEvent_rec(cur, delay);
                cur = cur._next;
            }
        }
    }

    private void computePriorityEvent_rec(Tree son, int priority) {
        if (son._type == 268) {
            ((Event)son._son).putSimulTool("priority", priority);
        } else if (son._type == 40 && son._sval.length() == 0) {
            Tree cur = (Tree)son._son;
            while (cur != null) {
                this.computePriorityEvent_rec(cur, priority);
                cur = cur._next;
            }
        }
    }

    public boolean save(File outputFile) throws IOException {
        boolean result = false;
        long nanoTime = System.nanoTime();
        OutputStream outStream = null;
        try {
            outStream = new ZipOutputStream(new FileOutputStream(outputFile));
            ZipEntry ze = new ZipEntry("simulator");
            ((ZipOutputStream)outStream).putNextEntry(ze);
            DataOutputStream dataOutStream = new DataOutputStream(new BufferedOutputStream(outStream));
            SimRecorder recorder = new SimRecorder();
            recorder.writeSimulator(dataOutStream, this);
            result = recorder.getAskReload();
            dataOutStream.flush();
            ((ZipOutputStream)outStream).closeEntry();
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Throwable th) {
            throw new IOException("Internal error during serialisation", th);
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    MsgTrans.LOG.log(Level.INFO, "IOException during close FileOutputStream(" + outputFile + ").", e);
                }
            }
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.Save.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
        return result;
    }

    protected void load(File inputFile) throws IOException {
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inputFile));
        this.load(inStream);
    }

    protected void load(InputStream inputStream) throws IOException {
        ZipInputStream inStream = new ZipInputStream(inputStream);
        this.load(inStream);
    }

    private void load(ZipInputStream inStream) throws IOException {
        long nanoTime = System.nanoTime();
        try {
            ZipEntry ze = null;
            while ((ze = inStream.getNextEntry()) != null && !ze.getName().equals("simulator")) {
                inStream.closeEntry();
            }
            if (ze == null) {
                throw new IOException("No entry 'simulator' in zip stream");
            }
            DataInputStream dataInStream = new DataInputStream(new BufferedInputStream(inStream));
            SimRecorder recorder = new SimRecorder();
            this._main = new Node(null, "main", StoreExpr.Type.EXPR);
            this._domains = new DomainDefine();
            recorder.readSimulator(dataInStream, this);
            Iterator<Simular> iVar = this._vars.iterator();
            int index = 0;
            while (iVar.hasNext()) {
                Simular simVar = iVar.next();
                simVar.setFlag('\u0000');
                simVar.setIndex(index);
                ++index;
            }
            inStream.closeEntry();
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (OutOfMemoryError oome) {
            throw new IOException("OutOfMemory error during serialisation (enlarge JVM memory with --mx1400m arguments)", oome);
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new IOException("Internal error during serialisation", th);
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (MsgTrans.LOG.isLoggable(Level.FINER)) {
            MsgTrans.LOG.finer("Simulator.Compil.Load.Delay.ms=" + (System.nanoTime() - nanoTime) / 1000000L);
            nanoTime = System.nanoTime();
        }
    }

    void setMonitoring(PrintStream monitor, int level) {
        if (this._monitoring != null && this._monitoring != System.out && this._monitoring != System.err) {
            this._monitoring.close();
        }
        this._monitoring = monitor;
        this._levelMonitor = level;
    }

    protected boolean withMonitoring(int level) {
        return level <= this._levelMonitor && this._monitoring != null;
    }

    protected void monitor(String text) {
        if (this._monitoring != null) {
            this._monitoring.print(text);
        }
    }

    protected static String getKeyOfSimulOption(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        return option.substring(0, pos);
    }

    protected static String getValueOfSimulOption(String option) {
        int pos = option.indexOf("=");
        if (pos == -1) {
            return "";
        }
        String value = option.substring(pos + 1);
        if (value.length() > 0 && value.charAt(0) == '\"' && (pos = value.lastIndexOf(34)) > 0) {
            return value.substring(1, pos);
        }
        return value;
    }

    void defineMonitoring(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        int level = 6;
        Pattern pattern = Pattern.compile("^([0-9]+)");
        Matcher match = pattern.matcher(value);
        if (match.find()) {
            level = Integer.parseInt(match.group(1));
            value = value.substring(match.end(1)).trim();
        }
        if (value.equals("stdout")) {
            this.setMonitoring(System.out, level);
        } else if (value.equals("stderr")) {
            this.setMonitoring(System.err, level);
        } else if (value.equals("null")) {
            this.setMonitoring(null, level);
        } else {
            try {
                FileOutputStream fout = new FileOutputStream(value);
                PrintStream pout = new PrintStream(fout, true);
                this.setMonitoring(pout, level);
            }
            catch (FileNotFoundException e) {
                MsgTrans.LOG.log(Level.WARNING, "Bad monitoring : " + value, e);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this._domains);
        int size = this._states.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._states.get(i));
        }
        size = this._vars.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._vars.get(i));
        }
        out.writeObject(this._main);
        size = this._states.size();
        for (i = 0; i < size; ++i) {
            this._states.get(i).writeAdditionalExternal(out);
        }
        size = this._vars.size();
        for (i = 0; i < size; ++i) {
            this._vars.get(i).writeAdditionalExternal(out);
        }
        size = this._transs.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._transs.get(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this._domains = (DomainDefine)in.readObject();
        int size = in.readInt();
        this._states.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._states.add((Simular)in.readObject());
        }
        size = in.readInt();
        this._vars.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._vars.add((Simular)in.readObject());
        }
        this._main = (Node)in.readObject();
        size = this._states.size();
        for (i = 0; i < size; ++i) {
            this._states.get(i).readAdditionalExternal(in);
        }
        size = this._vars.size();
        for (i = 0; i < size; ++i) {
            this._vars.get(i).readAdditionalExternal(in);
        }
        size = in.readInt();
        this._transs.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._transs.add((SimTrans)in.readObject());
        }
    }

    protected void finalize() throws Throwable {
        if (this._vars != null) {
            this.dispose();
        }
        MsgTrans.LOG.finest("Finalize " + Analyser.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
    }

    public void dispose() {
        MsgTrans.LOG.finest("Dispose " + Analyser.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
        if (this._vars != null) {
            for (Simular sim : this._vars) {
                sim.dispose();
            }
            this._vars = null;
        }
        if (this._states != null) {
            for (Simular sim : this._states) {
                sim.dispose();
            }
            this._states = null;
        }
        if (this._transs != null) {
            for (SimTrans tr : this._transs) {
                tr.dispose();
            }
            this._transs = null;
        }
    }
}

