/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul;

import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.jstepper.MsgJStep;
import com.dassault.cecilia.lib.mbsa.translator.model.Data;
import com.dassault.cecilia.lib.mbsa.translator.model.Event;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.IndentWriter;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.Trans;
import com.dassault.cecilia.lib.mbsa.translator.model.Var;
import com.dassault.cecilia.lib.mbsa.translator.simul.Simulator;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import com.dassault.cecilia.lib.util.io.LimitedWriter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;

public class SimTrans
implements Externalizable {
    Trans _tr;
    int _idx;
    boolean _bAffectSameVar;
    double _firingTime;
    double[] _affectValues = null;
    Expr[] _parentsExpr;
    List<Simular> _parentsVar;

    public SimTrans(Trans tr) {
        this._tr = tr;
        this._idx = -1;
        this._firingTime = Double.POSITIVE_INFINITY;
        this._bAffectSameVar = false;
        if (this._tr.getAffects().size() > 2) {
            IdentityHashSet<Simular> vars = new IdentityHashSet<Simular>();
            Iterator<Data> iAffects = this._tr.getAffects().iterator();
            while (!this._bAffectSameVar && iAffects.hasNext()) {
                Simular simVar = ((Var)iAffects.next()).getSimular();
                if (vars.contains(simVar)) {
                    this._bAffectSameVar = true;
                } else {
                    vars.add(simVar);
                }
                iAffects.next();
            }
        }
    }

    public final Trans getTrans() {
        return this._tr;
    }

    public final Event getEvent() {
        return this._tr.getEvent();
    }

    public String getDescription() {
        LimitedWriter realWrite;
        StringWriter write;
        block3: {
            write = new StringWriter(128);
            realWrite = new LimitedWriter(write, 1024, true);
            IndentWriter out = new IndentWriter(realWrite);
            try {
                this._tr.printOTools(out, 0);
                out.close(true);
            }
            catch (IOException e) {
                if (realWrite.isFull()) break block3;
                e.printStackTrace();
            }
        }
        if (realWrite.isFull()) {
            write.append("  ...");
        }
        return write.toString();
    }

    public final int getIdx() {
        return this._idx;
    }

    public final void setIdx(int idx) {
        this._idx = idx;
    }

    public final double getFiringTime() {
        return this._firingTime;
    }

    public final void setFiringTime(double firingTime) {
        this._firingTime = firingTime;
    }

    public final boolean isValid() throws StepperException {
        return this._tr.getGuard().getEvaluateDouble() != 0.0;
    }

    public void affect(Simulator sim) throws StepperException {
        if (this._affectValues == null) {
            this._affectValues = new double[this._tr.getAffects().size() / 2];
        }
        Iterator<Data> iAffects = this._tr.getAffects().iterator();
        int i = 0;
        while (iAffects.hasNext()) {
            iAffects.next();
            Expr val = (Expr)iAffects.next();
            this._affectValues[i] = val.getEvaluateDouble();
            ++i;
        }
        if (!this._bAffectSameVar) {
            iAffects = this._tr.getAffects().iterator();
            i = 0;
            while (iAffects.hasNext()) {
                Simular simVar = ((Var)iAffects.next()).getSimular();
                iAffects.next();
                if (!simVar.getDomain().verifyValue(this._affectValues[i])) {
                    throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_NO_CORRECT", simVar.getName(), simVar.getDomain().toString(this._affectValues[i]), simVar.getDomain().toString()));
                }
                sim.addBackValue(simVar, simVar.getValue());
                simVar.setValue(this._affectValues[i]);
                ++i;
            }
        } else {
            iAffects = this._tr.getAffects().iterator();
            IdentityHashMap<Simular, Double> vars = new IdentityHashMap<Simular, Double>();
            int i2 = 0;
            while (iAffects.hasNext()) {
                Simular simVar = ((Var)iAffects.next()).getSimular();
                iAffects.next();
                if (vars.containsKey(simVar)) {
                    double prevValue = (Double)vars.get(simVar);
                    if (prevValue != this._affectValues[i2]) {
                        throw new StepperException("Affect 2 differents values (" + prevValue + ", " + this._affectValues[i2] + ") for variable '" + simVar.getName() + "' during firing transition '" + this.getEvent().getName() + "'.");
                    }
                } else {
                    if (!simVar.getDomain().verifyValue(this._affectValues[i2])) {
                        throw new StepperViolatedAssertionException(MsgJStep.msgFormat("EXC_STEP_VALUE_NO_CORRECT", simVar.getName(), simVar.getDomain().toString(this._affectValues[i2]), simVar.getDomain().toString()));
                    }
                    sim.addBackValue(simVar, simVar.getValue());
                    simVar.setValue(this._affectValues[i2]);
                    vars.put(simVar, this._affectValues[i2]);
                }
                ++i2;
            }
        }
        for (i = 0; i < this._parentsExpr.length; ++i) {
            this._parentsExpr[i].setFlag('C');
        }
    }

    public final void setOrderedParents(List<Simular> parents) {
        this._parentsVar = parents;
    }

    public final List<Simular> getOrderedParents() {
        return this._parentsVar;
    }

    public final void setParentsExpr(Expr[] parentsExpr) {
        this._parentsExpr = parentsExpr;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._tr);
        out.writeInt(this._idx);
        out.writeBoolean(this._bAffectSameVar);
        out.writeDouble(this._firingTime);
        int size = this._parentsExpr.length;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeObject(this._parentsExpr[i]);
        }
        out.writeInt(this._parentsVar.size());
        for (Simular simVar : this._parentsVar) {
            out.writeObject(simVar);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this._tr = (Trans)in.readObject();
        this._idx = in.readInt();
        this._bAffectSameVar = in.readBoolean();
        this._firingTime = in.readDouble();
        int size = in.readInt();
        this._parentsExpr = new Expr[size];
        for (i = 0; i < size; ++i) {
            this._parentsExpr[i] = (Expr)in.readObject();
        }
        size = in.readInt();
        this._parentsVar = new ArrayList<Simular>(size);
        for (i = 0; i < size; ++i) {
            this._parentsVar.add((Simular)in.readObject());
        }
    }

    public void dispose() {
        this._parentsExpr = null;
        this._parentsVar = null;
    }
}

