/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.StepperViolatedAssertionException;
import com.dassault.cecilia.lib.mbsa.translator.MsgTrans;
import com.dassault.cecilia.lib.mbsa.translator.model.Domain;
import com.dassault.cecilia.lib.mbsa.translator.model.DomainDefine;
import com.dassault.cecilia.lib.mbsa.translator.model.Expr;
import com.dassault.cecilia.lib.mbsa.translator.model.Flow;
import com.dassault.cecilia.lib.mbsa.translator.model.Model;
import com.dassault.cecilia.lib.mbsa.translator.model.Node;
import com.dassault.cecilia.lib.mbsa.translator.model.Simular;
import com.dassault.cecilia.lib.mbsa.translator.model.State;
import com.dassault.cecilia.lib.mbsa.translator.simul.Analyser;
import com.dassault.cecilia.lib.mbsa.translator.simul.Sheduler;
import com.dassault.cecilia.lib.mbsa.translator.simul.SimTrans;
import com.dassault.cecilia.lib.util.collection.LinkedStack;
import com.dassault.cecilia.lib.util.collection.Stack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Simulator
extends Analyser
implements Stepper {
    Sheduler _sheduler;
    Stack _stackStep;
    SimulStep _currentStep;
    private LinkedList<Simular> _currentSimulStack;
    private LinkedList<Simular> _nextSimulStack;
    public static final int PROP_STEPPER_FIXPOINT_LOOP_DEF = 100;
    public static final String PROP_STEPPER_FIXPOINT_LOOP = "cecilia.mbsa.translator.simul.fixpoint.loop";
    private static final String PROP_STEPPER_FIXPOINT_WITHOUTLIST = "cecilia.mbsa.translator.simul.perf.withoutList";
    public static final int PROP_DEF_STEPPER_FIXPOINT_TRACENAN = 100;
    public static final String PROP_STEPPER_FIXPOINT_TRACENAN = "cecilia.mbsa.translator.simul.fixpoint.TraceNaNValues";
    boolean _autoDeterminist = false;
    int _maxChange = Integer.getInteger("cecilia.mbsa.translator.simul.fixpoint.loop", 100);
    boolean _simulLoopWithoutList = Boolean.getBoolean("cecilia.mbsa.translator.simul.perf.withoutList");
    long _step = 0L;

    public Simulator() {
        this._stackStep = new LinkedStack();
        this._currentSimulStack = new LinkedList();
        this._nextSimulStack = new LinkedList();
    }

    public Simulator(Node main, Model architect) {
        super(main, architect);
        this._stackStep = new LinkedStack();
        this._currentSimulStack = new LinkedList();
        this._nextSimulStack = new LinkedList();
        this._sheduler = new Sheduler(this);
    }

    @Override
    public void load(File inputFile) throws IOException {
        super.load(inputFile);
        this._sheduler = new Sheduler(this);
        if (Boolean.getBoolean("cecilia.mbsa.translator.simul.ForceFixPoint")) {
            this._loopModel = true;
        }
    }

    @Override
    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
        this._sheduler = new Sheduler(this);
        if (Boolean.getBoolean("cecilia.mbsa.translator.simul.ForceFixPoint")) {
            this._loopModel = true;
        }
    }

    @Override
    public long getUID() {
        return this._uid;
    }

    @Override
    public boolean withSimul() {
        return true;
    }

    @Override
    public boolean withDomain() {
        return true;
    }

    private void incStep() {
        this._step = this._step == Long.MAX_VALUE ? 0L : ++this._step;
    }

    long getCurrentStep() {
        return this._step;
    }

    @Override
    public int getNbrTransition() {
        return this._transs.size();
    }

    SimTrans getTransition(int i) {
        return (SimTrans)this._transs.get(i);
    }

    @Override
    public String getNameOfTransition(int i) {
        SimTrans tr = (SimTrans)this._transs.get(i - 1);
        return tr.getEvent().getName();
    }

    @Override
    public String getDescOfTransition(int i) {
        SimTrans tr = (SimTrans)this._transs.get(i - 1);
        return tr.getDescription();
    }

    @Override
    public int getNbrState() {
        return this._main.getStateCount();
    }

    @Override
    public String getNameOfState(int i) {
        State var = this._main.getState(i - 1);
        return var.getName();
    }

    @Override
    public double getValueOfState(int i) {
        State var = this._main.getState(i - 1);
        return var.getSimular().getValue();
    }

    @Override
    public String getValueStringOfState(int i) {
        State var = this._main.getState(i - 1);
        return var.getDomain().toString(var.getSimular().getValue());
    }

    @Override
    public int getNbrFlow() {
        return this._main.getFlowCount();
    }

    @Override
    public String getNameOfFlow(int i) {
        Flow var = this._main.getFlow(i - 1);
        return var.getName();
    }

    @Override
    public double getValueOfFlow(int i) {
        Flow var = this._main.getFlow(i - 1);
        return var.getSimular().getValue();
    }

    @Override
    public String getValueStringOfFlow(int i) {
        Flow var = this._main.getFlow(i - 1);
        return var.getDomain().toString(var.getSimular().getValue());
    }

    private int getIndexOfDomain(Domain dom) {
        int idx = dom.getIdx();
        if (idx >= 0) {
            return 10 + idx;
        }
        if (dom.equals(this._domains.getBool())) {
            return 0;
        }
        if (dom.equals(this._domains.getInt())) {
            return 1;
        }
        if (dom.equals(this._domains.getFloat())) {
            return 2;
        }
        return -1;
    }

    @Override
    public int getDomainOfFlow(int i) {
        Domain dom = this._main.getFlow(i - 1).getDomain();
        return this.getIndexOfDomain(dom);
    }

    @Override
    public int getDomainOfState(int i) {
        Domain dom = this._main.getState(i - 1).getDomain();
        return this.getIndexOfDomain(dom);
    }

    @Override
    public List<String> getValuesOfDomain(int i) {
        Domain dom = null;
        if (i >= 10) {
            dom = this._domains.getDomainFromIndex(i - 10);
        }
        if (dom == null) {
            return null;
        }
        return dom.getStringValues();
    }

    @Override
    public List<Double> getDoubleValuesOfDomain(int i) {
        Domain dom = null;
        if (i >= 10) {
            dom = this._domains.getDomainFromIndex(i - 10);
        }
        if (dom == null) {
            return null;
        }
        return dom.getDoubleValues();
    }

    @Override
    public double getCurrentTime() {
        return this._sheduler.getCurrentTime();
    }

    @Override
    public int getCurrentCycle() {
        return this._sheduler.getCurrentLoop();
    }

    @Override
    public int[] getSheduler() {
        return this._sheduler.getSheduler();
    }

    @Override
    public boolean setSimulOptions(List<String> args) {
        if (!this._sheduler.setSimulOptions(args)) {
            return false;
        }
        for (String option : args) {
            String optVal;
            String key = Simulator.getKeyOfSimulOption(option);
            if (key.equals("monitoring")) {
                optVal = Simulator.getValueOfSimulOption(option);
                this.defineMonitoring(optVal);
                continue;
            }
            if (key.equals("fixpoint.loop")) {
                optVal = Simulator.getValueOfSimulOption(option);
                int maxChange = Integer.parseInt(optVal);
                if (maxChange < 0) continue;
                this._maxChange = maxChange;
                continue;
            }
            if (!key.equals("determinist.auto")) continue;
            this._autoDeterminist = Simulator.getValueOfSimulOption(option).equals("true");
        }
        return true;
    }

    final void addBackValue(Simular value, double val) {
        if (this._currentStep != null) {
            this._currentStep.add(value, val);
        }
    }

    final void changeValue(Simular var, double newValue) {
        var.setValue(newValue);
        var.getExprVar().setFlag('\u0000');
        Expr[] parents = var.getParentsExpr();
        for (int i = 0; i < parents.length; ++i) {
            parents[i].setFlag('C');
        }
    }

    final void addToSimulStack(Collection<Simular> addVars, int limitIdx) {
        Simular curVar;
        ListIterator<Simular> iterStack;
        if (addVars.size() == 0) {
            return;
        }
        Iterator<Simular> iterAdd = addVars.iterator();
        Simular addVar = iterAdd.next();
        if (addVar.getIndex() < limitIdx) {
            if (this._nextSimulStack.size() == 0) {
                do {
                    this._nextSimulStack.add(addVar);
                    if (!iterAdd.hasNext()) {
                        return;
                    }
                    addVar = iterAdd.next();
                } while (addVar.getIndex() < limitIdx);
            } else {
                iterStack = this._nextSimulStack.listIterator();
                curVar = (Simular)iterStack.next();
                do {
                    if (addVar.getIndex() < curVar.getIndex()) {
                        iterStack.add(addVar);
                        if (iterAdd.hasNext()) {
                            addVar = iterAdd.next();
                            continue;
                        }
                        return;
                    }
                    if (iterStack.hasNext()) {
                        curVar = (Simular)iterStack.next();
                        continue;
                    }
                    do {
                        this._nextSimulStack.add(addVar);
                        if (!iterAdd.hasNext()) {
                            return;
                        }
                        addVar = iterAdd.next();
                    } while (addVar.getIndex() < limitIdx);
                } while (addVar.getIndex() < limitIdx);
            }
        }
        assert (addVar.getIndex() > limitIdx);
        if (this._currentSimulStack.size() == 0) {
            while (true) {
                this._currentSimulStack.add(addVar);
                if (!iterAdd.hasNext()) break;
                addVar = iterAdd.next();
            }
            return;
        }
        iterStack = this._currentSimulStack.listIterator();
        curVar = (Simular)iterStack.next();
        while (true) {
            if (addVar.getIndex() < curVar.getIndex()) {
                iterStack.add(addVar);
                if (iterAdd.hasNext()) {
                    addVar = iterAdd.next();
                    continue;
                }
                return;
            }
            if (!iterStack.hasNext()) break;
            curVar = (Simular)iterStack.next();
        }
        while (true) {
            this._currentSimulStack.add(addVar);
            if (!iterAdd.hasNext()) break;
            addVar = iterAdd.next();
        }
    }

    private boolean changeVariableValue(Simular var, double newValue) throws StepperException {
        if (var.getValue() == newValue) {
            return false;
        }
        if (!var.getDomain().verifyValue(newValue)) {
            throw new StepperViolatedAssertionException(MsgTrans.msgFormat("EXC_STEP_VALUE_NO_CORRECT", var.getName(), var.getDomain().toString(newValue), var.getDomain().toString()));
        }
        this.addBackValue(var, var.getValue());
        this.changeValue(var, newValue);
        if (this.withMonitoring(10)) {
            this.monitor("    Change : " + var.getName() + " = " + newValue + "\n");
        }
        return true;
    }

    private void propageLinkedFixPoint() throws StepperException {
        if (this._currentSimulStack.size() != 0) {
            throw new StepperException("CurrentSimulStack not empty");
        }
        for (int limit = 0; limit < this._maxChange; ++limit) {
            if (this.withMonitoring(10)) {
                this.monitor("  Propage values --- (step=" + limit + ")\n");
            }
            this._currentSimulStack = this._nextSimulStack;
            this._nextSimulStack = new LinkedList();
            while (this._currentSimulStack.size() > 0) {
                double newValue;
                Simular var = this._currentSimulStack.removeFirst();
                if (!this.changeVariableValue(var, newValue = var.getDefine().getEvaluateDouble())) continue;
                this.addToSimulStack(var.getOrderedParents(), var.getIndex());
            }
            if (this._nextSimulStack.size() != 0) continue;
            if (this.withMonitoring(4)) {
                if (limit > 1) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                } else if (this.withMonitoring(8) && !this.withMonitoring(10)) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                }
            }
            return;
        }
        StringBuilder logVars = new StringBuilder();
        int maxNaNVariables = Integer.getInteger(PROP_STEPPER_FIXPOINT_TRACENAN, 100);
        this._currentSimulStack = this._nextSimulStack;
        this._nextSimulStack = new LinkedList();
        while (this._currentSimulStack.size() > 0) {
            Simular var = this._currentSimulStack.removeFirst();
            double newValue = var.getDefine().getEvaluateDouble();
            if (--maxNaNVariables > 0) {
                logVars.append("\t").append(var.getName());
                logVars.append("\t").append(var.getDomain().toString(var.getValue()));
                logVars.append("\t").append(var.getDomain().toString(newValue)).append("\n");
            }
            if (!this.changeVariableValue(var, newValue)) continue;
            this.addToSimulStack(var.getOrderedParents(), var.getIndex());
        }
        throw new StepperException(MsgTrans.msgFormat("EXC_STEP_UNRESOLVING_LOOP", this._maxChange, logVars.toString()));
    }

    private void propageFixPointWithNaN() throws StepperException {
        for (int limit = 0; limit < this._maxChange; ++limit) {
            if (this.withMonitoring(10)) {
                this.monitor("  Propage values --- (step=" + limit + ")\n");
            }
            boolean change = false;
            int nbrNaN = 0;
            int indexMin = 0;
            int indexMax = this._vars.size() - 1;
            for (int index = indexMin; index <= indexMax; ++index) {
                boolean stopNaN;
                Simular var = (Simular)this._vars.get(index);
                Expr define = var.getDefine();
                boolean bl = stopNaN = define == null || !define.evaluateWithNaN();
                if (stopNaN) {
                    ++nbrNaN;
                    if (!this.withMonitoring(12)) continue;
                    this.monitor("      Stop NaN : " + var.getName() + "\n");
                    continue;
                }
                double newValue = define.getDouble();
                if (this.changeVariableValue(var, newValue)) {
                    change = true;
                    continue;
                }
                if (!this.withMonitoring(14)) continue;
                this.monitor("      Don't change : " + var.getName() + " = " + newValue + "\n");
            }
            if (change) continue;
            if (nbrNaN > 0) {
                if (this.withMonitoring(1)) {
                    this.monitor("  Propage with NaN (nbr=" + nbrNaN + ")\n");
                }
                StringBuilder logVars = new StringBuilder(512);
                int maxNaNVariables = Integer.getInteger(PROP_STEPPER_FIXPOINT_TRACENAN, 100);
                int cpt = 0;
                for (int index = indexMin; index <= indexMax && cpt < maxNaNVariables; ++index) {
                    Simular var = (Simular)this._vars.get(index);
                    if (!Double.isNaN(var.getValue())) continue;
                    logVars.append("\t").append(var.getName()).append("\n");
                    ++cpt;
                }
                if (this.withMonitoring(10)) {
                    this.monitor("Unresolving loop because " + nbrNaN + " variables have no value:\n" + logVars.toString());
                }
                throw new StepperException(MsgTrans.msgFormat("EXC_STEP_UNRESOLVING_LOOP_NAN", nbrNaN, logVars.toString()));
            }
            if (this.withMonitoring(4)) {
                if (limit > 1) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                } else if (this.withMonitoring(8) && !this.withMonitoring(10)) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                }
            }
            return;
        }
        StringBuilder logVars = new StringBuilder();
        int maxNaNVariables = Integer.getInteger(PROP_STEPPER_FIXPOINT_TRACENAN, 100);
        for (int index = 0; index < this._vars.size(); ++index) {
            boolean stopNaN;
            Simular var = (Simular)this._vars.get(index);
            Expr define = var.getDefine();
            boolean bl = stopNaN = define == null || !define.evaluateWithNaN();
            if (stopNaN) continue;
            double newValue = define.getDouble();
            if (--maxNaNVariables > 0) {
                logVars.append("\t").append(var.getName());
                logVars.append("\t").append(var.getDomain().toString(var.getValue()));
                logVars.append("\t").append(var.getDomain().toString(newValue)).append("\n");
            }
            this.changeVariableValue(var, newValue);
        }
        throw new StepperException(MsgTrans.msgFormat("EXC_STEP_UNRESOLVING_LOOP", this._maxChange, logVars.toString()));
    }

    private void propageFixPointWithoutList(int firstIndex, int lastIndex) throws StepperException {
        for (int limit = 0; limit < this._maxChange; ++limit) {
            int index = firstIndex;
            firstIndex = Integer.MAX_VALUE;
            if (this.withMonitoring(10)) {
                this.monitor("  Propage values --- (step=" + limit + ")\n");
            }
            while (index <= lastIndex) {
                Simular var = (Simular)this._vars.get(index);
                if (var.getFlag() == 'C') {
                    var.setFlag('\u0000');
                    double newValue = var.getDefine().getEvaluateDouble();
                    if (this.changeVariableValue(var, newValue)) {
                        for (Simular parentVar : var.getOrderedParents()) {
                            if (parentVar.getIndex() > lastIndex) {
                                lastIndex = parentVar.getIndex();
                            }
                            if (parentVar.getIndex() < var.getIndex() && parentVar.getIndex() < firstIndex) {
                                firstIndex = parentVar.getIndex();
                            }
                            parentVar.setFlag('C');
                        }
                    }
                }
                ++index;
            }
            if (firstIndex != Integer.MAX_VALUE) continue;
            if (this.withMonitoring(4)) {
                if (limit > 1) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                } else if (this.withMonitoring(8) && !this.withMonitoring(10)) {
                    this.monitor("  Propage stop at " + limit + " steps\n");
                }
            }
            return;
        }
        StringBuilder logVars = new StringBuilder();
        int maxNaNVariables = Integer.getInteger(PROP_STEPPER_FIXPOINT_TRACENAN, 100);
        for (int index = firstIndex; index <= lastIndex; ++index) {
            Simular var = (Simular)this._vars.get(index);
            if (var.getFlag() != 'C') continue;
            var.setFlag('\u0000');
            double newValue = var.getDefine().getEvaluateDouble();
            if (--maxNaNVariables > 0) {
                logVars.append("\t").append(var.getName());
                logVars.append("\t").append(var.getDomain().toString(var.getValue()));
                logVars.append("\t").append(var.getDomain().toString(newValue)).append("\n");
            }
            if (!this.changeVariableValue(var, newValue)) continue;
            for (Simular parentVar : var.getOrderedParents()) {
                if (parentVar.getIndex() > lastIndex) {
                    lastIndex = parentVar.getIndex();
                }
                parentVar.setFlag('C');
            }
        }
        throw new StepperException(MsgTrans.msgFormat("EXC_STEP_UNRESOLVING_LOOP", this._maxChange, logVars.toString()));
    }

    private void propageAffectation(int firstIndex, int lastIndex) throws StepperException {
        if (this.withMonitoring(10)) {
            this.monitor("  Propage Affectation values --- (begin)\n");
        }
        for (int index = firstIndex; index <= lastIndex; ++index) {
            Simular var = (Simular)this._vars.get(index);
            if (var.getFlag() != 'C') continue;
            var.setFlag('\u0000');
            double newValue = var.getDefine().getEvaluateDouble();
            if (!this.changeVariableValue(var, newValue)) continue;
            for (Simular parentVar : var.getOrderedParents()) {
                if (parentVar.getIndex() > lastIndex) {
                    lastIndex = parentVar.getIndex();
                }
                parentVar.setFlag('C');
            }
        }
        if (this.withMonitoring(10)) {
            this.monitor("  Propage Affectation values --- (end)\n");
        }
    }

    @Override
    public boolean goInitialState() throws StepperException {
        MsgTrans.LOG.finer("[TStepper.goInitialState] Start " + Integer.toHexString(super.hashCode()));
        if (this.withMonitoring(6)) {
            this.monitor("goInitialState()\n");
        }
        this._stackStep.clear();
        this._currentStep = null;
        this.incStep();
        for (Simular simular : this._states) {
            simular.setValue(simular.getInitValue());
            simular.setFlag('I');
        }
        for (Simular simular : this._vars) {
            simular.setValue(simular.getInitValue());
            simular.setFlag('I');
        }
        for (Expr expr : this._main.getStoreExpr().getExpressions()) {
            expr.setFlag('I');
        }
        for (SimTrans simTrans : this._transs) {
            simTrans.setFiringTime(Double.POSITIVE_INFINITY);
            simTrans.getTrans().setFlagPropage('I');
        }
        this.propageFixPointWithNaN();
        this._sheduler.init();
        SimTrans tr = this._sheduler.update();
        boolean bl = true;
        while (tr != null) {
            boolean bl2;
            tr = this.goForward(tr, bl2);
            bl2 = false;
        }
        if (this.withMonitoring(8)) {
            this.monitor(">> End initiale state\n");
        }
        MsgTrans.LOG.finer("[TStepper.goInitialState] End " + Integer.toHexString(super.hashCode()));
        return true;
    }

    @Override
    public double isValidTransition(int i) throws StepperException {
        SimTrans tr = (SimTrans)this._transs.get(i - 1);
        if (tr.isValid()) {
            if (this._autoDeterminist && !tr.getEvent().isStochastic() && !this._sheduler.includeInFirst(tr)) {
                return -1.0;
            }
            return tr.getFiringTime();
        }
        return -1.0;
    }

    @Override
    public boolean setValueOfState(int i, String strValue) throws StepperException {
        State var = this._main.getState(i - 1);
        Simular simVar = var.getSimular();
        double value = var.getDomain().parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        if (simVar.getValue() == value) {
            return true;
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getName() + ", strValue [" + value + "])\n");
        }
        return this.setValueOfState(simVar, value);
    }

    @Override
    public boolean setValueOfState(int i, double value) throws StepperException {
        State var = this._main.getState(i - 1);
        Simular simVar = var.getSimular();
        Domain dom = var.getDomain();
        if (!dom.verifyValueOf(value)) {
            throw new StepperViolatedAssertionException(MsgTrans.msgFormat("EXC_STEP_VALUE_NO_CORRECT", var.getName(), value + "/[" + dom.toString(value) + "]", dom.toString()));
        }
        if (simVar.getValue() == value) {
            return true;
        }
        if (this.withMonitoring(6)) {
            this.monitor("setValueOfState(" + var.getName() + ", strValue [" + value + "])\n");
        }
        return this.setValueOfState(simVar, value);
    }

    private boolean setValueOfState(Simular simVar, double value) throws StepperException {
        this._currentStep = new SimulStep(10);
        this.incStep();
        this.addBackValue(simVar, simVar.getValue());
        simVar.setValue(value);
        this.changeValue(simVar, value);
        if (this._loopModel) {
            if (this._simulLoopWithoutList) {
                if (simVar.getOrderedParents().size() > 0) {
                    firstIndex = simVar.getOrderedParents().get(0).getIndex();
                    lastIndex = simVar.getOrderedParents().get(simVar.getOrderedParents().size() - 1).getIndex();
                    for (Simular parentVar : simVar.getOrderedParents()) {
                        parentVar.setFlag('C');
                    }
                    this.propageFixPointWithoutList(firstIndex, lastIndex);
                }
            } else {
                if (this._nextSimulStack.size() != 0) {
                    throw new StepperException("NextSimulStack not empty");
                }
                this._nextSimulStack.addAll(simVar.getOrderedParents());
                this.propageLinkedFixPoint();
            }
        } else if (simVar.getOrderedParents().size() > 0) {
            firstIndex = simVar.getOrderedParents().get(0).getIndex();
            lastIndex = simVar.getOrderedParents().get(simVar.getOrderedParents().size() - 1).getIndex();
            for (Simular parentVar : simVar.getOrderedParents()) {
                parentVar.setFlag('C');
            }
            this.propageAffectation(firstIndex, lastIndex);
        }
        this._stackStep.push(this._currentStep);
        this._currentStep = null;
        SimTrans tr = this._sheduler.firing(null, true);
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    @Override
    public boolean setInitOfState(int i, String strValue) {
        State var = this._main.getState(i - 1);
        double value = var.getDomain().parse(strValue);
        if (Double.isNaN(value)) {
            return false;
        }
        var.getSimular().setInitValue(value);
        return true;
    }

    @Override
    public boolean setInitOfState(int i, double value) {
        State var = this._main.getState(i - 1);
        if (!var.getDomain().verifyValueOf(value)) {
            return false;
        }
        var.getSimular().setInitValue(value);
        return true;
    }

    @Override
    public boolean goForward(int i) throws StepperException {
        SimTrans tr = (SimTrans)this._transs.get(i - 1);
        if (!tr.isValid()) {
            if (this.withMonitoring(1)) {
                this.monitor("Exception : ");
                this.monitor(MsgTrans.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getEvent().getName()));
                this.monitor("\n");
            }
            throw new StepperViolatedAssertionException(MsgTrans.msgFormat("EXC_STEP_TRANSITION_NOT_VALID", tr.getEvent().getName()));
        }
        boolean first = true;
        while (tr != null) {
            tr = this.goForward(tr, first);
            first = false;
        }
        return true;
    }

    SimTrans goForward(SimTrans tr, boolean fire) throws StepperException {
        this._sheduler.canFire(tr);
        if (this.withMonitoring(6)) {
            this.monitor("goForward(" + tr.getEvent().getName() + ")\n");
        }
        this._currentStep = new SimulStep(10);
        this.incStep();
        tr.affect(this);
        if (this._loopModel) {
            if (this._simulLoopWithoutList) {
                if (tr.getOrderedParents().size() > 0) {
                    int firstIndex = tr.getOrderedParents().get(0).getIndex();
                    int lastIndex = tr.getOrderedParents().get(tr.getOrderedParents().size() - 1).getIndex();
                    for (Simular parentVar : tr.getOrderedParents()) {
                        parentVar.setFlag('C');
                    }
                    this.propageFixPointWithoutList(firstIndex, lastIndex);
                }
            } else {
                if (this._nextSimulStack.size() != 0) {
                    throw new StepperException("NextSimulStack not empty");
                }
                this._nextSimulStack.addAll(tr.getOrderedParents());
                this.propageLinkedFixPoint();
            }
        } else if (tr.getOrderedParents().size() > 0) {
            int firstIndex = tr.getOrderedParents().get(0).getIndex();
            int lastIndex = tr.getOrderedParents().get(tr.getOrderedParents().size() - 1).getIndex();
            for (Simular parentVar : tr.getOrderedParents()) {
                parentVar.setFlag('C');
            }
            this.propageAffectation(firstIndex, lastIndex);
        }
        this._stackStep.push(this._currentStep);
        this._currentStep = null;
        return this._sheduler.firing(tr, fire);
    }

    @Override
    public boolean goBackward(int nbrTrans) throws StepperException {
        try {
            while (nbrTrans-- > 0 && !this._stackStep.isEmpty()) {
                boolean next = true;
                while (next && !this._stackStep.isEmpty()) {
                    this.incStep();
                    SimulStep step = (SimulStep)this._stackStep.pop();
                    step.unplay();
                    next = this._sheduler.back();
                }
            }
            return !this._stackStep.isEmpty();
        }
        catch (StepperException exc) {
            exc.printStackTrace();
            return false;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeObject(this._domains);
        int size = this._states.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._states.get(i));
        }
        size = this._vars.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._vars.get(i));
        }
        out.writeObject(this._main);
        size = this._states.size();
        for (i = 0; i < size; ++i) {
            ((Simular)this._states.get(i)).writeAdditionalExternal(out);
        }
        size = this._vars.size();
        for (i = 0; i < size; ++i) {
            ((Simular)this._vars.get(i)).writeAdditionalExternal(out);
        }
        size = this._transs.size();
        out.writeInt(size);
        for (i = 0; i < size; ++i) {
            out.writeObject(this._transs.get(i));
        }
        out.writeInt(this._maxChange);
        out.writeBoolean(this._autoDeterminist);
        out.writeObject(this._sheduler);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this._domains = (DomainDefine)in.readObject();
        int size = in.readInt();
        this._states.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._states.add((Simular)in.readObject());
        }
        size = in.readInt();
        this._vars.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._vars.add((Simular)in.readObject());
        }
        this._main = (Node)in.readObject();
        size = this._states.size();
        for (i = 0; i < size; ++i) {
            ((Simular)this._states.get(i)).readAdditionalExternal(in);
        }
        size = this._vars.size();
        for (i = 0; i < size; ++i) {
            ((Simular)this._vars.get(i)).readAdditionalExternal(in);
        }
        size = in.readInt();
        this._transs.ensureCapacity(size);
        for (i = 0; i < size; ++i) {
            this._transs.add((SimTrans)in.readObject());
        }
        this._maxChange = in.readInt();
        this._autoDeterminist = in.readBoolean();
        this._sheduler = (Sheduler)in.readObject();
    }

    @Override
    protected void finalize() throws Throwable {
        if (this._vars != null) {
            this.dispose();
        }
        MsgTrans.LOG.finest("Finalize " + Simulator.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
        super.finalize();
    }

    @Override
    public void dispose() {
        MsgTrans.LOG.finest("Dispose " + Simulator.class.getSimpleName() + " " + Integer.toHexString(super.hashCode()));
        if (this._vars != null) {
            for (Simular sim : this._vars) {
                sim.dispose();
            }
            this._vars = null;
        }
        if (this._states != null) {
            for (Simular sim : this._states) {
                sim.dispose();
            }
            this._states = null;
        }
        if (this._transs != null) {
            for (SimTrans tr : this._transs) {
                tr.dispose();
            }
            this._transs = null;
        }
        if (this._sheduler != null) {
            this._sheduler.dispose();
            this._sheduler = null;
        }
        this._main = null;
        this._domains = null;
        if (this._monitoring != null) {
            this.setMonitoring(null, 1);
        }
    }

    class SimulStep {
        IdentityHashMap<Simular, Double> _map = new IdentityHashMap();

        SimulStep(int size) {
        }

        void add(Simular simvar, double val) {
            if (!this._map.containsKey(simvar)) {
                this._map.put(simvar, val);
            }
        }

        void unplay() {
            for (Map.Entry<Simular, Double> entry : this._map.entrySet()) {
                Simulator.this.changeValue(entry.getKey(), entry.getValue());
            }
        }
    }
}

