/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.lib.mbsa.translator.simul.jf;

import com.dassault.cecilia.lib.mbsa.Stepper;
import com.dassault.cecilia.lib.mbsa.StepperException;
import com.dassault.cecilia.lib.mbsa.stepper.CompilReader;
import com.dassault.cecilia.lib.mbsa.translator.simul.jf.JFSim;
import com.dassault.cecilia.lib.util.loader.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JFCompilReader
implements CompilReader {
    @Override
    public Stepper read(File compilFile) throws StepperException {
        JarClassLoader loader = new JarClassLoader(compilFile.getAbsolutePath(), JFSim.class.getClassLoader());
        return JFCompilReader.createInstance(loader);
    }

    @Override
    public Stepper read(InputStream compilStream) throws StepperException {
        JarClassLoader loader = new JarClassLoader(compilStream, JFSim.class.getClassLoader());
        return JFCompilReader.createInstance(loader);
    }

    public static JFSim createInstance(JarClassLoader loader) throws StepperException {
        try {
            String name = JFCompilReader.getMainName(loader);
            Class cl = loader.loadClass(name);
            Object obj = cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            JFSim result = (JFSim)obj;
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new StepperException(e.getClass().getName() + " - " + e.getMessage());
        }
    }

    private static String getMainName(JarClassLoader loader) throws IOException {
        String result;
        Attributes attrs;
        Manifest manifest = loader.getManifest();
        if (manifest != null && (attrs = manifest.getAttributes("JStepper")) != null && (result = attrs.getValue("JStepper-ClassName")) != null) {
            return result;
        }
        throw new IOException("No JStepper-ClassName in manifest");
    }
}

