/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core;

import java.io.IOException;

public class Util {
    public static String formatStringForXml(String comment) {
        if (comment == null) {
            return comment;
        }
        StringBuffer finalComment = new StringBuffer();
        for (int i = 0; i < comment.length(); ++i) {
            char c = comment.charAt(i);
            if (c == '&') {
                finalComment.append("&amp;");
                continue;
            }
            if (c == '<') {
                finalComment.append("&lt;");
                continue;
            }
            if (c == '>') {
                finalComment.append("&gt;");
                continue;
            }
            if (c == '\"') {
                finalComment.append("&quot;");
                continue;
            }
            if (c == '\n') {
                finalComment.append("&#10;");
                continue;
            }
            if (c == '\t') {
                finalComment.append("&#9;");
                continue;
            }
            if (c < ' ' || c >= '\u007f' && c <= '\u00a0' || c > '\u00ff') continue;
            finalComment.append(c);
        }
        return finalComment.toString();
    }

    public static Appendable appendForXml(Appendable output, String comment) throws IOException {
        if (comment == null) {
            return output;
        }
        int len = comment.length();
        block9: for (int i = 0; i < len; ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '&': {
                    output.append("&amp;");
                    continue block9;
                }
                case '<': {
                    output.append("&lt;");
                    continue block9;
                }
                case '>': {
                    output.append("&gt;");
                    continue block9;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block9;
                }
                case '\'': {
                    output.append("&apos;");
                    continue block9;
                }
                case '\n': {
                    output.append("&#10;");
                    continue block9;
                }
                case '\t': {
                    output.append("&#9;");
                    continue block9;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output;
    }

    public static Appendable appendForHtml(Appendable output, String comment) throws IOException {
        if (comment == null) {
            return output;
        }
        int len = comment.length();
        block8: for (int i = 0; i < len; ++i) {
            char c = comment.charAt(i);
            switch (c) {
                case '&': {
                    output.append("&amp;");
                    continue block8;
                }
                case '<': {
                    output.append("&lt;");
                    continue block8;
                }
                case '>': {
                    output.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    output.append("<BR>");
                    continue block8;
                }
                case '\t': {
                    output.append("&nbsp;&nbsp;&nbsp;&nbsp;");
                    continue block8;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output;
    }

    public static boolean checkFileNameForInvalidCaracter(String str) {
        if (str.contains("\\")) {
            return false;
        }
        if (str.contains("/")) {
            return false;
        }
        if (str.contains(":")) {
            return false;
        }
        if (str.contains("*")) {
            return false;
        }
        if (str.contains("?")) {
            return false;
        }
        if (str.contains("\"")) {
            return false;
        }
        if (str.contains("<")) {
            return false;
        }
        if (str.contains(">")) {
            return false;
        }
        return !str.contains("|");
    }

    public static String replaceInvalidCaractersInFileName(String str, char c) {
        str = str.replace('\\', c);
        str = str.replace('/', c);
        str = str.replace(':', c);
        str = str.replace('*', c);
        str = str.replace('?', c);
        str = str.replace('\"', c);
        str = str.replace('<', c);
        str = str.replace('>', c);
        str = str.replace('|', c);
        return str;
    }
}

