/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia;

import com.dassault.cecilia.core.ConfigException;
import com.dassault.cecilia.core.ConfigManager;
import com.dassault.cecilia.core.ConfigProperty;
import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CApplInit;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.dbgui.DBBaseEditDlg;
import com.dassault.cecilia.core.cecilia.dbgui.DBBaseSelectUtility;
import com.dassault.cecilia.core.cecilia.dbgui.DBLicenseUtility;
import com.dassault.cecilia.core.cecilia.dbgui.DBSessionLoginUtility;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.plugin.PlugableAppl;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.CeciliaMetalTheme;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import com.dassault.cecilia.db.DBLicense;
import com.dassault.cecilia.db.DBObjModel;
import com.dassault.cecilia.db.DBObject;
import com.dassault.cecilia.db.DBProperty;
import com.dassault.cecilia.db.DBSession;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOBuilder;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOFolder;
import com.dassault.cecilia.db.dao.DAOSession;
import com.dassault.cecilia.db.dao.DAOUser;
import com.dassault.cecilia.db.dao.sql.SQLConnection;
import com.dassault.cecilia.db.dao.sql.SQLConnectionList;
import com.dassault.cecilia.lib.util.format.StringUtilities;
import com.dassault.cecilia.main.admin.ResMsgAdmin;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.datatransfer.Clipboard;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class CAppl
extends CApplInit
implements PlugableAppl {
    private static Logger _LOG = Logger.getLogger(CAppl.class.getPackage().getName());
    protected SQLConnection _sqlConnect = null;
    protected DAOFactory _daoFactory;
    protected DBUser _dbUser;
    private byte[] COPYRIGHT = null;
    protected DBSession _dbSession;
    protected Object _dbSessionLock = new Object();
    protected Object _dbSessionValidator = new Object();
    protected Clipboard _clipboardFolder = new Clipboard("Folder");
    protected Clipboard _clipboardEdit = new Clipboard("Edit");
    protected PageFormat _pageFormat = null;
    private Object _pageFormatLock = new Object();
    protected File _tmpDirectory = null;
    public static final String PROP_DB_H2SELECT = "cecilia.db.h2select";
    public static final String PROP_DB_H2TMPFILE = "cecilia.db.h2tmpfile";
    ArrayList<DAOFolder.UpdateListener> _listeners = new ArrayList();
    RefreshDAOFolderUtility _refreshDAOFolderUtil = new RefreshDAOFolderUtility();

    public SQLConnection getSQLConnection() {
        return this._sqlConnect;
    }

    @Override
    public DAOFactory getDAOFactory() {
        return this._daoFactory;
    }

    @Override
    public DBUser getDBUser() {
        return this._dbUser;
    }

    public final DBSession getDBSession() {
        if (this.COPYRIGHT != null) {
            if (" Cecilia - Dassault Aviation ".equals(new String(this.COPYRIGHT))) {
                if (this._dbSessionValidator == null) {
                    this._dbSessionValidator = new Object();
                }
            } else if (this._dbSessionValidator != null) {
                this._dbSessionValidator = null;
                _LOG.info("Config.Key:false");
            }
        }
        return this._dbSession;
    }

    public final boolean isDBSessionValid() {
        return this._dbSessionValidator != null;
    }

    public final void setDBSession(Object dbSession) {
        this._dbSessionValidator = dbSession;
    }

    public Clipboard getLocalClipboard(boolean dbFolder) {
        if (dbFolder) {
            return this._clipboardFolder;
        }
        return this._clipboardEdit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageFormat getPageFormat() {
        if (this._pageFormat == null) {
            Object object = this._pageFormatLock;
            synchronized (object) {
                PageFormat pf = PrinterJob.getPrinterJob().defaultPage();
                Paper pp = pf.getPaper();
                double dx = (pp.getWidth() - pp.getImageableWidth()) / 2.0;
                double dy = (pp.getHeight() - pp.getImageableHeight()) / 2.0;
                pp.setImageableArea(pp.getImageableX() - dx / 2.0, pp.getImageableY() - dy / 2.0, pp.getImageableWidth() + dx, pp.getImageableHeight() + dy);
                pf.setPaper(pp);
                if (this._pageFormat == null) {
                    this._pageFormat = pf;
                }
            }
        }
        return this._pageFormat;
    }

    public void setPageFormat(PageFormat pf) {
        this._pageFormat = pf;
    }

    public File getTmpDirectory() {
        return this._tmpDirectory;
    }

    @Override
    public boolean isReader() {
        return false;
    }

    public abstract Preferencies getPreferencies();

    public abstract ImageIcon getSplashIcon();

    public abstract List<? extends Image> getIcons();

    public CAppl() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                _LOG.log(Level.SEVERE, "UncaughtException", e);
            }
        });
    }

    public void init(StringBuffer logBuffer) {
        this.initTheme();
        this.writeLogFileHeader(logBuffer);
        this.verifyTmpDirectory();
    }

    public void initTheme() {
        try {
            String classUI = UIManager.getSystemLookAndFeelClassName();
            String lookAndFeel = System.getProperty("cecilia.gui.lookandfeel");
            if (lookAndFeel != null) {
                if (lookAndFeel.equalsIgnoreCase("Windows")) {
                    classUI = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                } else if (lookAndFeel.equalsIgnoreCase("Motif")) {
                    classUI = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                } else if (lookAndFeel.equalsIgnoreCase("Cecilia")) {
                    classUI = "javax.swing.plaf.metal.MetalLookAndFeel";
                    MetalLookAndFeel.setCurrentTheme(new CeciliaMetalTheme());
                } else {
                    classUI = "";
                }
            }
            UIManager.setLookAndFeel(classUI);
            Class<?> classGTKLnF = null;
            try {
                classGTKLnF = CAppl.class.getClassLoader().loadClass("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (classGTKLnF != null && classGTKLnF.isInstance(UIManager.getLookAndFeel())) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void verifyTmpDirectory() {
        try {
            File tempFile = File.createTempFile("file", "tmp");
            tempFile.deleteOnExit();
            if (!tempFile.canWrite()) {
                this.fatalError(ResMsgCore.getString("FILE_TMPDIR_CAN_NOT_WRITE"), ResMsgVoc.getString("VOC_ERROR"), true, true);
            } else {
                this._tmpDirectory = tempFile.getParentFile();
                tempFile.delete();
            }
        }
        catch (IOException ex) {
            this.fatalError(ResMsgCore.getString("FILE_TMPDIR_CAN_NOT_WRITE"), ResMsgVoc.getString("VOC_ERROR"), true, true);
        }
    }

    private void writeLogFileHeader(StringBuffer logBuffer) {
        _LOG.info("______________________________________________________________________________");
        _LOG.info("Cecilia WorkShop - V6.3.1 - 2025-12-16 - (c) DASSAULT AVIATION");
        _LOG.info(new Date(System.currentTimeMillis()).toString());
        _LOG.fine("OS.Name:" + System.getProperty("os.name"));
        _LOG.fine("OS.Arch:" + System.getProperty("os.arch"));
        _LOG.fine("JVM.Version:" + System.getProperty("java.version"));
        _LOG.fine("JVM.Arch:" + ConfigProperty.getJVMArch());
        _LOG.fine("JVM.Home:" + System.getProperty("java.home"));
        _LOG.fine("File.Encoding:" + System.getProperty("file.encoding"));
        StringTokenizer tokenizer = new StringTokenizer(logBuffer.toString(), "\n");
        while (tokenizer.hasMoreTokens()) {
            _LOG.info(tokenizer.nextToken());
        }
    }

    public boolean standardDatabaseConnection() {
        File file;
        if (Boolean.getBoolean(PROP_DB_H2SELECT) && (file = this.selectH2File()) != null) {
            HashMap<String, String> mapConnection = new HashMap<String, String>();
            mapConnection.put("db.h2.file", file.getAbsolutePath());
            SQLConnection sqlConnect = new SQLConnection(SQLConnection.DBType.H2, mapConnection);
            sqlConnect.setName("[H2Select]");
            if (this.createConnection(sqlConnect, true)) {
                this._sqlConnect = sqlConnect;
                return true;
            }
        }
        String dbData = System.getProperty("cecilia.db.Datafile", "./database.ini");
        SQLConnectionList connects = new SQLConnectionList(new File(dbData));
        try {
            connects.loadDataConnections();
            connects.changeBeforeUse();
        }
        catch (IOException e) {
            _LOG.log(Level.WARNING, "SQLConnectionList(" + dbData + ").loadDataConnections() fails", e);
        }
        DBBaseSelectUtility utility = new DBBaseSelectUtility(connects, this.getTopWindow() == null){

            @Override
            protected ImageIcon getBackgroundIcon() {
                return CAppl.this.getSplashIcon();
            }

            @Override
            protected List<? extends Image> getImageIcons() {
                return CAppl.this.getIcons();
            }
        };
        while (this._sqlConnect == null) {
            this._daoFactory = null;
            SQLConnection sqlConnect = utility.selectConnection();
            if (sqlConnect == null) {
                return false;
            }
            if (this.createConnection(sqlConnect, sqlConnect.isDataBaseNode())) {
                this._sqlConnect = sqlConnect;
                continue;
            }
            if (!sqlConnect.isUnique()) continue;
            return false;
        }
        return true;
    }

    private File selectH2File() {
        File pdir;
        JFileChooser dlgChoose = new JFileChooser(){

            @Override
            protected JDialog createDialog(Component parent) throws HeadlessException {
                JDialog result = super.createDialog(parent);
                List<? extends Image> icons = CAppl.this.getIcons();
                if (icons != null) {
                    result.setIconImages(icons);
                }
                return result;
            }
        };
        FileFilterExtention defaultFilter = new FileFilterExtention(ResMsgCore.getString("FILE_TYPE_H2"), ".mv.db");
        dlgChoose.addChoosableFileFilter(defaultFilter);
        dlgChoose.setFileFilter(defaultFilter);
        File dir = new File(".");
        String property = System.getProperty("cecilia.core.LicensePath");
        if (property != null && !(pdir = new File(property)).isDirectory()) {
            dir = pdir;
        }
        try {
            dlgChoose.setCurrentDirectory(dir);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dlgChoose.showOpenDialog(null) == 0) {
            File file = dlgChoose.getSelectedFile();
            if (file.exists()) {
                return file;
            }
            file = FileFilterExtention.addDefaultExtention(dlgChoose);
            if (file.exists()) {
                return file;
            }
            try {
                DBBaseEditDlg.copyDatabaseToFile(file, "Base.mv.db");
                return file;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (Boolean.getBoolean(PROP_DB_H2TMPFILE)) {
            try {
                File tmpFile = File.createTempFile("CeciliaTmpH2", ".mv.db");
                tmpFile.deleteOnExit();
                DBBaseEditDlg.copyDatabaseToFile(tmpFile, "Base.mv.db");
                return tmpFile;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return null;
    }

    protected boolean createConnection(SQLConnection sqlConnect, boolean addLicense) {
        block15: {
            try {
                sqlConnect.createConnection();
            }
            catch (SQLException e) {
                this.fatalError("Exception during create DB connection: " + sqlConnect.getConnectionUrl(), "Internal error", false, false);
                _LOG.log(Level.FINE, "Create DB connection exception", e);
                break block15;
            }
            _LOG.info("DBConnect: " + sqlConnect.getConnectionUrl() + "#" + sqlConnect.getLogin());
            this._daoFactory = new DAOBuilder().setSQLConnection(sqlConnect).createFactory();
            if (this._daoFactory == null) {
                this.displayMsg("No DAOFactory for database: " + sqlConnect.getConnectionUrl(), this.getTitle() + " - Internal error", 0);
            } else if (!this.verifySchema()) {
                this.displayMsg(ResMsgCore.msgFormat("DLG_DBCHANGE_ERR_SCHEMA", sqlConnect.getConnectionUrl()), this.getTitle(), 0);
            } else {
                StringBuffer msgLicense = new StringBuffer();
                boolean checkLicense = this.verifyLicense(msgLicense);
                if (!checkLicense && addLicense && this._topWindow != null) {
                    while (JOptionPane.showConfirmDialog(this._topWindow, ResMsgCore.getString("DLG_DBCHANGE_ADD_LICENSE"), this.getTitle(), 0) != 1) {
                        DBLicense license = null;
                        try {
                            license = DBLicenseUtility.selectLicense(this._topWindow);
                        }
                        catch (IOException e) {
                            _LOG.log(Level.INFO, "Error during load license file", e);
                            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._topWindow), ResMsgAdmin.getString((String)"MSG_LIC_BAD_FILE"), this.getTitle(), 0);
                        }
                        if (license != null) {
                            if (!this._daoFactory.createLicenseDAO().insert(license)) {
                                JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(this._topWindow), ResMsgAdmin.getString((String)"MSG_LIC_ERR_INSERT"), this.getTitle(), 0);
                            } else {
                                msgLicense = new StringBuffer();
                                checkLicense = this.verifyLicense(msgLicense);
                            }
                        }
                        if (!checkLicense) continue;
                    }
                }
                if (msgLicense.length() > 0) {
                    this.displayMsg(msgLicense.toString(), this.getTitle(), checkLicense ? 0 : 2);
                }
                if (checkLicense) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean verifySchema() {
        if (this._daoFactory == null) {
            throw new NullPointerException();
        }
        DBProperty prop = this._daoFactory.createPropertyDAO().find("version");
        if (prop == null) {
            return false;
        }
        Matcher match = Pattern.compile("(\\d+).(\\d+)").matcher(prop.getValue());
        if (!match.find()) {
            return false;
        }
        if (Integer.parseInt(match.group(1)) != 6) {
            return false;
        }
        if (Integer.parseInt(match.group(2)) != 0) {
            return false;
        }
        DAOFolder daoFolder = this._daoFactory.createFolderDAO();
        DBFolder root = daoFolder.getRootID("ROOT");
        if (root == null) {
            _LOG.log(Level.WARNING, "Le dossier 'ROOT' n'a pas pu \u00eatre charg\u00e9.");
            return false;
        }
        _LOG.log(Level.FINE, "ID du dossier racine : " + root.getID());
        return true;
    }

    public boolean verifyMigration60() {
        if (this._daoFactory == null) {
            throw new NullPointerException();
        }
        DAOFolder daoFolder = this._daoFactory.createFolderDAO();
        int nbrModel = 0;
        int nbrMigr = 0;
        ArrayList<DBFolder> set = new ArrayList<DBFolder>();
        set.add(daoFolder.getRootID("COMPONENT_FAMILIES"));
        set.add(daoFolder.getRootID("PROJECTS"));
        while (!set.isEmpty() && nbrModel < 20) {
            DBFolder dbFolder = (DBFolder)set.remove(set.size() - 1);
            DBObject dbObject = dbFolder.getObject();
            if (dbObject != null) {
                ++nbrModel;
                for (DBObjModel dbModel : dbObject.getModels()) {
                    if (!dbModel.getFormat().equals("ZML")) continue;
                    ++nbrMigr;
                    break;
                }
            }
            if (dbFolder.isVersion()) continue;
            List<DBFolder> children = dbFolder.getChildren();
            if (children == null) {
                children = daoFolder.findChildren(dbFolder);
            }
            set.addAll(children);
        }
        if (nbrModel > 0 && (double)nbrMigr / (double)nbrModel < 0.1) {
            if (this.getTopWindow() == null) {
                _LOG.warning("La base de donn\u00e9es a des flux de donn\u00e9es qui n'ont pas \u00e9t\u00e9 migr\u00e9s.");
            } else {
                int result = JOptionPane.showConfirmDialog(this.getTopWindow(), ResMsgCore.getString("MSG_ERR_DB_MIGRATION_FLOW_KO"), this.getTitle(), 0, 3);
                if (result != 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean verifyLicense(StringBuffer msgLicense) {
        if (ConfigManager.getVersion() != ConfigManager.TypeVersion.DA) {
            return true;
        }
        DBLicense lic = this._daoFactory.createLicenseDAO().find(this.getModuleName());
        if (lic == null) {
            msgLicense.append(ResMsgCore.getString("LICENSE_ERR_NOT_FOUND"));
            return false;
        }
        if (!lic.getVersion().equals(DBLicense.getAllVersion()) && !lic.isCompatible(this.getVersion())) {
            msgLicense.append(ResMsgCore.getString("LICENSE_ERR_VERSION"));
            return false;
        }
        if (lic.getToken() != DBLicense.getUnlimitedToken()) {
            int nbrConnection = this._daoFactory.createLicenseDAO().getCountConnection();
            if (lic.getToken() < nbrConnection) {
                msgLicense.append(ResMsgCore.getString("LICENSE_ERR_CONNECT_NBR"));
                return false;
            }
        }
        if (!lic.getExpire().equals(DBLicense.getAlwaysDate())) {
            Calendar currentDate = Calendar.getInstance();
            if (currentDate.getTime().after(lic.getExpire())) {
                msgLicense.append(ResMsgCore.getString("LICENSE_ERR_CONNECT_DATE"));
                return false;
            }
            currentDate.setTimeInMillis(currentDate.getTimeInMillis() + 604800000L);
            if (currentDate.getTime().after(lic.getExpire())) {
                msgLicense.append(ResMsgCore.getString("LICENSE_WARNING_DATE") + DateFormat.getDateInstance().format(lic.getExpire()));
            }
        }
        return true;
    }

    public boolean standardUserLogin(boolean onlyAdmin, boolean withoutDlg) {
        DBSessionLoginUtility loginUtil = new DBSessionLoginUtility(this, this._daoFactory);
        loginUtil.setOnlyAdmin(onlyAdmin).setWithoutDlg(withoutDlg);
        this._dbUser = loginUtil.selectUser();
        return this._dbUser != null;
    }

    public boolean standardUserLoginForDemo() {
        DBUser user;
        this._dbUser = null;
        DAOUser daoUser = this._daoFactory.createUserDAO();
        Collection<DBUser> users = daoUser.findAll();
        if (users.size() == 1 && "admin".equals((user = users.iterator().next()).getLogin()) && user.isAdmin()) {
            this._dbUser = user;
        }
        return this._dbUser != null;
    }

    public boolean openSession() {
        DAOSession daoSession = this._daoFactory.createSessionDAO();
        DBSession session = new DBSession().setModule(this.getModuleName()).setUser(this._dbUser);
        this._dbSession = daoSession.create(session);
        if (this._dbSession != null) {
            this._dbSession.setCurrent();
            TimerTask task = this.getUpdateSessionTask();
            if (task != null) {
                this.addShedulerTask(task, 5000L, 30000L);
            }
            if ((task = this.getRefreshFolderTask()) != null) {
                this.addShedulerTask(task, 60000L, 60000L);
            }
            int nbrDeleteSession = 0;
            Collection<DBSession> othersSessions = daoSession.findAll(this._dbUser);
            for (DBSession dbSession : othersSessions) {
                if (dbSession.isActive()) continue;
                if (!daoSession.delete(dbSession)) {
                    _LOG.warning("Impossible de supprimer une ancienne session : " + dbSession);
                    continue;
                }
                ++nbrDeleteSession;
            }
            if (nbrDeleteSession > 0) {
                _LOG.warning("Il y avait des sessions expiree (n=" + nbrDeleteSession + ") pour l'utilisater courant (" + this._dbUser.getLogin() + ")");
                this.refreshDAOFolder(true);
            }
        }
        return this._dbSession != null;
    }

    protected TimerTask getUpdateSessionTask() {
        return new UpdateSessionThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeSession() {
        if (this._dbSession == null) {
            return false;
        }
        DAOSession daoSession = this._daoFactory.createSessionDAO();
        boolean result = false;
        Object object = this._dbSessionLock;
        synchronized (object) {
            result = daoSession.delete(this._dbSession);
            if (result) {
                this._dbSession = null;
            }
        }
        return result;
    }

    @Override
    public void addFolderUpdateListener(DAOFolder.UpdateListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removeFolderUpdateListener(DAOFolder.UpdateListener listener) {
        this._listeners.remove(listener);
    }

    protected final TimerTask getRefreshFolderTask() {
        return this._refreshDAOFolderUtil;
    }

    @Override
    public void refreshDAOFolder() {
        this.refreshDAOFolder(true);
    }

    public void refreshDAOFolder(boolean now) {
        TimerTask refreshThread = this.getRefreshFolderTask();
        if (refreshThread != null) {
            if (!now) {
                SwingUtilities.invokeLater(refreshThread);
            } else if (refreshThread instanceof RefreshDAOFolderUtility && ((RefreshDAOFolderUtility)refreshThread)._bDoRun) {
                SwingUtilities.invokeLater(refreshThread);
            } else {
                refreshThread.run();
            }
        }
    }

    @Override
    public void refreshFolders(boolean bOnlyProject) {
        this._refreshDAOFolderUtil.refreshAll();
    }

    @Override
    public void close() {
        if (this._dbSession != null && !this.closeSession()) {
            _LOG.info("DBSession not close !");
        }
        if (this.getDAOFactory() != null) {
            this.getDAOFactory().logStats();
        }
        super.close();
    }

    public void stopApplication() {
        this._dbSessionValidator = null;
    }

    class RefreshDAOFolderUtility
    extends TimerTask
    implements DAOFolder.UpdateListener {
        boolean _bDoRun = false;
        int cptBroken = 0;

        RefreshDAOFolderUtility() {
        }

        @Override
        public synchronized void run() {
            if (this._bDoRun) {
                return;
            }
            try {
                this._bDoRun = true;
                _LOG.finer("RefreshDAOFolderUtility::run()");
                CAppl.this._daoFactory.createFolderDAO().updateCache(this);
                if (ConfigManager.getVersion() == ConfigManager.TypeVersion.STD && ConfigManager.getInstance().isValid()) {
                    CAppl.this.COPYRIGHT = StringUtilities.convertHexaStringToByte((String)"878e3dba5611968d659281ee1709c1b1fa897eff13e2f7137005dbce07");
                    ConfigManager.getInstance().decrypt(CAppl.this.COPYRIGHT);
                }
            }
            catch (ConfigException e) {
                CAppl.this._dbSessionValidator = null;
                ++this.cptBroken;
                if (this.cptBroken % 100 == 1) {
                    _LOG.info("Config.Session=Brocken");
                }
            }
            catch (Throwable th) {
                _LOG.log(Level.WARNING, "Exception in thread \"Cecilia-Update\" during DAOFolder.updateCache", th);
            }
            finally {
                this._bDoRun = false;
            }
        }

        @Override
        public void changeBegin() {
            for (int i = CAppl.this._listeners.size() - 1; i >= 0; --i) {
                CAppl.this._listeners.get(i).changeBegin();
            }
        }

        @Override
        public boolean changeState(DBFolder dbFolder) {
            boolean result = false;
            for (int i = CAppl.this._listeners.size() - 1; i >= 0; --i) {
                if (dbFolder.getAccesses() == null) {
                    CAppl.this.getDAOFactory().createFolderDAO().findAccesses(dbFolder);
                }
                result |= CAppl.this._listeners.get(i).changeState(dbFolder);
            }
            return result;
        }

        @Override
        public void changeStateAndChildren(DBFolder dbFolder, List<DBFolder> delChildren) {
            for (int i = CAppl.this._listeners.size() - 1; i >= 0; --i) {
                if (dbFolder.getAccesses() == null) {
                    CAppl.this.getDAOFactory().createFolderDAO().findAccesses(dbFolder);
                }
                CAppl.this._listeners.get(i).changeStateAndChildren(dbFolder, delChildren);
            }
        }

        @Override
        public void changeEnd() {
            for (int i = CAppl.this._listeners.size() - 1; i >= 0; --i) {
                CAppl.this._listeners.get(i).changeEnd();
            }
        }

        @Override
        public void refreshAll() {
            for (int i = CAppl.this._listeners.size() - 1; i >= 0; --i) {
                CAppl.this._listeners.get(i).refreshAll();
            }
        }
    }

    class UpdateSessionThread
    extends TimerTask {
        int nbrError = 0;

        UpdateSessionThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (CAppl.this._dbSession == null || this.nbrError >= 5) {
                return;
            }
            Object object = CAppl.this._dbSessionLock;
            synchronized (object) {
                if (CAppl.this._dbSession == null) {
                    return;
                }
                _LOG.finer("UpdateSessionThread::run()");
                CAppl.this._dbSession.updateExpire();
                if (!CAppl.this._daoFactory.createSessionDAO().update(CAppl.this._dbSession)) {
                    _LOG.log(++this.nbrError >= 5 ? Level.SEVERE : Level.INFO, "Not update DBSession for current user: " + CAppl.this._dbSession.getUser().getLogin() + " [NbrError:" + this.nbrError + "]");
                } else {
                    _LOG.finest("Update current session : " + CAppl.this._dbSession.getUser().getLogin() + ", " + CAppl.this._dbSession.getExpireDate());
                    this.nbrError = 0;
                }
            }
        }
    }
}

