/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;

public class LaunchIniReader {
    public static String currentLaunchInputFile = "";
    public static String currentLaunchInputFileMemo = "";
    public static String currentLaunchProperty = "";
    public static String currentPropertyFile = "";

    public static void initLaunchIni(String includeModule, StringBuffer logBuffer) {
        try {
            currentLaunchInputFile = ".bat";
            Properties props = System.getProperties();
            Enumeration<Object> keys = props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!LaunchIniReader.isIncludeProperty(key, includeModule)) continue;
                currentLaunchProperty = key;
                currentPropertyFile = props.getProperty(key).trim();
                LaunchIniReader.readLaunchIni(currentPropertyFile, includeModule);
            }
            currentLaunchInputFile = ".bat";
            String launchIni = System.getProperty("cecilia.launch");
            if (launchIni != null) {
                currentLaunchProperty = "cecilia.launch";
                currentPropertyFile = launchIni;
                LaunchIniReader.readLaunchIni(launchIni, includeModule);
            }
        }
        catch (Exception excep) {
            excep.printStackTrace();
            String dOption = "";
            if (currentLaunchInputFile.equals(".bat")) {
                dOption = "-D";
            }
            JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(null), ResMsgCore.getString("LAUNCH_INI_NOT_FOUND_1") + " \"" + currentPropertyFile + "\"\n    - " + ResMsgCore.getString("LAUNCH_INI_NOT_FOUND_2") + " \"" + dOption + currentLaunchProperty + "\"\n    - " + ResMsgCore.getString("LAUNCH_INI_NOT_FOUND_3") + " \"" + currentLaunchInputFile + "\"", ResMsgVoc.getString("VOC_ERROR"), 0);
            System.exit(0);
        }
        Locale defaultLocale = Locale.getDefault();
        Locale.setDefault(new Locale(System.getProperty("user.language", "en"), defaultLocale.getCountry(), defaultLocale.getVariant()));
        String ceciliaHome = System.getProperty("cecilia.home");
        if (ceciliaHome != null) {
            File tgtDir = new File(ceciliaHome);
            if (tgtDir.exists()) {
                if (!tgtDir.isDirectory()) {
                    logBuffer.append("'").append(tgtDir).append("' is not directory.\n");
                }
            } else if (!tgtDir.mkdirs()) {
                logBuffer.append("Error during create '").append(tgtDir).append("' directory.\n");
            }
            if (tgtDir.exists() && tgtDir.isDirectory()) {
                File file = new File(tgtDir, "Tmp");
                if (file.exists() ? !file.isDirectory() : !file.mkdir()) {
                    logBuffer.append("Error during create '").append(tgtDir).append("/Tmp' directory.\n");
                }
                if ((file = new File(tgtDir, "Log")).exists() ? !file.isDirectory() : !file.mkdir()) {
                    logBuffer.append("Error during create '").append(tgtDir).append("/Log' directory.\n");
                }
                if ((file = new File(tgtDir, "Distrib")).exists() ? !file.isDirectory() : !file.mkdir()) {
                    logBuffer.append("Error during create '").append(tgtDir).append("/Distrib' directory.\n");
                }
            }
        }
    }

    public static void readLaunchIni(String iniFile, String includeModule) throws Exception {
        String javaDir;
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(iniFile);
        props.load(fis);
        fis.close();
        currentLaunchInputFile = iniFile;
        Enumeration<?> values = props.propertyNames();
        String homeDir = System.getProperty("user.home");
        if (homeDir != null) {
            homeDir = homeDir.replace('\\', '/');
        }
        if ((javaDir = System.getProperty("java.home")) != null) {
            javaDir = javaDir.replace('\\', '/');
        }
        while (values.hasMoreElements()) {
            String key = (String)values.nextElement();
            String value = props.getProperty(key).trim();
            currentLaunchProperty = key;
            currentPropertyFile = value;
            if (value.equals("")) continue;
            if (LaunchIniReader.isIncludeProperty(key, includeModule)) {
                LaunchIniReader.readLaunchIni(value, includeModule);
                continue;
            }
            if (LaunchIniReader.isPathProperty(key)) {
                if (value.indexOf(37) != -1) {
                    if (homeDir != null && value.indexOf("%h") != -1) {
                        value = value.replaceAll("%h", homeDir);
                    }
                    if (javaDir != null && value.indexOf("%j") != -1) {
                        value = value.replaceAll("%j", javaDir);
                    }
                    if (value.indexOf("%%") != -1) {
                        value = value.replaceAll("%%", "%");
                    }
                }
                System.setProperty(key, value);
                continue;
            }
            System.setProperty(key, value);
        }
    }

    private static boolean isIncludeProperty(String name, String module) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.startsWith("cecilia.include.")) {
            return true;
        }
        return module != null && name.startsWith("cecilia.include-" + module);
    }

    private static boolean isPathProperty(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.equals("java.io.tmpdir")) {
            return true;
        }
        if (name.equals("cecilia.home")) {
            return true;
        }
        if (name.equals("cecilia.db.Datafile")) {
            return true;
        }
        return name.indexOf(".path") != -1;
    }
}

