/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.action;

import com.dassault.cecilia.core.swing.CeciliaAction;
import com.dassault.cecilia.lib.util.collection.IdentityHashSet;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class DelegateAction
extends CeciliaAction {
    private static Logger _LOG = Logger.getLogger(DelegateAction.class.getPackage().getName());
    IdentityHashSet<AbstractAction> _delegators = new IdentityHashSet();
    AbstractAction _lastAction;

    public DelegateAction(String name) {
        super(name);
    }

    public DelegateAction(Icon icon, String strMenu) {
        super(icon, strMenu);
    }

    public DelegateAction(Icon icon, String strMenu, String strTooltip) {
        super(icon, strMenu, strTooltip);
    }

    public DelegateAction(String name, Icon icon, String desc, int mnemo, KeyStroke keyStroke) {
        super(name, icon, desc, mnemo, keyStroke);
    }

    public DelegateAction addDelegate(AbstractAction action) {
        this._delegators.add((Object)action);
        this._lastAction = action;
        return this;
    }

    public DelegateAction delDelegate(AbstractAction action) {
        if (!this._delegators.remove((Object)action)) {
            _LOG.warning("Delete unknown delegator '" + this.getValue("Name") + "': [" + action.toString() + "]");
        }
        if (this._lastAction == action) {
            this._lastAction = null;
        }
        return this;
    }

    private AbstractAction getCurrentAction() {
        switch (this._delegators.size()) {
            case 1: {
                return (AbstractAction)this._delegators.iterator().next();
            }
            case 0: {
                _LOG.finest("None delegator for '" + this.getValue("Name") + "'");
                break;
            }
            default: {
                _LOG.finest("Multi delegator for '" + this.getValue("Name") + "': " + this._delegators.toString());
            }
        }
        if (this._lastAction != null) {
            return this._lastAction;
        }
        _LOG.warning("No Last delegator for '" + this.getValue("Name") + "': " + this._delegators.toString());
        return null;
    }

    public void setEnabled(AbstractAction action, boolean newValue) {
        if (this.getCurrentAction() == action) {
            super.setEnabled(newValue);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractAction current = this.getCurrentAction();
        if (current != null) {
            current.actionPerformed(e);
        }
    }
}

