/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.action;

import com.dassault.cecilia.core.cecilia.action.UndoItem;
import java.util.logging.Logger;

public class UndoManager {
    private static Logger _LOG = Logger.getLogger(UndoManager.class.getPackage().getName());
    UndoItem[] _undos;
    int _limit;
    int _cur;
    int _beg;
    int _end;
    boolean _undoable;
    boolean _redoable;
    boolean _cleared;

    public UndoManager(int limit) {
        this._undos = new UndoItem[limit];
        this._limit = limit;
        this._cleared = false;
        this.clear();
    }

    public void clear() {
        for (int i = 0; i < this._limit; ++i) {
            this._undos[i] = null;
        }
        this._end = -1;
        this._beg = -1;
        this._cur = -1;
        this._redoable = false;
        this._undoable = false;
        this._cleared = true;
    }

    public boolean undoable() {
        return this._undoable;
    }

    public boolean redoable() {
        return this._redoable;
    }

    public void undo() {
        if (!this._undoable) {
            return;
        }
        UndoItem item = this._undos[this._cur];
        _LOG.finer("UnDo : " + item.getClass().getName());
        item.undo();
        if (this._cleared) {
            return;
        }
        if (this._cur == this._beg) {
            this._undoable = false;
        }
        this._redoable = true;
        this._cur = this.previous(this._cur);
    }

    public void redo() {
        if (!this._redoable) {
            return;
        }
        this._cur = this.next(this._cur);
        UndoItem item = this._undos[this._cur];
        _LOG.finer("ReDo : " + item.getClass().getName());
        item.redo();
        if (this._cleared) {
            return;
        }
        if (this._cur == this._end) {
            this._redoable = false;
        }
        this._undoable = true;
    }

    public UndoItem removeLastCmd() {
        if (!this._undoable) {
            return null;
        }
        UndoItem cmd = this._undos[this._cur];
        this._end = this._cur = this.previous(this._cur);
        this._redoable = false;
        return cmd;
    }

    public void addCmd(UndoItem cmd) {
        if (this._beg == -1) {
            this._end = 0;
            this._cur = 0;
            this._beg = 0;
            this._undos[this._cur] = cmd;
        } else if (!this._undoable) {
            this.clear();
            this._end = 0;
            this._cur = 0;
            this._beg = 0;
            this._undos[this._cur] = cmd;
        } else {
            while (this._end != this._cur) {
                this._undos[this._end] = null;
                this._end = this.previous(this._end);
            }
            this._end = this._cur = this.next(this._cur);
            if (this._end == this._beg) {
                this._undos[this._end] = null;
                this._beg = this.next(this._beg);
            }
            this._undos[this._cur] = cmd;
        }
        this._undoable = true;
        this._redoable = false;
        this._cleared = false;
    }

    private int next(int idx) {
        if (idx < this._limit - 1) {
            return idx + 1;
        }
        return 0;
    }

    private int previous(int idx) {
        if (idx == 0) {
            return this._limit - 1;
        }
        return idx - 1;
    }

    String traceJUnit() {
        int i;
        StringBuilder sb = new StringBuilder(this._limit * 10);
        sb.append("[");
        block5: for (i = 0; i < this._limit; ++i) {
            UndoItem item;
            if (i > 0) {
                sb.append("|");
            }
            if ((item = this._undos[i]) == null) {
                sb.append("   ");
                continue;
            }
            String msg = item.toString();
            switch (msg.length()) {
                case 0: {
                    sb.append(" X ");
                    continue block5;
                }
                case 1: {
                    sb.append(" ").append(msg).append(" ");
                    continue block5;
                }
                case 2: {
                    sb.append(msg).append(" ");
                    continue block5;
                }
                default: {
                    sb.append(msg.substring(0, 3));
                }
            }
        }
        sb.append("]\n");
        sb.append(this._undoable ? "u" : " ");
        for (i = 0; i < this._limit; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(this._beg == i ? "b" : " ");
            sb.append(this._cur == i ? "c" : " ");
            sb.append(this._end == i ? "e" : " ");
        }
        sb.append(this._redoable ? "r" : " ");
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._limit + 16);
        sb.append(this._undoable ? "<" : "[");
        for (int i = 0; i < this._limit; ++i) {
            sb.append(this._undos[i] == null ? " " : "X");
        }
        sb.append(this._redoable ? ">" : "]");
        sb.append(";").append(this._beg);
        sb.append(";").append(this._cur);
        sb.append(";").append(this._end);
        return sb.toString();
    }

    public void debugTrace(StringBuilder out) {
        if (this._beg == -1) {
            out.append("<>");
        } else {
            int idx = 1;
            int cur = this._beg;
            if (!this._undoable) {
                out.append("--<.>\n");
            }
            boolean stop = false;
            while (!stop) {
                if (idx < 10) {
                    out.append(" ");
                }
                out.append(idx).append(" ");
                this._undos[cur].debugTrace(out);
                out.append("\n");
                if (this._undoable && cur == this._cur) {
                    out.append("--<.>\n");
                }
                cur = cur < this._limit - 1 ? ++cur : 0;
                if (this._beg <= this._end) {
                    if (cur == 0 && this._beg < this._end) {
                        stop = true;
                    } else if (cur > this._end) {
                        stop = true;
                    }
                } else if (cur <= this._beg && cur > this._end) {
                    stop = true;
                }
                ++idx;
            }
        }
    }
}

