/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.dbgui;

import com.dassault.cecilia.core.ResMsgVoc;
import com.dassault.cecilia.core.cecilia.CAppl;
import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.user.UserFromDBUser;
import com.dassault.cecilia.core.cecilia.user.UserSelectDlg;
import com.dassault.cecilia.db.DBUser;
import com.dassault.cecilia.db.dao.DAOFactory;
import com.dassault.cecilia.db.dao.DAOUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

public class DBSessionLoginUtility {
    static Logger LOG = Logger.getLogger(DBSessionLoginUtility.class.getPackage().getName());
    CAppl _appl;
    DAOFactory _daoFactory;
    boolean _withoutDlg = false;
    boolean _onlyAdmin = false;
    public static final String DB_IDENT_DEFAULT = "ALWAYS";
    public static final String PROP_DB_IDENT = "cecilia.db.Identify";

    public DBSessionLoginUtility(CAppl appl, DAOFactory daoFactory) {
        this._appl = appl;
        this._daoFactory = daoFactory;
    }

    public DBSessionLoginUtility setWithoutDlg(boolean withoutDlg) {
        this._withoutDlg = withoutDlg;
        return this;
    }

    public DBSessionLoginUtility setOnlyAdmin(boolean onlyAdmin) {
        this._onlyAdmin = onlyAdmin;
        return this;
    }

    private DBUser selectUserWithDlg(String defaultUser) {
        ArrayList<UserFromDBUser> dlgUsers = new ArrayList<UserFromDBUser>(10);
        DAOUser daoUser = this._daoFactory.createUserDAO();
        Collection<DBUser> dbUsers = daoUser.findAll();
        for (DBUser dbUser : dbUsers) {
            boolean isAdmin = dbUser.isAdmin();
            if (this._onlyAdmin && !isAdmin) continue;
            dlgUsers.add(new UserFromDBUser(dbUser));
        }
        if (dlgUsers.size() == 0) {
            LOG.severe("No users in database of application");
            return null;
        }
        UserSelectDlg dlg = new UserSelectDlg(null);
        dlg.setIconImages(this._appl.getIcons());
        dlg.setUsers(dlgUsers);
        dlg.setDefaultUser(defaultUser);
        if (dlg.showDialog()) {
            return ((UserFromDBUser)dlg.getUser()).getDBUser();
        }
        return null;
    }

    public DBUser selectUser() {
        String identOption = System.getProperty(PROP_DB_IDENT, DB_IDENT_DEFAULT);
        IndentValue ident = IndentValue.valueOf(identOption);
        if (ident == null) {
            LOG.warning("Value for 'cecilia.db.Identify' is no compatible with application: " + identOption);
            ident = IndentValue.ALWAYS;
        }
        String defaultUser = System.getProperty("user.name").toLowerCase();
        DBUser user = null;
        boolean showDlg = false;
        if (!this._withoutDlg && ident == IndentValue.ALWAYS) {
            showDlg = true;
        } else {
            DAOUser daoUser = this._daoFactory.createUserDAO();
            user = daoUser.findByLogin(defaultUser);
            if (user == null) {
                if (this._withoutDlg || ident == IndentValue.NEVER) {
                    this._appl.fatalError(ResMsgCore.msgFormat("MSG_USR_UNKNOW", defaultUser), ResMsgVoc.getString("VOC_ERROR"), true, false);
                } else {
                    showDlg = true;
                }
            }
        }
        if (showDlg) {
            user = this.selectUserWithDlg(defaultUser);
        }
        return user;
    }

    public static enum IndentValue {
        ALWAYS,
        NEVER,
        AS_NEEDED;

    }
}

