/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKTable;
import com.dassault.cecilia.core.cecilia.export.DBKTableModel;
import com.dassault.cecilia.core.cecilia.export.DBKWriter;
import com.dassault.cecilia.core.cecilia.export.ImageDefinition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBKOutput {
    private static Logger _LOG = Logger.getLogger(DBKOutput.class.getPackage().getName());
    public static final String PROP_EXPORT_WORD_JAVA_DEF = "java.exe -Xms128m -Xmx1024m";
    public static final String PROP_EXPORT_WORD_JAVA = "cecilia.export.wordxml.java";
    public static final String PROP_EXPORT_WORD_PATH_DEF = "./core/plugins/docbook";
    public static final String PROP_EXPORT_WORD_PATH = "cecilia.export.wordxml.path";
    public static final String PROP_EXPORT_WORD_JAR_DEF = "-jar ./core/plugins/WordXml.jar";
    public static final String PROP_EXPORT_WORD_JAR = "cecilia.export.wordxml.jar";
    public static final String PROP_EXPORT_DOCBOOK_DTD = "cecilia.export.docbook.dtd";
    public static final String PROP_EXPORT_DOCBOOK_DTD_DEFINE_DEFAULT = "<!DOCTYPE book PUBLIC \"-//OASIS//DTD DocBook XML V4.4//EN\" \"http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd\">\n";
    public static final String PROP_EXPORT_DOCBOOK_DTD_DEFINE = "cecilia.export.docbook.dtd.define";
    public static final String PROP_EXPORT_DOCBOOK_LANG = "cecilia.export.docbook.language";
    public static final String PROP_EXPORT_DOCBOOK_ENCODING_DEF = "iso-8859-15";
    public static final String PROP_EXPORT_DOCBOOK_ENCODING = "cecilia.export.docbook.encoding";
    protected DBKWriter _xmlWriter = null;
    protected File _xmlOutputFile = null;

    public DBKOutput(String xmlOutputFileName) throws IOException {
        this._xmlOutputFile = new File(xmlOutputFileName);
        try {
            this.createXMLOutputFile();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "IOException during create XMLOutputFile", e);
            this._xmlOutputFile = null;
            throw e;
        }
    }

    public DBKOutput(File xmlOutputFileName) throws IOException {
        this._xmlOutputFile = xmlOutputFileName;
        try {
            this.createXMLOutputFile();
        }
        catch (IOException e) {
            _LOG.log(Level.INFO, "IOException during create XMLOutputFile", e);
            this._xmlOutputFile = null;
            throw e;
        }
    }

    public void createXMLOutputFile() throws IOException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this._xmlOutputFile);
            this._xmlWriter = new DBKWriter(writer, "  ");
        }
        catch (IOException e1) {
            throw new IOException(ResMsgCore.msgFormat("FILE_ERROR_DURING_OPEN", this._xmlOutputFile));
        }
    }

    public void write(String add, boolean transform) throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.write(add, transform);
        }
    }

    public void writeChapter(String title) throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.write("<chapter>\n", false);
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write("<title>", false);
            this._xmlWriter.write(title, true);
            this._xmlWriter.write("</title>\n", false);
        }
    }

    public void writeSection(int niveau, String title) throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.write("<sect" + niveau + ">\n", false);
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write("<title>", false);
            this._xmlWriter.write(title, true);
            this._xmlWriter.write("</title>\n", false);
        }
    }

    public void writeEndSection(int niveau) throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</sect" + niveau + ">\n", false);
        }
    }

    public void writeEndChapter() throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</chapter>\n", false);
        }
    }

    public void printHeadXML() throws IOException {
        if (this._xmlWriter != null) {
            String lang;
            this._xmlWriter.write("<?xml version=\"1.0\" encoding=\"", false);
            String encoding = System.getProperty(PROP_EXPORT_DOCBOOK_ENCODING, PROP_EXPORT_DOCBOOK_ENCODING_DEF);
            this._xmlWriter.write(encoding, true);
            this._xmlWriter.write("\"?>\n", false);
            if (Boolean.getBoolean(PROP_EXPORT_DOCBOOK_DTD)) {
                String dtd = System.getProperty(PROP_EXPORT_DOCBOOK_DTD_DEFINE, PROP_EXPORT_DOCBOOK_DTD_DEFINE_DEFAULT);
                this._xmlWriter.write(dtd, false);
            }
            if ((lang = System.getProperty(PROP_EXPORT_DOCBOOK_LANG, null)) == null) {
                lang = System.getProperty("user.language", "en");
            }
            this._xmlWriter.write("<article lang=\"", false);
            this._xmlWriter.write(lang, true);
            this._xmlWriter.write("\">\n", false);
            this._xmlWriter.addIndent(1);
        }
    }

    public void insertTable(DBKTableModel tableModel) {
        if (this._xmlWriter != null) {
            DBKTable table = new DBKTable(this._xmlWriter, tableModel);
            table.insertTable();
        }
    }

    public void insertImage(String legende, String text, ImageDefinition ... images) throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.write("<para>\n", false);
            this._xmlWriter.addIndent(1);
            this._xmlWriter.write("<mediaobject>\n", false);
            this._xmlWriter.addIndent(1);
            if (text != null && text.length() > 0) {
                this._xmlWriter.write("<textobject>\n", false);
                this._xmlWriter.addIndent(1);
                this._xmlWriter.write("<para>\n", false);
                this._xmlWriter.addIndent(1);
                this._xmlWriter.write(text, true);
                this._xmlWriter.addIndent(-1);
                this._xmlWriter.write("</para>\n", false);
                this._xmlWriter.addIndent(-1);
                this._xmlWriter.write("</textobject>\n", false);
            }
            for (ImageDefinition image : images) {
                this._xmlWriter.write("<imageobject", false);
                String role = image.getRole();
                if (role != null && !role.isEmpty()) {
                    this._xmlWriter.write(" role='", false);
                    this._xmlWriter.write(role, true);
                    this._xmlWriter.write("'", false);
                }
                this._xmlWriter.write(">\n", false);
                this._xmlWriter.addIndent(1);
                this._xmlWriter.write(image.toString(), false);
                this._xmlWriter.addIndent(-1);
                this._xmlWriter.write("</imageobject>\n", false);
            }
            if (legende.length() > 0) {
                this._xmlWriter.write("<caption>\n", false);
                this._xmlWriter.addIndent(1);
                this._xmlWriter.write("<para>", false);
                this._xmlWriter.write(legende, true);
                this._xmlWriter.write("</para>\n", false);
                this._xmlWriter.addIndent(-1);
                this._xmlWriter.write("</caption>\n", false);
            }
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</mediaobject>\n", false);
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</para>\n", false);
        }
    }

    public void addIndent(int mod) {
        this._xmlWriter.addIndent(mod);
    }

    public int getIndent() {
        return this._xmlWriter.getIndent();
    }

    public void printFootXML() throws IOException {
        if (this._xmlWriter != null) {
            this._xmlWriter.addIndent(-1);
            this._xmlWriter.write("</article>", false);
            this._xmlWriter.close(true);
        }
    }

    public File getXmlOutputFile() {
        return this._xmlOutputFile;
    }

    public void close(boolean writer) throws IOException {
        this._xmlWriter.close(writer);
    }
}

