/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpContainer;
import com.dassault.cecilia.core.cecilia.export.ExpInfo;
import com.dassault.cecilia.core.cecilia.pref.GeneralTextPreferencies;
import com.dassault.cecilia.core.cecilia.pref.Preferencies;
import com.dassault.cecilia.core.cecilia.print.SrbInputStream;
import com.dassault.cecilia.core.plugin.PluginWithOptions;
import com.dassault.cecilia.dbobj.CECFactory;
import com.dassault.cecilia.lib.util.format.DoubleFormat;
import com.dassault.cecilia.lib.util.format.DoubleFormatJava;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;

public class ExpBook
extends ExpContainer {
    CECFactory _cecFactory;
    PageFormat _pageFormat;
    Preferencies _preferencies;
    DoubleFormat _doubleFormat;
    DateFormat _dateFormat;
    Map<File, File> _mapRefToImg = new HashMap<File, File>();
    int _currentLevelSection = 0;
    ExpInfo _info;

    public ExpBook(CECFactory cecFactory) {
        this._cecFactory = cecFactory;
        this._doubleFormat = new DoubleFormatJava();
        this._dateFormat = SimpleDateFormat.getInstance();
    }

    public PageFormat getPageFormat() {
        return this._pageFormat;
    }

    public ExpBook setPageFormat(PageFormat format) {
        this._pageFormat = format;
        return this;
    }

    public Preferencies getPreferencies() {
        return this._preferencies;
    }

    public ExpBook setPreferencies(Preferencies prefs) {
        this._preferencies = prefs;
        return this;
    }

    public DoubleFormat getDoubleFormat() {
        return this._doubleFormat;
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public CECFactory getDAOFactory() {
        return this._cecFactory;
    }

    public synchronized File getImagPath(File refFile) {
        if (refFile == null) {
            return null;
        }
        File resFile = this._mapRefToImg.get(refFile);
        if (resFile == null) {
            String path = refFile.getAbsolutePath();
            int posDot = path.lastIndexOf(46);
            if (posDot != -1 && posDot > path.length() - 5) {
                path = path.substring(0, posDot);
            }
            if ((resFile = new File(path + "_images")).isDirectory()) {
                resFile.getName();
                for (File child : resFile.listFiles()) {
                    child.delete();
                }
            }
            resFile.mkdir();
            this._mapRefToImg.put(refFile, resFile);
        }
        return resFile;
    }

    @Override
    public ExpBook getBook() {
        return this;
    }

    @Override
    protected int getCurrentLevelSection() {
        return this._currentLevelSection;
    }

    @Override
    protected void sectionIncrement() {
        ++this._currentLevelSection;
    }

    @Override
    protected void sectionDecrement() {
        --this._currentLevelSection;
    }

    public ExpBook setInfo(ExpInfo info) {
        this._info = info;
        this._info.setContainer(this);
        return this;
    }

    public String getTitle() {
        if (this._info != null) {
            return this._info._title;
        }
        return "<unknown>";
    }

    @Override
    public void writeDocbook(DBKOutput output) throws IOException {
        PluginWithOptions opts = this.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._doubleFormat = gpref.getDoubleFormat();
            this._dateFormat = gpref.getDateFormat();
        }
        output.printHeadXML();
        if (this._info != null) {
            this._info.writeDocbook(output);
        }
        super.writeDocbook(output);
        output.printFootXML();
    }

    @Override
    public void writeScribe(SrbInputStream scribe) throws IOException {
        PluginWithOptions opts = this.getPreferencies().getOptions(GeneralTextPreferencies.PREF_KEY);
        if (opts != null && opts instanceof GeneralTextPreferencies) {
            GeneralTextPreferencies gpref = (GeneralTextPreferencies)opts;
            this._doubleFormat = gpref.getDoubleFormat();
            this._dateFormat = gpref.getDateFormat();
        }
        scribe.concat("<GDOC SEC=''>\n");
        if (this._info != null) {
            this._info.writeScribe(scribe);
        } else {
            scribe.concat("<DOCNUM>\n");
            scribe.concat("<DATE>" + this.getCurrentDateAsDDMMYYYY() + "\n");
        }
        scribe.concat(".ti @\n");
        scribe.concat(".tp 5 7 18 20 30 35 40 50 60\n");
        scribe.concat("<BODY>\n");
        super.writeScribe(scribe);
        scribe.concat("<EGDOC>0\n");
    }
}

