/*
 * Decompiled with CFR 0.152.
 */
package com.dassault.cecilia.core.cecilia.export;

import com.dassault.cecilia.core.cecilia.ResMsgCore;
import com.dassault.cecilia.core.cecilia.export.DBKOutput;
import com.dassault.cecilia.core.cecilia.export.ExpBook;
import com.dassault.cecilia.core.cecilia.export.JChooserFileUtility;
import com.dassault.cecilia.core.plugin.Plugable;
import com.dassault.cecilia.core.swing.JOptionCecilia;
import com.dassault.cecilia.core.swing.other.FileFilterExtention;
import com.dassault.cecilia.db.DBFolder;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ExpBookUtility {
    private static Logger _LOG = Logger.getLogger(ExpBookUtility.class.getPackage().getName());
    static JFileChooser _dlgChoose = null;
    private static Map<KeyChoose, String> _mapFile = new HashMap<KeyChoose, String>();

    private ExpBookUtility() {
    }

    protected static JFileChooser getDlgChooser(JChooserFileUtility.Type type, Plugable plugable) {
        if (_dlgChoose == null) {
            _dlgChoose = new JFileChooser();
            JChooserFileUtility.configureCurrentDirectory(_dlgChoose, plugable);
        }
        JChooserFileUtility.configureFileFilter(_dlgChoose, type);
        return _dlgChoose;
    }

    public static File selectFile(JChooserFileUtility.Type type, Plugable plugable, Component owner, DBFolder dbFolder, String defaultFilename) {
        return ExpBookUtility.selectFile(type, plugable, owner, dbFolder, null, defaultFilename);
    }

    public static File selectFile(JChooserFileUtility.Type type, Plugable plugable, Component owner, DBFolder dbFolder, String optKey, String defaultFilename) {
        Component parent = JOptionCecilia.getTopContainerOf(owner);
        KeyChoose key = new KeyChoose(type, dbFolder, optKey, defaultFilename);
        JFileChooser dlg = ExpBookUtility.getDlgChooser(type, plugable);
        Object filename = _mapFile.get(key);
        if (filename == null && !((String)(filename = defaultFilename)).toUpperCase().endsWith(type.getExtension().toUpperCase())) {
            filename = (String)filename + type.getExtension();
        }
        dlg.setSelectedFile(new File(dlg.getCurrentDirectory(), (String)filename));
        if (dlg.showSaveDialog(parent) != 0) {
            return null;
        }
        File file = FileFilterExtention.addDefaultExtention(dlg);
        if (file == null) {
            return null;
        }
        if (plugable != null) {
            plugable.setOption("plugable.option.path", file.getParentFile().getAbsolutePath());
        }
        _mapFile.put(key, file.getName());
        if (!file.exists()) {
            return file;
        }
        int confirmResult = JOptionPane.showConfirmDialog(parent, ResMsgCore.msgFormat("FILE_MSG_EXIST_FRM", file), JOptionCecilia.getTopTitleOf(owner), 0);
        if (confirmResult == 0) {
            return file;
        }
        return null;
    }

    public static JChooserFileUtility.Type convertModelKey(String key) {
        JChooserFileUtility.Type type = null;
        if (key.equals("docbook.file")) {
            type = JChooserFileUtility.Type.DOCBOOK;
        } else if (key.equals("word.file")) {
            type = JChooserFileUtility.Type.WORD;
        }
        return type;
    }

    public static boolean realiseExport(ExpBook book, final File file, final Component owner) {
        try {
            DBKOutput xmlWriter = new DBKOutput(file);
            if (xmlWriter.getXmlOutputFile() != null) {
                book.writeDocbook(xmlWriter);
                return true;
            }
        }
        catch (Exception e) {
            _LOG.log(Level.INFO, "Exception lors de l'export Docbook du fichier '" + file.getAbsolutePath() + "'", e);
        }
        if (owner != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(JOptionCecilia.getTopContainerOf(owner), ResMsgCore.msgFormat("FILE_ERROR_DURING_EXPORT", file.getAbsolutePath()), JOptionCecilia.getTopTitleOf(owner), 0);
                }
            });
        }
        return false;
    }

    static class KeyChoose {
        JChooserFileUtility.Type _type;
        DBFolder _dbFolder;
        String _optional;
        String _defaultFilename;

        KeyChoose(JChooserFileUtility.Type type, DBFolder dbFolder, String opt, String defaultFilename) {
            this._type = type;
            this._dbFolder = dbFolder;
            this._optional = opt;
            this._defaultFilename = defaultFilename;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof KeyChoose) {
                KeyChoose other = (KeyChoose)obj;
                if (!this._type.equals((Object)other._type)) {
                    return false;
                }
                if (this._optional == null ? other._optional != null : !this._optional.equals(other._optional)) {
                    return false;
                }
                if (this._dbFolder == null) {
                    if (other._dbFolder != null) {
                        return false;
                    }
                    if (!this._defaultFilename.equals(other._defaultFilename)) {
                        return false;
                    }
                } else if (!this._dbFolder.equals(other._dbFolder)) {
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = this._type.hashCode();
            if (this._dbFolder != null) {
                hash += hash * 3 + this._dbFolder.hashCode();
            } else if (this._defaultFilename != null) {
                hash += hash * 3 + this._defaultFilename.hashCode();
            }
            if (this._optional != null) {
                hash += hash * 7 + this._optional.hashCode();
            }
            return hash;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append((Object)this._type);
            if (this._optional != null) {
                buffer.append("?").append(this._optional);
            }
            if (this._dbFolder != null) {
                buffer.append(":").append(this._dbFolder.getRefPath());
            }
            if (this._defaultFilename != null) {
                buffer.append(">").append(this._defaultFilename);
            }
            return buffer.toString();
        }
    }
}

